/* range.c
tells you the range of the articles in a newsgroup
by eric hollander hh@xcf.berkeley.edu
part of my news-by-mail package
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include <strings.h>

#include "lines.h"
#include "nntpcodes.h"

void usage() {
		fprintf(stderr, "usage:\n");
		fprintf(stderr, "range news.group\n");
		exit(1);
}

main(int argc, char *argv[]) {
	int len, index, lindex;
	int soc;	/* the socket */
	char buf[BUFSIZ];
	char *line;

	if(argc != 2) usage();

	soc = open_soc(nntp_server());

	if ((line = getline(soc)) == 0) {
		fprintf(stderr, "server not responding.\n");
		exit(1);
	}
	if(strncmp(line, WELCOME, 3) != 0) {
		fprintf(stderr, "server %s refused connection.\n",
			nntp_server());
		exit(1);
	}

	sprintf(buf, "group %s\n", argv[1]);
	write(soc, buf, strlen(buf));
	line = getline(soc);
	if(strncmp(line, NO_SUCH_GROUP, 3) == 0) {
		fprintf(stderr, "no such newsgroup\n");
		send_quit(soc);
		exit(1);
		}
	printf("%s", line);
	send_quit(soc);
}
