/* lines.c
break socket into lines, open news connection, etc
by eric hollander hh@xcf.berkeley.edu
part of my news-by-mail package
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include <strings.h>

#include "lines.h"

char *nntp_server() {
	/* get the name of the nntpserver
	we should use.  we prefer the environment variable, but
	if it's not set, use the compiled-in default */
	/* i don't understand why the (char *) is necessary in
	the return below... */
	if(getenv(SERVER_ENV)) return((char *) getenv(SERVER_ENV));
	else return(DEFAULT_SERVER);
}

int open_soc(char *hostname) {
	/* open the news socket */
	int soc;
	struct sockaddr_in server;
	struct hostent *hp;

	soc = socket(AF_INET, SOCK_STREAM, 6);
	if (soc < 0) {
		fprintf(stderr, "couldnt open socket error %i\n", soc);
		exit(1);
	}

	server.sin_family = AF_INET;
	hp = gethostbyname(hostname);
	if (!hp) {
		fprintf(stderr, "couldnt address for %s.\n", hostname);
		exit(2);
	}
	bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
	server.sin_port = htons(119);	/* host network byte order */
	if (connect(soc, &server, sizeof(server)) < 0) {
		perror("you die");
		exit(1);
	}
	return soc;
}

char *getline(int soc) {
	/* get the next line from the socket
	returns NULL if there is no next line */

	static int len = 0, index = 0, lindex = 0;
	static char buf[BUFSIZ], line[BUFSIZ];

	/* if there is nothing in the buffer already,
	we must read more in.  if there is some
	in the buffer, we go through it until we have
	a line.  if we read through it and don't get
	a complete line, we need to read
	another buffer.  if this read doesn't work,
	return NULL. */

	lindex = 0;	/* we always start at the beginning of the line */

	while(1) {
		while(((line[lindex] = buf[index]) != '\n') &&
			index < len) {
			lindex++;
			index++;
		}
		if((lindex > 0) && (line[lindex] == '\n')) {
			index++;
			line[lindex] = NULL;
			line[lindex - 1] = '\n';
			return line;
		}
		if(index == len) {
		/* we're at the end of the buffer */
			len = read(soc, buf, BUFSIZ);
			if(len == 0) { return NULL; }
			index = 0;
			}
	}
}

void send_quit(int soc) {
	write(soc, "quit\n", 5);
	close(soc);
}
