/****************************************************************************
  This file is part of the Freedom Remailer.  The encrypt_sub() function
  is borrowed from Andy Dustman's Encrypt-Subject patch to Matt Ghio's
  remailer distribution.  All changes and other code are:
  Copyright (C) 1997-1998  Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <syslog.h>
#include "idea.h"
#include "md5.h"
#include "freedom.h"

/* IDEA-encrypt MD5-hash of ##'ed Subject: line with MD5-hash of key.  */

void
encrypt_sub (const char *origfilename, const char *key)
{
  FILE *infile, *outfile;
  fpos_t pos;
  int headers = 1, colhead = 0, addhead = 0, linenum = 0, x;
  char line[BUFSIZ], tmpline[BUFSIZ];
  char *tempfilename = alloca (strlen (origfilename) + sizeof ("S"));
  struct MD5Context subjkeyDigest, subjectDigest;
  struct IdeaCfbContext subjcontext;
  unsigned char subjIDEAkey[16], subjPT[16];
  unsigned char subjCT[24];	/* Includes IV.  */
  char hexrand[9];

  MD5Init (&subjkeyDigest);
  MD5Update (&subjkeyDigest, (unsigned char *) key, strlen (key));
  MD5Final (subjIDEAkey, &subjkeyDigest);

  sprintf (tempfilename, "%sS", origfilename);
  rename (origfilename, tempfilename);

  if (!(infile = fopen (tempfilename, "r")))
    {
      outfile = fopen (origfilename, "w");
      fclose (outfile);
      return;
    }
  outfile = fopen (origfilename, "w");

  while (fgets (line, sizeof (line), infile))
    {
      if (!headers)
	{
	  if (linenum > colhead || !blank (line))
	    linenum++;
	  if (linenum == 1 && hdrmarks (line))
	    {
	      headers = 1;
	      colhead = 1;
	      fputs (line, outfile);
	    }
	  else if (linenum == colhead + 1 && hashmarks (line))
	    {
	      addhead = 1;
	      fputs (line, outfile);
	    }
	  else
	    {
	      if (addhead)
		{
		  /* Read RFC 822 multi-line headers.  */
		  while (1)
		    {
		      fgetpos (infile, &pos);
		      if (fgets (tmpline, sizeof (tmpline), infile)
			  && (tmpline[0] == ' ' || tmpline[0] == '\t'))
			strncat (line, tmpline,
				 sizeof (line) - strlen (line) - 1);
		      else
			break;
		    }
		  fsetpos (infile, &pos);

		  if (blank (line))
		    addhead = 0;
		  if (!strileft (line, "subject:"))
		    fputs (line, outfile);
		  else
		    {
		      if (USE_SYSLOG)
			syslog (LOG_DEBUG, "Encrypting %s", line);
		      flushleft (line, sizeof ("subject:") - 1);
		      chop (line);
		      MD5Init (&subjectDigest);
		      MD5Update (&subjectDigest, (unsigned char *) line,
				 strlen (line));
		      MD5Final (subjPT, &subjectDigest);
		      ideaCfbInit (&subjcontext, subjIDEAkey);
		      sprintf (hexrand, "%08x", rand ());
		      memcpy (subjCT, hexrand, 8);
		      memcpy (subjCT + 8, subjPT, 16);
		      ideaCfbEncrypt (&subjcontext, subjCT, subjCT, 24);
		      ideaCfbDestroy (&subjcontext);
		      fputs ("Subject: ", outfile);
		      for (x = 0; x < 24; x++)
			fprintf (outfile, "%2.2hx", subjCT[x]);
		      fputs ("\n", outfile);
		    }
		}
	      else
		{
		  if (linenum > colhead || !(blank (line)))
		    fputs (line, outfile);
		}
	    }
	}
      else
	{
	  if (!strileft (line, "encrypt-subject:"))
	    fputs (line, outfile);
	  if (blank (line))
	    headers = 0;
	}
    }
  fclose (infile);
  fclose (outfile);
  unlink (tempfilename);
}
