/****************************************************************************
  This file is part of the Freedom Remailer.  It is:
  Copyright (C) 1995  John B. Fleming (jfleming@indiana.edu)
  Changes are (C) 1997 Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

enum message_type scan_message(const char *infilename, char *to, char *from)
{
  int headers = 1, colhead = 0, linenum = 0, replyto = 0,
      ctflag = 0, esflag = 0, ekflag = 0, ltflag = 0, anflag = 0, ptflag = 0,
      urlflag = 0, htmlflag = 0, rrflag = 0;
  FILE *input;
  char line[BUFSIZ], tmpline[BUFSIZ], subj[BUFSIZ], url[BUFSIZ],
       cutmarks[BUFSIZ], encryptsub[BUFSIZ], encryptkey[BUFSIZ],
       latency[BUFSIZ];

  strcpy(to, ""); strcpy(from, "");

  input = fopen(infilename, "r");
  if (input == NULL)
    return NON_ANON;

  if (DEBUG) {
    printf("\nScanning message.\n");
    fflush(stdout);
  }
  while (fgets(line, sizeof(line), input)) {
    strcpy(tmpline, line);
    stringlower(tmpline);
    chop(tmpline);
    if (!headers) {
      if ((linenum > colhead) || (strlen(line) > 1))
	linenum++;
      if ((linenum == 1) && (strstr(line, "::") != NULL))
	headers = 1;
	colhead = 1;
    } else {
      if (strlen(line) <= 1) {
	headers = 0;
      } else {
	if (linenum == 0) { /* real headers */
	  if (strncmp(tmpline, "reply-to:", 9) == 0) {
	    strcpy(from, line + 9);
	    chop(from);
	    replyto = 1;
	  } else if (strncmp(tmpline, "from:", 5) == 0 && !replyto) {
	    strcpy(from, line + 5);
	    chop(from);
	  } else if (strncmp(tmpline, "subject: ", 9) == 0) {
	    strcpy (subj, tmpline + 9);
	    if (strcmp(subj, "help") == 0) {
	      strcpy(to, from);
	      return HELP_REQ;
	    } else if (strcmp(subj, "remailer-help") == 0) {
	      strcpy(to, from);
	      return HELP_REQ;
	    } else if (strcmp(subj, "freedom-help") == 0) {
	      strcpy(to, from);
	      return HELP_REQ;
	    } else if (strcmp(subj, "remailer-stats") == 0) {
	      strcpy(to, from);
	      return STATS_REQ;
	    } else if (strcmp(subj, "freedom-stats") == 0) {
	      strcpy(to, from);
	      return STATS_REQ;
	    } else if (strcmp(subj, "remailer-key") == 0) {
	      strcpy(to, from);
	      return KEY_REQ;
	    } else if (strcmp(subj, "freedom-key") == 0) {
	      strcpy(to, from);
	      return KEY_REQ;
	    }
	  }
	}
	if (strncmp(tmpline, "encrypted: pgp", 14) == 0) {
	  chop(line);
	  if (DEBUG) {
	    printf("%s detected.\n", line);
	    fflush(stdout);
	  }
	  return PGP_MESSAGE;
	} else if (strncmp(tmpline, "anon-to:", 8) == 0) {
	  if (!blocked(tmpline + 8, DEST_BLOCK)) {
	    strcat(to, "To:");
	    strcat(to, line + 8);
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	  anflag = 1;
	} else if (strncmp(tmpline, "request-remailing-to:", 21) == 0) {
	  if (!blocked(tmpline + 21, DEST_BLOCK)) {
	    strcat(to, "To:");
	    strcat(to, line + 21);
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	  anflag = 1;
	} else if (strncmp(tmpline, "remail-to:", 10) == 0) {
	  if (!blocked(tmpline + 10, DEST_BLOCK)) {
	    strcat(to, "To:");
	    strcat(to, line + 10);
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	  anflag = 1;
	} else if (strncmp(tmpline, "anon-send-to:", 13) == 0) {
	  if (!blocked(tmpline + 13, DEST_BLOCK)) {
	    strcat(to, "To:");
	    strcat(to, line + 13);
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	  anflag = 1;
	} else if (strncmp(tmpline, "anon-post-to:", 13) == 0) {
	  if (!blocked(tmpline + 13, GROUP_BLOCK)) {
#ifdef MAIL2NEWS
	    if (!ptflag) {
	      strcat(to, "To: ");
	      strcat(to, MAIL2NEWS);
	      strcat(to, "\n");
	      anflag = 1;
	    }
#endif /* MAIL2NEWS */
	    strcat(to, "Newsgroups:");
	    strcat(to, line + 13);
	    ptflag = 1;
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	} else if (strncmp(tmpline, "cutmarks:", 9) == 0) {
	  strcpy(cutmarks, line + 9);
	  chop(cutmarks);
	  ctflag = 1;
	} else if (strncmp(tmpline, "encrypt-subject:", 16) == 0) {
	  strcpy(encryptsub, line + 16);
	  chop(encryptsub);
	  esflag = 1;
	} else if (strncmp(tmpline, "encrypt-key:", 12) == 0) {
	  strcpy(encryptkey, line + 12);
	  chop(encryptkey);
	  ekflag = 1;
	} else if (strncmp(tmpline, "latent-time:", 12) == 0) {
	  strcpy(latency, line + 12);
	  chop(latency);
	  ltflag = 1;
	} /* The following directives are only evaluated in the ::'ed headers
	     to make sure that everything below the next blank line will be
	     remailed to the Return-To: address */
	  else if ((strncmp(tmpline, "get-url:", 8) == 0) && colhead) {
	  strcpy(url, line + 8);
	  chop(url);
	  urlflag = 1;
	} else if ((strncmp(tmpline, "get-html-source:", 16) == 0) && colhead) {
	  strcpy(url, line + 16);
	  chop(url);
	  htmlflag = 1;
	} else if ((strncmp(tmpline, "return-to:", 10) == 0) && colhead) {
	  strcpy(to, "To:");
	  strcat(to, line + 10);
	  rrflag = 1;
	} /* The Null: directive for bit-bucket mail makes sense only
	     in the ::'ed headers of encrypted cover traffic messages */
	  else if ((strncmp(tmpline, "null:", 5) == 0) && colhead) {
	  chop(line);
	  if (DEBUG) {
	    printf("%s detected.\n", line);
	    fflush(stdout);
	  }
	  return NULL_MESSAGE;
	}
      }
    }
  }
  fclose(input);

  if (urlflag) {
    if (!rrflag) {
      strcpy(to, "To: ");
      strcat(to, from);
      strcat(to, "\n");
    }
    strcpy(from, url);
    return URL_REQUEST;
  }
  if (htmlflag) {
    if (!rrflag) {
      strcpy(to, "To: ");
      strcat(to, from);
      strcat(to, "\n");
    }
    strcpy(from, url);
    return HTML_REQUEST;
  }

  /* process headers in order: cutmarks, encrypt-subject, encrypt-key,
     latent-time */
  /* if these don't exist, then remail or post the message if that is where
     it's headed; else, return NON_ANON to send it to the spool or bucket */

  if (ctflag) {
    strcpy(to, cutmarks);
    return CUTMARKS;
  }
  if (esflag) {
    strcpy(to, encryptsub);
    return ENCRYPT_SUB;
  }
  if (ekflag) {
    strcpy(to, encryptkey);
    return ENCRYPT_KEY;
  }
  if (ltflag) {
    strcpy(to, latency);
    return LATENT_TIME;
  }
  if (ptflag)
#ifdef MAIL2NEWS
    return ANON_MESSAGE;
#else /* !MAIL2NEWS */
    return ANON_POST;
#endif /* MAIL2NEWS */
  if (anflag)
    return ANON_MESSAGE;

  return NON_ANON;
}

void remove_headers(const char *in, char *out, const char *to)
{
  FILE *infile, *outfile;
  int headers = 1, colhead = 0, addhead = 0, linenum = 0;
  char line[BUFSIZ], tmpline [BUFSIZ];

  infile = fopen(in, "r");
  if (infile == NULL) {
    outfile = fopen(out, "w");
    fclose(outfile);
    return;
  }
  outfile = fopen(out, "w");
  fputs(to, outfile);

  while (fgets(line, sizeof(line), infile)) {
    if (!headers) {
      if ((linenum > colhead) || (strlen(line) > 1))
	linenum++;
      if ((linenum == 1) && (strstr(line, "::") != NULL)) {
	headers = 1;
	colhead = 1;
      } else if (linenum == (colhead + 1)) {
	if (strstr(line, "##") != NULL) {
	  addhead = 1;
	} else {
	  fputs("Subject: None\n\n", outfile);
	  fputs(line, outfile);
	}
      } else {
	if (addhead) {
	  if (strlen(line) <= 1)
	    addhead = 0;
	  strcpy(tmpline, line);
	  stringlower(tmpline);
	  chop(tmpline);
	  if (!blocked(tmpline, HDRFILTER)) {
	    if ((strncmp(tmpline, "to:", 3) == 0) ||
		(strncmp(tmpline, "cc:", 3) == 0)) {
	      if (!blocked(tmpline + 3, DEST_BLOCK)) {
		fputs(line, outfile);
	      } else {
		if (DEBUG) {
		  printf("Blocked %s", line);
		  fflush(stdout);
		}
	      }
	    } else if (strncmp(tmpline, "bcc:", 4) == 0) {
	      if (!blocked(tmpline + 4, DEST_BLOCK)) {
		fputs(line, outfile);
	      } else {
		if (DEBUG) {
		  printf("Blocked %s", line);
		  fflush(stdout);
		}
	      }
	    } else if (strncmp(tmpline, "reply-to:", 9) == 0) {
	      if (!blocked(tmpline + 9, DEST_BLOCK)) {
		fputs(line, outfile);
	      } else {
		if (DEBUG) {
		  printf("Blocked %s", line);
		  fflush(stdout);
		}
	      }
	    } else if (strncmp(tmpline, "newsgroups:", 11) == 0) {
	      if (!blocked(tmpline + 11, GROUP_BLOCK)) {
		fputs(line, outfile);
	      } else {
		if (DEBUG) {
		  printf("Blocked %s", line);
		  fflush(stdout);
		}
	      }
	    } else {
	      fputs(line, outfile);
	    }
	  } else {
	    if (DEBUG) {
	      printf("Blocked %s", line);
	      fflush(stdout);
	    }
	  }
	} else {
	  if ((linenum > colhead) || (strlen(line) > 1))
	    fputs(line, outfile);
	}
      }
    } else {
      if (strlen(line) <= 1)
	headers = 0;
    }
  }
  fclose(infile);
  fclose(outfile);
}

void stringlower(char *string)
{
  unsigned int i;
  for (i = 0; i < strlen(string); i++)
    string[i] = tolower(string[i]);
}
