/* Header file for the Freedom Remailer
   1995 jfleming@indiana.edu
   1997 hanne@squirrel.owl.de */

#ifndef FREEDOM_H
#define FREEDOM_H

/* updatestats() argument values */
enum stats_flag {
  STATS_MESSAGE,
  STATS_PGP,
  STATS_LATENT,
  STATS_WWW,
  STATS_POST,
  STATS_HELP,
  STATS_KEY,
  STATS_STAT
};

/* scan_message() return values */
enum message_type {
  NON_ANON,
  NULL_MESSAGE,
  PGP_MESSAGE,
  ANON_MESSAGE,
  ANON_POST,
  STATS_REQ,
  HELP_REQ,
  KEY_REQ,
  CUTMARKS,
  ENCRYPT_SUB,
  ENCRYPT_KEY,
  LATENT_TIME,
  URL_REQUEST,
  HTML_REQUEST
};

/* function prototypes */
enum message_type scan_message(const char *, char *, char *);
void remove_headers(const char *, char *, const char *);
void stringlower(char *);
int rxmatch(const char *, const char *);
void pgpdecrypt(const char *, char *);
void chop(char *);
int blocked(const char *, const char *);
void cut(char *, char *, const char *, const char *, const int);
void mailhelp(const char *);
void mailkey(const char *);
void queuelatent(const char *, char *, char *, const char *);
int parsetime(const char *, const int);
void runlatentqueue(void);
void encrypt_key(const char *, char *, const char *);
void mailurl(const char *, const char *, const char *, char *, const int);
void encrypt_sub(char *, const char *);
int scan_subject(const char *);
void updatestats(enum stats_flag);
void mailstats(const char *);
char* genid(void);

#endif /* FREEDOM_H */
