---------|---------|---------|---------|---------|---------|---------|---------|
-- Author          :  Tom Vu                                     
-- Date            :  09/27/97                                  
-- Description	   :  Left and Right 32-bit registers               
-- -----------------------------------------------------------------------------
library ieee;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;


-- -----------------------------------------------------------------------------
entity IP is

port(
	IP_IN     	: in     std_logic_vector(63 downto 0);
       	IP_OUT   	: out    std_logic_vector(63 downto 0)
    );

end IP;

-- -----------------------------------------------------------------------------
architecture beh of IP is
-- -----------------------------------------------------------------------------
subtype small_integer is INTEGER range 0 to 63;
type IP_TYPE is array(0 to 63) of small_integer;

signal IP_TABLE : IP_TYPE;

begin

IP_TABLE <= 	(39, 7,47,15,55,23,63,31,
		 38, 6,46,14,54,22,62,30,
		 37, 5,45,13,53,21,61,29,
		 36, 4,44,12,52,20,60,28,
		 35, 3,43,11,51,19,59,27,
		 34, 2,42,10,50,18,58,26,
		 33, 1,41, 9,49,17,57,25,
		 32, 0,40, 8,48,16,56,24);	

-- -----------------------------------------------------------------------------
IP_PR: process(IP_TABLE,IP_IN)
-- -----------------------------------------------------------------------------
begin
	for i in 0 to 63 loop
	    IP_OUT(IP_TABLE(i)) <= IP_IN(i);
	end loop;
end process IP_PR;
-- -----------------------------------------------------------------------------
end beh;
-- -----------------------------------------------------------------------------
