/* passcache-3.c - timeout tests for PggPasscache policy TIMEOUT
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


int main()
{
    INIT_STD_TEST(PggPasscache, passcache);
    
    pgg_passcache_set_policy(passcache, PGG_PASSCACHE_POLICY_TIMEOUT, errenv);
    pgg_passcache_set_timeout(passcache, 2, errenv);
    
    pgg_passcache_set_passphrase(passcache, "0101010101010101", "passphrase 1", errenv);
    pgg_passcache_set_passphrase(passcache, "2020202020202020", "passphrase 2", errenv);
    
    sleep(1);
    pgg_passcache_get_passphrase(passcache, "0101010101010101", errenv);
    pgg_passcache_get_passphrase(passcache, "2020202020202020", errenv);
    expect_success();
    
    sleep(1);
    pgg_passcache_get_passphrase(passcache, "0101010101010101", errenv);
    expect_failure();
    pgg_passcache_get_passphrase(passcache, "2020202020202020", errenv);
    expect_failure();
    
    return 0;
}


