/* ssl/bio_ssl.c */
/* Copyright (C) 1995-1997 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@mincom.oz.au).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@mincom.oz.au)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@mincom.oz.au)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "buffer.h"
#include "err.h"
#include "ssl.h"

#ifndef NOPROTO
static int ssl_write(BIO *h,char *buf,int num);
static int ssl_read(BIO *h,char *buf,int size);
static int ssl_puts(BIO *h,char *str);
static long ssl_ctrl(BIO *h,int cmd,long arg1,char *arg2);
static int ssl_new(BIO *h);
static int ssl_free(BIO *data);
static int ssl_startup(BIO *b);
#else
static int ssl_write();
static int ssl_read();
static int ssl_puts();
static long ssl_ctrl();
static int ssl_new();
static int ssl_free();
static int ssl_startup();
#endif

static BIO_METHOD methods_sslp=
	{
	BIO_TYPE_SSL,"ssl",
	ssl_write,
	ssl_read,
	ssl_puts,
	NULL, /* ssl_gets, */
	ssl_ctrl,
	ssl_new,
	ssl_free,
	};

BIO_METHOD *BIO_f_ssl()
	{
	return(&methods_sslp);
	}

static int ssl_new(bi)
BIO *bi;
	{
	bi->init=0;
	bi->ptr=NULL;	/* The SSL structure */
	bi->flags=0;
	return(1);
	}

static int ssl_free(a)
BIO *a;
	{
	if (a == NULL) return(0);
	if (a->shutdown)
		{
		if (a->init) SSL_free((SSL *)a->ptr);
		a->init=0;
		a->flags=0;
		a->ptr=NULL;
		}
	return(1);
	}
	
static int ssl_read(b,out,outl)
BIO *b;
char *out;
int outl;
	{
	int ret=0;
	int inflags,outflags;
	SSL *ssl;

	if (out == NULL) return(0);
	ssl=(SSL *)b->ptr;

	/* do we actually need to do the startup protocol */
	if (!SSL_is_init_finished(ssl))
		{
		if (outl != 0)
			b->flags|=(BIO_FLAGS_PROTOCOL_STARTUP|
				BIO_FLAGS_PROTOCOL_DELAYED_READ);
		ret=ssl_startup(b);
		if (ret <= 0) return(ret);
		inflags=outflags=b->flags;
		outflags&= ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY|
			BIO_FLAGS_PROTOCOL_DELAYED_READ|
			BIO_FLAGS_PROTOCOL_DELAYED_WRITE|
			BIO_FLAGS_PROTOCOL_STARTUP);
		if (inflags|BIO_FLAGS_PROTOCOL_DELAYED_READ)
			outflags|= BIO_FLAGS_READ|BIO_FLAGS_SHOULD_RETRY;
		if (inflags|BIO_FLAGS_PROTOCOL_DELAYED_WRITE)
			outflags|= BIO_FLAGS_WRITE|BIO_FLAGS_SHOULD_RETRY;
		b->flags=outflags;
		return(-1);
		}

	/* connection is establish, lets do a read */
	ret=SSL_read(ssl,out,outl);

	if (ret <= 0)
		{
		b->flags&= ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY);
		b->flags|= BIO_FLAGS_READ;
		if (SSL_want_x509_lookup(ssl) || BIO_should_retry(ssl->rbio))
			b->flags|=BIO_FLAGS_SHOULD_RETRY;
		}
	return(ret);
	}

static int ssl_write(b,in,inl)
BIO *b;
char *in;
int inl;
	{
	int ret;
	int inflags,outflags;
	SSL *ssl;

	ssl=(SSL *)b->ptr;

	/* are we actually need to do the startup protocol */
	if (!SSL_is_init_finished(ssl))
		{
		if (inl != 0)
			b->flags|=(BIO_FLAGS_PROTOCOL_STARTUP|
				BIO_FLAGS_PROTOCOL_DELAYED_WRITE);
		ret=ssl_startup(b);
		if (ret <= 0) return(ret);
		inflags=outflags=b->flags;
		outflags&= ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY|
			BIO_FLAGS_PROTOCOL_DELAYED_READ|
			BIO_FLAGS_PROTOCOL_DELAYED_WRITE|
			BIO_FLAGS_PROTOCOL_STARTUP);
		if (inflags|BIO_FLAGS_PROTOCOL_DELAYED_READ)
			outflags|= BIO_FLAGS_READ|BIO_FLAGS_SHOULD_RETRY;
		if (inflags|BIO_FLAGS_PROTOCOL_DELAYED_WRITE)
			outflags|= BIO_FLAGS_WRITE|BIO_FLAGS_SHOULD_RETRY;
		b->flags=outflags;
		return(-1);
		}

	ret=SSL_write(ssl,in,inl);

	if (ret <= 0)
		{
		b->flags&= ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY);
		b->flags|=BIO_FLAGS_WRITE;
		if (SSL_want_x509_lookup(ssl) || BIO_should_retry(ssl->wbio))
			b->flags|=BIO_FLAGS_SHOULD_RETRY;
		}
	return(ret);
	}

static long ssl_ctrl(b,cmd,num,ptr)
BIO *b;
int cmd;
long num;
char *ptr;
	{
	SSL **sslp,*ssl;
	long ret=1;

	ssl=(SSL *)b->ptr;
	switch (cmd)
		{
	case BIO_CTRL_RESET:
		SSL_clear(ssl);
		break;
	case BIO_CTRL_EOF:
	case BIO_CTRL_INFO:
		ret=0;
		break;
	case BIO_CTRL_SET:
		ssl_free(b);
		b->shutdown=(int)num;
		b->ptr=ptr;
		b->init=1;
		break;
	case BIO_CTRL_GET:
		if (ptr != NULL)
			{
			sslp=(SSL **)ptr;
			*sslp=ssl;
			}
		break;
	case BIO_CTRL_GET_CLOSE:
		ret=b->shutdown;
		break;
	case BIO_CTRL_SET_CLOSE:
		b->shutdown=(int)num;
		break;
	case BIO_CTRL_PENDING:
		ret=SSL_pending(ssl);
		if (ret == 0)
			ret=BIO_pending(ssl->rbio);
		break;
	case BIO_CTRL_FLUSH:
		ret=BIO_ctrl(ssl->wbio,cmd,num,ptr);
		break;
	case BIO_CTRL_PUSH:
		if (b->next_bio != NULL)
			SSL_set_bio(ssl,b->next_bio,b->next_bio);
		break;
	case BIO_CTRL_POP:
		/* ugly bit of a hack */
		if (ssl->rbio != ssl->wbio) /* we are in trouble :-( */
			{
			BIO_free(ssl->wbio);
			}
		ssl->wbio=NULL;
		ssl->rbio=NULL;
		break;
	default:
		return(0);
		break;
		}
	return(ret);
	}

#ifdef undef
static int ssl_gets(bp,buf,size)
BIO *bp;
char *buf;
int size;
	{
	return(-1);
	}
#endif

static int ssl_puts(bp,str)
BIO *bp;
char *str;
	{
	int n,ret;

	n=strlen(str);
	ret=ssl_write(bp,str,n);
	return(ret);
	}

static int ssl_startup(b)
BIO *b;
	{
	int ret,f=0;
	SSL *ssl;
	
	ssl=(SSL *)b->ptr;
	b->flags&= ~BIO_FLAGS_IO_SPECIAL;

	if (SSL_in_accept_init(ssl))
		{
		ret=SSL_accept(ssl);

		if (ret <= 0)
			{
			f=b->flags& ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY);

			if (SSL_want_read(ssl))
				{
				f|=BIO_FLAGS_READ;
				if (BIO_should_retry(ssl->rbio))
					f|=BIO_FLAGS_SHOULD_RETRY;
				}
			if (SSL_want_write(ssl))
				{
				f|=BIO_FLAGS_WRITE;
				if (BIO_should_retry(ssl->wbio))
					f|=BIO_FLAGS_SHOULD_RETRY;
				}
			if (SSL_want_x509_lookup(ssl))
				f|=BIO_FLAGS_IO_SPECIAL;
			b->flags=f;
			return(ret);
			}
		/* Everything worked */
		}
	else if (SSL_in_connect_init(ssl))
		{
		ret=SSL_connect(ssl);

		if (ret <= 0)
			{
			f=b->flags& ~(BIO_FLAGS_RW|BIO_FLAGS_SHOULD_RETRY);

			if (SSL_want_read(ssl))
				{
				f|=BIO_FLAGS_READ;
				if (BIO_should_retry(ssl->rbio))
					f|=BIO_FLAGS_SHOULD_RETRY;
				}
			if (SSL_want_write(ssl))
				{
				f|=BIO_FLAGS_WRITE;
				if (BIO_should_retry(ssl->wbio))
					f|=BIO_FLAGS_SHOULD_RETRY;
				}
			if (SSL_want_x509_lookup(ssl))
				f|=BIO_FLAGS_IO_SPECIAL;
			b->flags=f;
			return(ret);
			}
		/* Everything worked */
		}
	else
		{
		/* Unknown state */
		SSLerr(SSL_F_SSL_STARTUP,SSL_R_UNDEFINED_INIT_STATE);
		return(-1);
		}
	return(1);
	}
