#ifndef _xfs_h
#define _xfs_h

#include <xfs/xfs_common.h>
#include <xfs/xfs_node.h>

#include <sys/types.h>

/*
 * Filesystem struct.
 */
struct xfs {
  u_int status;		/* Inited, opened or mounted */
#define XFS_MOUNTED	0x1
  struct vfs *vfsp;
  struct xfs_node *root;
  u_int nnodes;

  struct xfs_node *nodes;		/* replace with hash table */
  int fd;
};

#define VFS_TO_XFS(v)      ((struct xfs *) ((v)->vfs_data))
#define XFS_TO_VFS(x)      ((x)->vfsp)

#define XFS_FROM_VNODE(vp) VFS_TO_XFS((vp)->v_vfsp)
#define XFS_FROM_XNODE(xp) XFS_FROM_VNODE(XNODE_TO_VNODE(xp))

extern struct xfs xfs[];

extern struct vnodeops xfs_vnodeops;

struct xfs_node *xfs_node_find _PARAMS((struct xfs *, struct xfs_handle *));
struct xfs_node *new_xfs_node _PARAMS((struct xfs *, struct xfs_msg_node *));
void free_xfs_node _PARAMS((struct xfs_node *));
void free_all_xfs_nodes _PARAMS((struct xfs *xfsp));

extern int 
xfs_dnlc_enter _PARAMS((struct vnode *, char *, struct vnode *));
extern struct vnode *
xfs_dnlc_lookup _PARAMS((struct vnode *, char *));
extern void xfs_dnlc_purge _PARAMS((void));

void
xfs_attr2vattr _PARAMS((const struct xfs_attr *xa, struct vattr *va));

void
vattr2xfs_attr _PARAMS((const struct vattr *va, struct xfs_attr *xa));

#endif /* _xfs_h */
