#!/usr/local/bin/perl
#
# The inner loop instruction sequence and the IP/FP modifications are from
# Svend Olaf Mikkelsen <svolaf@inet.uni-c.dk>
#

$prog="des-som2.pl";

# base code is in microsft
# op dest, source
# format.
#

require "desboth.pl";

if (	($ARGV[0] eq "elf"))
	{ require "x86unix.pl"; }
elsif (	($ARGV[0] eq "a.out"))
	{ $aout=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "sol"))
	{ $sol=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "cpp"))
	{ $cpp=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "win32"))
	{ require "x86ms.pl"; }
else
	{
	print STDERR <<"EOF";
Pick one target type from
	elf	- linux, FreeBSD etc
	a.out	- old linux
	sol	- x86 solaris
	cpp	- format so x86unix.cpp can be used
	win32	- Windows 95/Windows NT
EOF
	exit(1);
	}

&comment("Don't even think of reading this code");
&comment("It was automatically generated by $prog");
&comment("Which is a perl program used to generate the x86 assember for");
&comment("any of elf, a.out, Win32, or Solaris");
&comment("It can be found in SSLeay 0.6.5+ or in libdes 3.26+");
&comment("eric <eay\@mincom.oz.au>");
&comment("The inner loop instruction sequence and the IP/FP modifications");
&comment("are from Svend Olaf Mikkelsen <svolaf\@inet.uni-c.dk>");

&comment("");

&file("dx86xxxx");

$L="edi";
$R="esi";

&des_encrypt("des_encrypt",1);
&des_encrypt("des_encrypt2",0);

&des_encrypt3("des_encrypt3",1);
&des_encrypt3("des_decrypt3",0);

&file_end();

sub des_encrypt
	{
	local($name,$do_ip)=@_;

	&function_begin($name,3);

	&comment("");
	&comment("Load the 2 words");
	&mov("eax",&wparam(0));
	&mov($R,&DWP(0,"eax","",0));
	&mov($L,&DWP(4,"eax","",0));

	if ($do_ip)
		{
		&comment("");
		&comment("IP");
		&IP_new($R,$L,"eax",3);
#		&comment("");
#		&comment("fixup rotate");
#		&rotl($R,3);
#		&rotl($L,3);
		}
	else
		{
		&comment("");
		&comment("fixup rotate");
		&rotl($R,3);
		&rotl($L,3);
		}

	&comment("");
	&comment("load counter, key_schedule and enc flag");

	# encrypting part

	$ks="ebp";
#	&xor(	"ebx",		"ebx"		);
	&mov("eax",&wparam(2));	# get encrypt flag
	&xor(	"ecx",		"ecx"		);
	&cmp("eax","0");
	&mov(	$ks,		&wparam(1)	);
	&je(&label("start_decrypt"));

	for ($i=0; $i<16; $i+=2)
		{
		&comment("");
		&comment("Round $i");
		&D_ENCRYPT($i,$L,$R,$i*2,$ks,"des_SPtrans","eax","ebx","ecx","edx");

		&comment("");
		&comment("Round ".sprintf("%d",$i+1));
		&D_ENCRYPT($i+1,$R,$L,($i+1)*2,$ks,"des_SPtrans","eax","ebx","ecx","edx");
		}
	&jmp(&label("end"));

	&set_label("start_decrypt");

	for ($i=15; $i>0; $i-=2)
		{
		&comment("");
		&comment("Round $i");
		&D_ENCRYPT(15-$i,$L,$R,$i*2,$ks,"des_SPtrans","eax","ebx","ecx","edx");
		&comment("");
		&comment("Round ".sprintf("%d",$i-1));
		&D_ENCRYPT(15-$i+1,$R,$L,($i-1)*2,$ks,"des_SPtrans","eax","ebx","ecx","edx");
		}

	&set_label("end");

	if ($do_ip)
		{
#		&comment("");
#		&comment("Fixup");
#		&rotr($L,3);		# r
#		&rotr($R,3);		# l
		&comment("");
		&comment("FP");
		&FP_new($R,$L,"eax",3);
		}
	else
		{
		&comment("");
		&comment("Fixup");
		&rotr($L,3);		# r
		&rotr($R,3);		# l
		}

	&mov("eax",&wparam(0));
	&mov(&DWP(0,"eax","",0),$L);
	&mov(&DWP(4,"eax","",0),$R);

	&function_end($name);
	}

sub D_ENCRYPT
	{
	local($r,$L,$R,$S,$ks,$desSP,$u,$tmp1,$tmp2,$t)=@_;

	&mov(	$u,		&DWP(&n2a($S*4),$ks,"",0));
	&xor(	$tmp1,		$tmp1);
	&mov(	$t,		&DWP(&n2a(($S+1)*4),$ks,"",0));
	&xor(	$u,		$R);
	&xor(	$t,		$R);
	&and(	$u,		"0xfcfcfcfc"	);
	&and(	$t,		"0xcfcfcfcf"	);
	&movb(	&LB($tmp1),	&LB($u)	);
	&movb(	&LB($tmp2),	&HB($u)	);
	&rotr(	$t,		4		);
	&mov(	$ks,		&DWP("      $desSP",$tmp1,"",0));
	&movb(	&LB($tmp1),	&LB($t)	);
	&xor(	$L,		$ks);
	&mov(	$ks,		&DWP("0x200+$desSP",$tmp2,"",0));
	&xor(	$L,		$ks); ######
	&movb(	&LB($tmp2),	&HB($t)	);
	&shr(	$u,		16);
	&mov(	$ks,		&DWP("0x100+$desSP",$tmp1,"",0));
	&xor(	$L,		$ks); ######
	&movb(	&LB($tmp1),	&HB($u)	);
	&shr(	$t,		16);
	&mov(	$ks,		&DWP("0x300+$desSP",$tmp2,"",0));
	&xor(	$L,		$ks);
	&mov(	$ks,		&DWP(24,"esp","",0)); ####
	&movb(	&LB($tmp2),	&HB($t)	);
	&and(	$u,		"0xff"	);
	&and(	$t,		"0xff"	);
	&mov(	$tmp1,		&DWP("0x600+$desSP",$tmp1,"",0));
	&xor(	$L,		$tmp1);
	&mov(	$tmp1,		&DWP("0x700+$desSP",$tmp2,"",0));
	&xor(	$L,		$tmp1);
	&mov(	$tmp1,		&DWP("0x400+$desSP",$u,"",0));
	&xor(	$L,		$tmp1);
	&mov(	$tmp1,		&DWP("0x500+$desSP",$t,"",0));
	&xor(	$L,		$tmp1);
	}

sub PERM_OP
	{
	local($a,$b,$tt,$shift,$mask)=@_;

	&mov(	$tt,		$a		);
	&shr(	$tt,		$shift		);
	&xor(	$tt,		$b		);
	&and(	$tt,		$mask		);
	&xor(	$b,		$tt		);
	&shl(	$tt,		$shift		);
	&xor(	$a,		$tt		);
	}

sub IP
	{
	local($l,$r,$tt)=@_;

	&PERM_OP($r,$l,$tt, 4,"0x0f0f0f0f");
	&PERM_OP($l,$r,$tt,16,"0x0000ffff");
	&PERM_OP($r,$l,$tt, 2,"0x33333333");
	&PERM_OP($l,$r,$tt, 8,"0x00ff00ff");
	&PERM_OP($r,$l,$tt, 1,"0x55555555");
	}

sub FP
	{
	local($l,$r,$tt)=@_;

	&PERM_OP($l,$r,$tt, 1,"0x55555555");
        &PERM_OP($r,$l,$tt, 8,"0x00ff00ff");
        &PERM_OP($l,$r,$tt, 2,"0x33333333");
        &PERM_OP($r,$l,$tt,16,"0x0000ffff");
        &PERM_OP($l,$r,$tt, 4,"0x0f0f0f0f");
	}

sub n2a
	{
	sprintf("%d",$_[0]);
	}

# now has a side affect of rotating $a by $shift
sub R_PERM_OP
	{
	local($a,$b,$tt,$shift,$mask,$last)=@_;

	&rotl(	$a,		$shift		) if ($shift != 0);
	&mov(	$tt,		$b		);
	&xor(	$tt,		$a		);
	&and(	$tt,		$mask		);
	if ($last eq $b)
		{
		&xor(	$a,		$tt		);
		&xor(	$b,		$tt		);
		}
	else
		{
		&xor(	$b,		$tt		);
		&xor(	$a,		$tt		);
		}
	&comment("");
	}

sub IP_new
	{
	local($l,$r,$tt,$lr)=@_;

	&R_PERM_OP($l,$r,$tt, 4,"0xf0f0f0f0",$l);
	&R_PERM_OP($r,$l,$tt,20,"0xfff0000f",$l);
	&R_PERM_OP($r,$l,$tt,14,"0x33333333",$r);
	&R_PERM_OP($l,$r,$tt,22,"0x03fc03fc",$r);
	&R_PERM_OP($l,$r,$tt, 9,"0xaaaaaaaa",$r);
	
	if ($lr != 3)
		{
		if (($lr-3) < 0)
			{ &rotr($l,	3-$lr); }
		else	{ &rotl($l,	$lr-3); }
		}
	if ($lr != 2)
		{
		if (($lr-2) < 0)
			{ &rotr($r,	2-$lr); }
		else	{ &rotl($r,	$lr-2); }
		}
	}

sub FP_new
	{
	local($r,$l,$tt,$lr)=@_;

	if ($lr != 2)
		{
		if (($lr-2) < 0)
			{ &rotl($r,	2-$lr); }
		else	{ &rotr($r,	$lr-2); }
		}
	if ($lr != 3)
		{
		if (($lr-3) < 0)
			{ &rotl($l,	3-$lr); }
		else	{ &rotr($l,	$lr-3); }
		}

	&R_PERM_OP($l,$r,$tt, 0,"0xaaaaaaaa",$r);
	&R_PERM_OP($l,$r,$tt,23,"0x03fc03fc",$r);
	&R_PERM_OP($l,$r,$tt,10,"0x33333333",$l);
	&R_PERM_OP($r,$l,$tt,18,"0xfff0000f",$l);
	&R_PERM_OP($r,$l,$tt,12,"0xf0f0f0f0",$r);
	&rotr($l	, 4);
	}

