/*
 # $Id: misc.c,v 1.7 1998/11/08 00:41:07 fbm Exp fbm $
 # Copyright (C) 1997,1998 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       used, resold, redeveloped, rewritten, enhanced or otherwise
 #       employed by a commercial organisation, or as part of a commercial
 #       venture, without first obtaining the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  To the extent permitted by applicable law, this software is
 #       provided "as-is", without warranty of any kind, including
 #       without limitation, the warrantees of merchantability,
 #       freedom from defect, non-infringment, and fitness for
 #       purpose.  In no event shall the author be liable for any
 #       direct, indirect or consequential damages however arising
 #       and however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay
 # Wayfarer Systems Pty Ltd		contact@fortify.net
 */

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include "misc.h"

void *
f_malloc(size_t sz)
{
	void	*p;
	p = malloc(sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

void *
f_realloc(void *s, size_t sz)
{
	void	*p;
	p = s? realloc(s, sz): malloc(sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

void *
f_calloc(size_t n, size_t sz)
{
	void	*p;
	p = calloc(n, sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

char *
f_strdup(const char *s)
{
	char	*p;
	p = strdup(s);
	if (p == (char *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

char *
f_strndup(const char *s, int n)
{
	char	*p;
	p = (char *) f_calloc(n+1, sizeof(char));
	strncpy(p, s, n);
	return p;
}

char *
seg_name(int i)
{
	if (i == SEG_TEXT)
		return "text";
	if (i == SEG_DATA)
		return "data";
	if (i == SEG_RODATA)
		return "rodata";
	return "?unknown?";
}

int
isnumeric(char *s)
{
	while (isdigit(*s))
		s++;
	return (*s == '\0');
}

int
zread(int fd, char *b, int n, char *msg)
{
	int	i;

	i = read(fd, b, n);
	if (i != n) {
		fprintf(stderr, "Read error: %s: (%d != %d)\n", msg, i, n);
		exit(1);
	}
	return i;
}

void
zlseek(int fd, off_t off, char *msg)
{
	off_t	o;

	o = lseek(fd, off, SEEK_SET);
	if (o != off) {
		fprintf(stderr, "Lseek error: %s: (%d != %d)\n", msg, (int) o, (int) off);
		exit(1);
	}
}

unsigned short
toShort(unsigned char *p)
{
	return (unsigned short) (p[0] | (p[1] << 8));
}

unsigned long
toLong(unsigned char *p)
{
	return (unsigned long) ((p[0]) | (p[1] << 8) | (p[2] << 16) | (p[3] << 24));
}
