#ifndef _xfs_dev_h
#define _xfs_dev_h

#include <xfs/xfs_common.h>
#include <sys/uio.h>

extern int xfs_devopen _PARAMS((dev_t dev, int flags));
extern int xfs_devclose _PARAMS((dev_t dev, int flags));
extern int xfs_devread _PARAMS((dev_t dev, struct uio *uiop));
extern int xfs_devwrite _PARAMS((dev_t dev, struct uio *uiop));
extern int xfs_devioctl _PARAMS((dev_t dev, int cmd, caddr_t data, int flags));
extern int xfs_devselect _PARAMS((dev_t dev, int rw));

extern int xfs_install_device _PARAMS((void));
extern int xfs_uninstall_device _PARAMS((void));

extern int xfs_install_filesys _PARAMS((void));
extern int xfs_uninstall_filesys _PARAMS((void));

extern int xfs_install_syscalls _PARAMS((void));
extern int xfs_uninstall_syscalls _PARAMS((void));

extern int xfs_vdstat_filesys _PARAMS((void));
extern int xfs_vdstat_syscalls _PARAMS((void));
extern int xfs_vdstat_device _PARAMS((void));

extern int xfs_message_send _PARAMS((int fd,
				    struct xfs_message_header *message,
				    u_int size));

extern int xfs_message_rpc _PARAMS((int fd,
				    struct xfs_message_header *message,
				    u_int size));

extern int xfs_message_receive _PARAMS((int fd,
					struct xfs_message_header *message,
					u_int size));

extern int xfs_message_wakeup _PARAMS((int fd,
				       struct xfs_message_wakeup *message,
				       u_int size));

extern int
xfs_message_wakeup_data _PARAMS((int fd,
				 struct xfs_message_wakeup_data *message,
				 u_int size));

#endif /* _xfs_dev_h */
