/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <xfs/xfs_locl.h>
#include <xfs/xfs_message.h>
#include <xfs/xfs_fs.h>
#include <xfs/xfs_dev.h>
#include <xfs/xfs_syscalls.h>
#include <xfs/xfs_deb.h>

RCSID("$Id: xfs_wrap-bsd.c,v 1.16 1999/01/10 06:28:26 assar Exp $");

static int
xfs_uninstall(void)
{
    int err, ret = 0;

    if ((err = xfs_uninstall_filesys()) != 0)
	ret = err;
    if ((err = xfs_uninstall_device()) != 0)
	ret = err;
    if ((err = xfs_uninstall_syscalls()) != 0)
	ret = err;

    return ret;
}

static int
xfs_install(void)
{
    int err = 0;

    if ((err = xfs_install_device()) ||
	(err = xfs_install_syscalls()) ||
	(err = xfs_install_filesys()))
	xfs_uninstall();
    return err;
}

static int
xfs_stat(void)
{
    int err = 0;

    if ((err = xfs_stat_device()) != 0)
	return err;
    else if ((err = xfs_stat_syscalls()) != 0)
	return err;
    else if ((err = xfs_stat_filesys()) != 0)
	return err;
    return err;
}

extern struct cdevsw xfs_dev;

/*
 * This is to build a kld module (FreeBSD3.0)
 */

#if KLD_MODULE

/*
 *
 */

static int
xfs_load(struct module *mod, int cmd, void *arg)
{
    int ret;

    XFSDEB(XDEBLKM, ("xfs_load\n"));

    switch (cmd) {
    case MOD_LOAD :
	ret = xfs_install ();
	if (ret == 0) {
	    printf ("xfs cdev loaded at %d\n", xfs_dev.d_maj);
	}
	break;
    case MOD_UNLOAD :
	ret = xfs_uninstall ();
	break;
    default :
	ret = EINVAL;
	break;
    }
    XFSDEB(XDEBLKM, ("xfs_load = %d\n", ret));
    return ret;
}

extern struct vfsops xfs_vfsops;

extern struct sysent xfs_syscallent;

/* XXX */

#define AFS_SYSCALL 210

VFS_SET(xfs_vfsops, xfs, 0);
CDEV_MODULE(xfs_dev, NODEV, xfs_dev, xfs_load, NULL);
#ifdef SYSCALL_MODULE
static int offset = NO_SYSCALL;

SYSCALL_MODULE(xfs_syscall, &offset, &xfs_syscallent, NULL, NULL);
#endif

#else

/*
 * An ordinary lkm-module
 */

#if defined(__FreeBSD__) && __FreeBSD_version < 300000
static struct lkm_dev _module = {
    LM_DEV,
    LKM_VERSION,
    "xfs_mod",
    -1,
    LM_DT_CHAR,
    {(void *)&xfs_dev}
};
#elif defined(__FreeBSD__)
MOD_DEV(xfs,LM_DT_CHAR,-1,&xfs_dev);
#else
MOD_DEV("xfs_mod",LM_DT_CHAR,-1,&xfs_dev)
#endif

/*
 *
 */

static int
xfs_modload(struct lkm_table *lkmtp, int cmd)
{
    int error = 0;

    XFSDEB(XDEBLKM, ("xfs_modload\n"));

    error = xfs_install();
    xfs_stat();
    return error;
}


/*
 *
 */

static int
xfs_modunload(struct lkm_table * lkmtp, int cmd)
{
    int error = 0;

    XFSDEB(XDEBLKM, ("xfs_modunload\n"));

    error = xfs_uninstall();
    if (!error)
	XFSDEB(XDEBLKM, ("xfs_modunload: successful\n"));
    else
	XFSDEB(XDEBLKM, ("xfs_modunload: unsuccessful, system unstable\n"));
    return error;
}

/*
 *
 */

static int
xfs_modstat(struct lkm_table * lkmtp, int cmd)
{
    int error = 0;

    XFSDEB(XDEBLKM, ("xfs_modstat\n"));

    error = xfs_stat();
    return error;
}

int
xfs_mod(struct lkm_table * lkmtp,
	int cmd,
	int ver)
{
#ifdef MOD_DISPATCH
    MOD_DISPATCH(xfs, lkmtp, cmd, ver, xfs_modload, xfs_modunload, xfs_modstat);
#else
    DISPATCH(lkmtp, cmd, ver, xfs_modload, xfs_modunload, xfs_modstat);
#endif
}

#endif /* KLD_MODULE */
