/* kernelServer.h created by builder on Thu 26-Mar-1998 */

#ifndef RHAPSODY_KERNEL_SERVER
#define RHAPSODY_KERNEL_SERVER

/* To get types used by prototypes below (Rhapsody allow multiple includes) */
#include <sys/types.h>
#include <sys/namei.h>
#include <sys/ucred.h>
#include <sys/mount.h>

/* for vm_offset_t used in vnode_if.h */
#include <mach/machine/vm_types.h>

/* current_<foo>_EXTERNAL() used by xfs_dev.c */
#include <kernserv/prototypes.h>

/* functions not prototyped in Rhapsody (BSD 4.4lites2 Utah) sys/namei.h */
void cache_purge(struct vnode *);
int cache_lookup(struct vnode *, struct vnode **, struct componentname *);
void cache_enter(struct vnode *, struct vnode *, struct componentname *);
void cache_purgevfs(struct mount *);

/* functions not prototyped in Rhapsody (BSD 4.4lites2 Utah) sys/systm.h */
extern int selwait;             /* select timeout address */
void uprintf(const char *, ...);

#endif /* RHAPSODY_KERNEL_SERVER */
