/*
 * Copyright (c) 1995, 1996, 1997 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#define __NO_VERSION__

#include <xfs/xfs_locl.h>
#include <xfs/xfs_common.h>

RCSID("$Id: xfs_common.c,v 1.19 1999/01/10 18:28:28 map Exp $");

#ifdef DEBUG
static u_int xfs_allocs[10]={0,0,0,0,0,0,0,0,0,0};
static u_int xfs_frees[10]={0,0,0,0,0,0,0,0,0,0};
#endif

void *
xfs_alloc(u_int size, int service)
{
#ifdef DEBUG
    xfs_allocs[service]++;
#endif
    return kmalloc (size, GFP_KERNEL); /* What kind? */
}

void
xfs_tell_alloc()
{
#ifdef DEBUG
    int i;
    XFSDEB(XDEBMEM, ("xfs_alloc: xfs_allocs - xfs_frees ="));
    for (i = 0; i < 8; i++)
	printk(" %d", xfs_allocs[i] - xfs_frees[i]);
    XFSDEB(XDEBMEM, ("\n"));
#endif
}

void
xfs_free(void *ptr, int service)
{
#ifdef DEBUG
    xfs_frees[service]++;
#endif
    kfree (ptr);
}

#ifndef LINUX2_1
int
init_private_file(struct file *filp, struct inode *inode, int mode)
{
    memset(filp, 0, sizeof(struct file));
    filp->f_mode = mode;
    filp->f_count = 1;
    filp->f_op = inode->i_op->default_file_ops;
    if (filp->f_op->open)
	return filp->f_op->open(inode, filp);
    else
	return 0;
}
#endif

#ifdef LINUX2_1
void
print_aliases(struct inode *inode)
{
    struct list_head *alias;
    struct dentry *dentry;
    int bailout = 100;

    alias = inode->i_dentry.next;
    while (alias != &inode->i_dentry) {
	if (--bailout < 0) {
	    XFSDEB(XDEBVFOPS, (" ..."));
	    break;
	}
	dentry = list_entry(alias, struct dentry, d_alias);
	if (dentry)
	    XFSDEB(XDEBVFOPS,(" %*s(%p)",
			      dentry->d_name.len,
			      dentry->d_name.name,
			      dentry));
	alias = alias->next;
    }
    XFSDEB(XDEBVFOPS,("\n"));
}

void
print_childs(struct dentry *dentry)
{
    struct list_head *subdirs;

    subdirs = dentry->d_subdirs.next;

    while (subdirs != &dentry->d_subdirs) {
	struct list_head *tmp = subdirs;
	struct dentry *child = list_entry(tmp, struct dentry, d_child);

	XFSDEB(XDEBVFOPS,(" %*s(%p)",
			  child->d_name.len,
			  child->d_name.name,
			  child));
	
	subdirs = tmp->next;
    }

    XFSDEB(XDEBVFOPS,("\n"));
}
#endif
