dnl $Id: krb-find-db.m4,v 1.1 1998/06/04 05:19:57 joda Exp $
dnl
dnl find a suitable database library
dnl
dnl AC_FIND_DB(libraries)
AC_DEFUN(KRB_FIND_DB, [

lib_dbm=no
lib_db=no

for i in $1; do

	if test "$i"; then
		m="lib$i"
		l="-l$i"
	else
		m="libc"
		l=""
	fi	

	AC_MSG_CHECKING(for dbm_open in $m)
	AC_CACHE_VAL(ac_cv_krb_dbm_open_$m, [

	save_LIBS="$LIBS"
	LIBS="$l $LIBS"
	AC_TRY_RUN([
#include <unistd.h>
#include <fcntl.h>
#include <ndbm.h>
int main()
{
  DBM *d;

  d = dbm_open("conftest", O_RDWR | O_CREAT, 0666);
  if(d == NULL)
    return 1;
  dbm_close(d);
  return 0;
}], [
	if test -f conftest.db; then
		ac_res=db
	else
		ac_res=dbm
	fi], ac_res=no, ac_res=no)

	LIBS="$save_LIBS"

	eval ac_cv_krb_dbm_open_$m=$ac_res])
	eval ac_res=\$ac_cv_krb_dbm_open_$m
	AC_MSG_RESULT($ac_res)

	if test "$lib_dbm" = no -a $ac_res = dbm; then
		lib_dbm="$l"
	elif test "$lib_db" = no -a $ac_res = db; then
		lib_db="$l"
		break
	fi
done

AC_MSG_CHECKING(for NDBM library)
if test "$lib_db" != no; then
	LIB_DBM="$lib_db"
	AC_DEFINE(NDBM)dnl
	AC_DEFINE(HAVE_NEW_DB)
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
elif test "$lib_dbm" != no; then
	LIB_DBM="$lib_dbm"
	AC_DEFINE(NDBM)dnl
	if test "$LIB_DBM"; then
		ac_res="yes, $LIB_DBM"
	else
		ac_res=yes
	fi
else
	LIB_DBM=""
	ac_res=no
fi
AC_SUBST(LIB_DBM)
AC_MSG_RESULT($ac_res)

])
