.TH encrypt 1 "March 1995"  "7.1" "TIS/MOSS"
.SH NAME
encrypt \- encrypt a file using MOSS encryption
.SH SYNOPSIS
.B
encrypt
alias 
.I alias 
[alias
.I alias ...
]
[data-in 
.I filename
] [data-out 
.I filename
] [header-out 
.I filename
]
.SH DESCRIPTION
Encrypt the file named by 
.B
data-in,
or standard input if
.B
data-in
is not supplied, for all of the named aliases and write the encrypted text to 
the file named by 
.B
data-out,
or standard output if
.B 
data-out
is not supplied,
and write the MOSS headers to the file named by
.B
header-out,
or standard error if
.B
header-out 
is not supplied.
.PP
When aliases identify more than one user record, the file will be encrypted
for all users with that alias.  When encrypting for multiple users, it is
faster to encrypt for them if one alias covers multiple users as opposed to 
having a unique alias for each user.  
.PP
If you do not include an alias for one of your user records, you will not be
.B
able to decrypt the message yourself.  One way to prevent this from happening 
is to set the tailorable
.B metoo
tag/value pair to 
.B yes 
(default) and ensure that the alias associated with the 
.B encrypt-alias
tailorable tag/value pair (
.B me
by default) is used on at least one of your user records.
.PP
You must be logged into TIS/MOSS under the user identified by the alias 
associated with the tailorable 
.B sig-alias
tag/value pair or be prepared to provide that user's password
in order for the pseudorandom number generator to be initialized.
.PP
.SH FILES
$HOME/.mossrc, 
$HOME/.mossdb
.SH SEE ALSO
decrypt(1), mossdb(5), mosslogin(1), mossrc(5), moss(1)
.SH BUGS

