/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "util.h"

disp_bbuf(bbuf, out)
struct bbuf *bbuf;
char ***out;
{
    if (out == (char ***)0)
	return(NOTOK);

    if (bbuf == NULLBB) {
	*out = add2av(*out, add2cp(NULLCP, "NULL"));
	return(OK);
    }

    if (!bbuf->length) {
        *out = add2av(*out, add2cp(NULLCP, "EMPTY"));
        return(OK);
    }

    if ((bbuf -> length && bbuf -> data == NULLUCP)
	|| (bbuf -> length == 0 && bbuf -> data != NULLUCP))
	return(NOTOK);

    *out = add2av(*out, addhex2cp(NULLCP, bbuf->data, bbuf->length));

    return(OK);
}


