/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

static _parse_rdns(), _parse_avas(), _unesc_delim();

struct bbuf *str2dn(str)
char *str;
{
    char *tmp;
    struct bbuf *rdns= NULLBB, *ret= NULLBB;

    if (str == NULLCP)
	goto cleanup;

    if (_parse_rdns(tmp=add2cp(NULLCP, str), &rdns) != OK) 
        goto cleanup;

    if (rdns_dname(ret=alloc_bbuf(), &rdns, WRITE) != OK) 
        goto cleanup;

 cleanup:

    FREE(tmp);
    return(ret);
}


static _parse_rdns(str, rdns)
char *str;
struct bbuf **rdns;
{
    struct bbuf *avas= NULLBB, *tmp= NULLBB,
		*bbptr= NULLBB;
    char 	*ptr1, *ptr2, *tcp= NULLCP;
    int         lenstr = strlen(str);
    int 	ret= NOTOK;

    FREE_BBUFS(*rdns);

    if (str == NULLCP)
	goto cleanup;

    for (ptr1 = str; ptr1 < str+lenstr-1; ptr1 = ptr2) {

	/* Skip DN_DELIM */

	ptr1++;

	/* Find the end of this RDN */

	/* Find the AVA delimiter */

	if ((ptr2 = INDEX(ptr1, AVA_DELIM)) == NULLCP)
	    goto cleanup;
       
	/* Now search until we find an unescaped DN_DELIM */

	for (tcp = ptr2; *tcp != NULLC; tcp++)
	    if (*tcp == DN_DELIM)
		if (*(tcp+1) == DN_DELIM)
		    tcp++;
		else
		    break;
	ptr2 = tcp;

	/* Terminate this RDN */
	
	if (ptr2 != NULLCP)
	    *ptr2 = NULLC;

	/* Make a copy */

	tcp = add2cp(NULLCP, ptr1);

	/* Remove DN_DELIM  escapes */

	(void) _unesc_delim(&tcp, DN_DELIM);

	/*parse AVAs */

	tmp = alloc_bbuf();
	if (_parse_avas(tcp, &avas) != OK || avas_rdn(tmp, &avas, WRITE) != OK)
	    goto cleanup;

	if (*rdns == NULLBB) 
	    *rdns = bbptr = tmp;
	else {
	    bbptr->next = tmp;
	    tmp->prev = bbptr;
	    bbptr = tmp;
	}

	FREE(tcp);
    }

    ret = OK;

 cleanup:

    FREE(tcp);
    if (ret != OK) 
	FREE_BBUFS(*rdns);
    return(ret);
}


static _parse_avas(str, avas)
char *str;
struct bbuf **avas;
{
    struct bbuf *ava= NULLBB, *bbptr= NULLBB, *bb= NULLBB, *tmp= NULLBB;
    OID oid= NULLOID;
    char *attrib, *value, *end;
    char *tcp = NULLCP;
    char *csptr= NULLCP;
    char *oidstr;
    int legal, i, ret = NOTOK;
    int lenstr = strlen(str);
    unsigned short attribute;

    FREE_BBUFS(*avas);

    if (str == NULLCP)
	goto cleanup;
 
    /* Parse attributes and values and check for character set designators */

    for (attrib = str; attrib < str+lenstr; attrib = end+1) {

	/* Find AVA delimeter */

	if ((tcp = INDEX(attrib, AVA_DELIM)) ==  NULLCP)
	    goto cleanup;
	*tcp = NULLC;
	value = tcp + 1;
	
	/* Check for character set designator */

	if ((csptr=INDEX(attrib, DN_DELIM)) != NULLCP) {
	    *csptr = NULLC;
	    csptr++;
	}
	
	/* Find non-escaped RDN_DELIM or NULLC to terminate this AVA */

	for (end = value; *end != NULLC; end++) 
	    if (*end == RDN_DELIM)
		if (*(end+1) == RDN_DELIM)
		    end++;
		else
		    break;
	*end = NULLC;

	/* Look up attribute */
	
	if (!(attribute = strilookup(label_attribute, attrib)) && 
	    !(oid=str2oid(attrib))) 
	    goto cleanup;

	oidstr = (attribute) ? vallookup(oidstr_attribute, attribute)
	    : add2cp(NULLCP, attrib);

	if ((oid = str2oid(oidstr)) == NULLOID) 
	    goto cleanup;
 
	/* make a copy of the value and remove RDN_DELIM escapes */
	tcp = add2cp(NULLCP, value);
	(void) _unesc_delim(&tcp, RDN_DELIM);

        /* Encode value based on oid type */
        switch (strilookup(oidstr_syntax, oidstr)) {
	case CaseExactString:
	case PrintableString:
	case CaseIgnoreString:
	case CaseIgnoreList:
	case NumericString:
	case PhoneNumber:
	    /* Check for character set here */
            switch (strilookup(label_charset, csptr)) {
	    case DEFN_T61S:
	        if (encode_t61s(tcp, &bb) != OK)
		    goto cleanup;
		break;
	    default:
        	/* For now, we assume our two options are printable string or
		 * T61.  If the string contains a character which is not
		 * legal for DEFN_PRTS, we encode T61.
		 */
        	for (i=0,legal=1; legal && i<strlen(tcp); i++)
        	    legal = (INDEX(prts_chars,tcp[i]) != NULLCP);
        	if (!legal) {
        	    if (encode_t61s(tcp, &bb) != OK) 
                	goto cleanup;
        	}
        	else {
        	    if (encode_prts(tcp, &bb) != OK) 
                	goto cleanup;
        	}
	    }
	    break;

	case Boolean:
	case Integer:
	    if (encode_int(atoi(tcp), &bb) != OK)
		goto cleanup;
	    break;

	case UTCTime:
	    if (encode_utct(atol(tcp), &bb) != OK)
		goto cleanup;
	    break;

	case OctetString:
	    if (tcp != NULLCP && *tcp != NULLC) {
	        tmp = alloc_bbuf();
	        tmp->length = strlen(tcp);
	        tmp->data = alloc_uchar(tmp->length);
	        BCOPY((unsigned char *)tcp, tmp->data, tmp->length);
	    }
	    if (encode_octs(tmp, &bb) != OK)
		goto cleanup;
	    break;

	default:
	    if ((bb = hex2bin(tcp)) == NULLBB)
		goto cleanup;
        }
	
	FREE(tcp);

	if (encode_ava(oid, bb, &ava) != OK)
	    goto cleanup;

	if (*avas == NULLBB) 
	    *avas = bbptr = ava;
	else {
	    bbptr->next = ava;
	    ava->prev = bbptr;
	    bbptr = ava;
	}
	ava = NULLBB;
    }

    ret = OK;

 cleanup:

    FREE_BBUF(bb);
    FREE_BBUF(tmp);
    FREE(tcp);
    if (ret != OK) 
	FREE_BBUFS(*avas);

    return(ret);
}

static _unesc_delim(str, delim)
char **str;
char delim;
{
    char *oldstr = *str;
    char *newstr;
    int oldstrlen = strlen (oldstr);
    int delimcount = 0;
    int i, j;

    for (i = 0; i < oldstrlen; i++)
	if (oldstr[i] == delim && oldstr[i+1] == delim) {
	    delimcount++;
	    i++;
	}

    if (delimcount) {
	newstr = alloc_char(oldstrlen + 1 - delimcount);
	for (i = 0, j = 0; i < oldstrlen; i++)  {
	    newstr[j++] = oldstr[i];
	    if (oldstr[i] == delim && oldstr[i+1] == delim)
		i++;
	}
	FREE(*str);
	*str = newstr;
    }
    
    return OK;
}
