/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * encode_mic.c
 *---------------------------------------------------------------------------
 * ASN.1 encode MIC AlgorithmIdentifier and MIC as following SEQUENCE
 * per PKCS #1:
 *
 *     SEQUENCE {
 *         digestAlgorithm AlgorithmIdentifier,
 *         digest OCTET STRING
 *     }
 * 
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "asn1.h"
#include "bbuf.h"
#include "util.h"


int encode_mic(dmic, aid, emic)
struct bbuf *dmic;
struct algid *aid;
struct bbuf **emic;
{
    int r;
    struct bbuf *bb = NULLBB;
    struct bbuf *bb2 = NULLBB;
    struct bbuf *bb3 = NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (dmic == NULLBB || aid == NULL_ALGID || emic == (struct bbuf **)0) 
        return(NOTOK);

    FREE_BBUF(*emic);

    /* ASN.1 ENCODE THE ALGID */
    if ((r = encode_algid(aid, &bb2)) != OK)
	goto cleanup;

    /* ASN.1 ENCODE THE MIC AS AN OCTET STRING & APPEND */
    if ((r = encode_octs(dmic, &bb)) != OK)
        goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ASN.1 ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ASN.1 ENCODE SEQUENCE TAG & PREPEND */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
	goto cleanup;
    *emic = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

cleanup:

    if (r != OK)
	FREE_BBUF(*emic);

    FREE_BBUF(bb2);

    return(r);
}


