/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "allocate.h"
#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "util.h"
#include "bbuf.h"

/*****************************************************************************
 * decode_key()
 *---------------------------------------------------------------------------
 * ASN.1 decode key structure by calling decode_key_data()
 *****************************************************************************/

int decode_key(ekey,dkey)
struct bbuf *ekey;
struct key **dkey;
{
    struct bbuf *ptr, *bbufs= NULLBB;
    int dummy, ret= NOTOK;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (ekey == NULLBB || dkey == (struct key **)0)
	return(NOTOK);

    FREE_KEY(*dkey);

    /* ALLOCATE KEY STRUCTURE */
    if (alloc_key(dkey) != OK)
	goto cleanup;

    if (ekey->length) {
        /* Check for valid tag */
        if ((ekey->data[0] & TAG_MASK) != CONS_SEQ
            || asn_parse(ekey, &bbufs) != OK)
            goto cleanup;

        /* DECODE CRLTOBESIGNED */
        if ((ptr = bbufs) == NULLBB) {
            ret = OK;
            goto cleanup;
        }
        if (ptr->length && decode_algid(ptr, &((*dkey)->algid), &dummy) != OK)
            goto cleanup;

        /* DECODE KEY DATA AS BIT STRING */
        if ((ptr = ptr->next) == NULLBB) {
            ret = OK;
            goto cleanup;
        }
        if (ptr->length && decode_bits(ptr, &((*dkey)->data), &dummy) != OK)
	    goto cleanup;
    }

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK)
	FREE_KEY(*dkey);

    return(ret);
}
