/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 *  enciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./global.h"
#include "./des.h"

/****************************************************************************/

static int encipher_descbc();

int encipher_des(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;

    /* double-check parameters */

    if (in == NULLBB || out == (struct bbuf **)0) 
	return(NOTOK);

    /* encrypt with specified mode of operation */

    switch(curalg) {
    case DES_CBC:
	if ((r = encipher_descbc(in, out)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    return(r);
}

/****************************************************************************/

static int encipher_descbc(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int i;			        /* block index */
    int j, k;			        /* byte indices */
    struct bbuf *key = NULLBB;		/* Key */
    struct bbuf *iv = NULLBB;		/* IV */
    int padlen;			        /* length of padding */
    int inlen;			        /* input buffer length */
    unsigned char *indata, *outdata;    /* input and output buffer pointers */
    unsigned char lastblock[8];         /* last block w/ input & padding */
    DES_CBC_CTX context;

    /* set lengths */

    inlen = in->length;
    indata = in->data;
    padlen = 8 - (inlen % 8);

    /* allocate encrypted output buffer */

    *out = alloc_bbuf();
    (*out)->length = inlen + padlen;
    (*out) -> data = alloc_uchar((*out) -> length);
    outdata = (*out)->data;

    /* decode des key & iv */

    if (decode_deskeydata(curdata, &key) != OK)
        return(NOTOK);
    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);

    /* set up key schedule */

    DES_CBCInit(&context, key->data, iv->data, 1 /* encrypt */);
    FREE_BBUF(key);
    FREE_BBUF(iv);

    /* encrypt all but final, padded block */

    for (i = 0; i < inlen - 7; i += 8) 
	DES_CBCUpdate(&context, outdata+i, indata+i, 8);

    /* pad final block with pad length and encrypt */

    for (j=i, k=0; j<inlen; j++, k++) 
	lastblock[k] = indata[j];
    for (; j<inlen+padlen; j++, k++) 
	lastblock[k] = (unsigned char)padlen;
    DES_CBCUpdate(&context, outdata+i, lastblock, 8);

    return(OK);

}

