/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * encode_algid.c
 *---------------------------------------------------------------------------
 * ASN.1 encode algid structure as following AlgorithmIdentifier SEQUENCE:
 *
 * AlgorithmIdentifier ::= SEQUENCE {
 *         algorithm              OBJECT IDENTIFIER,
 *         parameters             ANY DEFINED BY algorithm OPTIONAL
 * }
 *
 * If algid.parms is NULLBB, then the parameters are encoded as NULL,
 * otherwise algid.parms is assumed to point to a bbuf containing
 * the parameters, ASN.1 encoded per the algorithm-specific syntax.
 *
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "oid.h"
#include "util.h"


int encode_algid(daid, eaid)
struct algid *daid;
struct bbuf **eaid;
{
    int r;
    struct algent *ae;
    struct bbuf *bb = NULLBB;
    struct bbuf *bb2 = NULLBB;
    struct bbuf *bb3 = NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (eaid == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*eaid);

    /* ENCODE MISSING ALGID AS A NULL */
    if (daid == NULL_ALGID) {
	if ((r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, eaid)) != OK)
	    return(r);
	return(OK);
    }

    /* GET ALGORITHM TABLE ENTRY */
    if ((ae = getalgcode(algorithms, daid->alg, ANY)) == NULL_ALGENT) 
        return(NOTOK);

    /* ENCODE THE ALGID ALG AS AN OBJECT IDENTIFIER */
    if (ae->oidstr == NULLCP) {
	r = NOTOK;
	goto cleanup;
    } else {
        if ((r = encode_oid(str2oid(ae->oidstr), &bb2)) != OK)
	    goto cleanup;
    }

    /* ENCODE PARAMETERS & APPEND */
    if (daid->parms == NULLBB) {
        /* ENCODE NO PARAMETERS AS A NULL */
	if ((r = encode_null(CLASS_UNIV|FORM_PRIM|PRIM_NULL, &bb)) != OK)
	    goto cleanup;
    } else {
        /* OTHERWISE, COPY THE (ALREADY ENCODED) PARAMETERS */
        if ((bb = dup_bbuf(daid->parms)) == NULLBB) {
            r = NOTOK;
            goto cleanup;
        }
    }
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND ASN.1 ENCODED LENGTH */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
	goto cleanup;
    *eaid = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

cleanup:

    FREE_BBUF(bb2);

    return(r);
}


