/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/* This package contains routines for managing the rcl.

		int _rclinit(rcl);
		/* This routine must be called prior to any list
		   manipulation

		int _rclend(rcl);
		/* This routine must be called to remove internal
		   information

		int _rclappend(rcl, entry);
		/* append a record after "current" 

		int _rclinsert(rcl, entry);
		/* insert a record prior to "current" 

		int _rclupdate(rcl, entry);
		/* update the current record in the list 

		int _rcldelete(rcl);
		/* delete the current record in the list 

		struct rcl_entry *_rclfirst(rcl);
		/* return the first record in the list 

		struct rcl_entry *_rclnext(rcl);
		/* return the next record in the list 

		struct rcl_entry *_rcllast(rcl);
		/* return the  last record in the list 

		struct rcl_entry *_rclcurrent(rcl);
		/* return the current record in the list 


   List initialization does not erase lists contents, but is required
   for future access via these routines. A dummy head node is created,
   which maintains an internal "current" pointer. Each call to first,
   next, or last, will affect the value of "current". If this package is
   used for a template, be advised that the minimum record size
   excluding next pointer is sizeof(char *)

   This package function as follows:

	1. List initialization creates a dummy head node which is
	transparent to the application, and intended for the EXCLUSIVE
	use of the package internals.

	2. The package keeps a "hot" pointer for the list (stored in the
	dummy node). The hot pointer represents the current entry in the
	list. This pointer is updated by the package interface routines.

	3. A call to _rclend() removes the dummy node. This implies that
	multiple calls to this routine are to be avoided unless there is
	an intermediate call to _rclinit().  */


#include "config.h"
#include "general.h"

#include "crl.h"
#include "util.h"

static int _setdummy(rcl, entry)
struct rcl_entry *rcl, *entry;
{
    /* we know we are called correctly so no error checking */

    BCOPY(&entry, rcl, sizeof(char *));
    return;
}


static struct rcl_entry *_previous(rcl)
struct rcl_entry *rcl;
{
    struct rcl_entry *r;

    /* we know we are called correctly so no error checking */

    BCOPY(rcl, &r, sizeof(char *));
    return (r);
}


struct rcl_entry *_rclcurrent(rcl)
struct rcl_entry *rcl;
{
    if (rcl == NULL_RCL_ENTRY) 
	return (rcl);

    return(_previous(rcl)->next);
}


int _rclinit(rcl)
struct rcl_entry **rcl;
{
    struct rcl_entry *r = alloc_rcl_entry();
  
    if (rcl == (struct rcl_entry **)0) 
	return (NOTOK);

    if (r == NULL_RCL_ENTRY) 
	return (NOTOK);

    r->next = *rcl;
    if (*rcl != NULL_RCL_ENTRY)
	(*rcl)->prev = r;
    *rcl = r;
    _setdummy(*rcl, *rcl);

    return(OK);
}


int _rclend(rcl)
struct rcl_entry **rcl;
{
    struct rcl_entry *r;
  
    if (rcl == (struct rcl_entry **)0) 
	return(NOTOK);

    if (*rcl == NULL_RCL_ENTRY) 
	return (NOTOK);

    r = *rcl;
    *rcl = (*rcl)->next;
    if (*rcl != NULL_RCL_ENTRY)
	(*rcl)->prev = NULL_RCL_ENTRY;
    (void) free((char *)r);

    return(OK);
}


/* put entry after the current pointer */
int _rclappend(rcl, entry)
struct rcl_entry *rcl, *entry;
{
    /* XXX do not use arguments until you have checked them */
    struct rcl_entry *new = alloc_rcl_entry(), *r = _rclcurrent(rcl);
    int ret = OK;

    if (rcl == NULL_RCL_ENTRY) 
	return(NOTOK);
  
    if (new == NULL_RCL_ENTRY) 
	return(NOTOK);
  
    if (entry == NULL_RCL_ENTRY) 
	return(NOTOK);

    /* Don't bomb because user tries to append to NULL */
    if (r == NULL_RCL_ENTRY)
	r = _previous(rcl);

    BCOPY(entry, new, sizeof(struct rcl_entry));
    new->next = r->next;
    if (new->next != NULL_RCL_ENTRY)
	new->next->prev = new;
    new->prev = r;
    r->next = new;
    _setdummy(rcl, r);

    return(ret);
}


/* put entry prior to the current pointer */
int _rclinsert(rcl, entry)
struct rcl_entry *rcl, *entry;
{
    /* XXX do not use arguments until you have checked them */
    struct rcl_entry *new= alloc_rcl_entry(), *r= _previous(rcl);
  
    if (rcl == NULL_RCL_ENTRY) 
	return(NOTOK);

    if (new == NULL_RCL_ENTRY) 
	return(NOTOK);

    if (entry == NULL_RCL_ENTRY) 
	return(NOTOK);

    BCOPY(entry, new, sizeof(struct rcl_entry));
    new->next = r->next;
    new->prev = r;
    if (new->next != NULL_RCL_ENTRY)
	new->next->prev = new;
    r->next = new;
    _setdummy(rcl, r);

    return(OK);
}


int _rclupdate(rcl, entry)
struct rcl_entry *rcl, *entry;
{
    /* XXX do not use arguments until you have checked them */
    struct rcl_entry *r= _rclcurrent(rcl), *tnext, *tprev;
  
    if (rcl == NULL_RCL_ENTRY) 
	return(NOTOK);

    if (entry == NULL_RCL_ENTRY) 
	return(NOTOK);

    if (r == NULL_RCL_ENTRY) 
	return(NOTOK);

    tnext = r->next;
    tprev = r->prev;
    BCOPY(entry, r, sizeof(struct rcl_entry));
    r->prev = tprev;
    r->next = tnext;

    return(OK);
}


int _rcldelete(rcl)
struct rcl_entry *rcl;
{
    /* XXX do not use arguments until you have checked them */
    struct rcl_entry *r= _rclcurrent(rcl), *prev= _previous(rcl);
  
    if (rcl == NULL_RCL_ENTRY) 
  	return(NOTOK);

    if (r == NULL_RCL_ENTRY) 
	return(NOTOK);

    prev->next = r->next;
    if (r->next != NULL_RCL_ENTRY)
	r->next->prev = prev;
    (void)free_rcl(r);

    return(OK);
}


struct rcl_entry *_rclfirst(rcl)
struct rcl_entry *rcl;
{
    struct rcl_entry *ret= NULL_RCL_ENTRY;

    if (rcl == NULL_RCL_ENTRY) 
	return(ret);
    else {
	_setdummy(rcl, rcl);
	return(_rclcurrent(rcl));
    }
}


struct rcl_entry *_rclnext(rcl)
struct rcl_entry *rcl;
{
    /* XXX do not use arguments until you have checked them */
    struct rcl_entry *r= _rclcurrent(rcl);
  
    if (rcl == NULL_RCL_ENTRY) 
	return(NULL_RCL_ENTRY);

    if (r == NULL_RCL_ENTRY) 
	return(NULL_RCL_ENTRY);

    _setdummy(rcl, r);
    return(r->next);
}


struct rcl_entry *_rcllast(rcl)
struct rcl_entry *rcl;
{
    struct rcl_entry *r= rcl, *back= r;
  
    if (rcl == NULL_RCL_ENTRY) 
	return(NULL_RCL_ENTRY);

    while (r->next != NULL_RCL_ENTRY) {
	if (back != r) back = back->next;
	r= r->next;
    }
    _setdummy(rcl, back);
    return(r);
}


