/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "algid.h"
#include "allocate.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

alloc_crl(crl)
struct crl **crl;
{
    if (crl == (struct crl **)0) 
	return(NOTOK);

    allocate(crl, struct crl, sizeof(struct crl));

    (*crl) -> tobesigned = NULL_CRLTOBESIGNED;
    (*crl) -> sig_alg = NULL_ALGID;
    (*crl) -> sig = NULLBB;
    (*crl)->status = BUNKNOWN;

    return(OK);
}

struct rcl_entry *alloc_rcl_entry()
{
    struct rcl_entry *p;

    allocate(&p, struct rcl_entry, sizeof(struct rcl_entry));

    p -> serial = NULLBB;
    p -> date = 0L;
    p -> prev = p ->next = NULL_RCL_ENTRY;

    return(p);
}

struct crltobesigned *alloc_crltobesigned()
{
    struct crltobesigned *p;

    allocate(&p, struct crltobesigned, sizeof(struct crltobesigned));

    p -> sig_alg = NULL_ALGID;
    p -> issuer = NULLBB;
    p -> rcl = NULL_RCL_ENTRY;
    p -> lastupdate = p -> nextupdate = 0L;

    return(p);
}
