/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "oid.h"
#include "util.h"

encode_oid(doid, eoid)
OID doid;
struct bbuf **eoid;
{
    struct bbuf *bb;
    struct bbuf *lenbb = NULLBB;
    int r;
	
    if (doid == NULLOID || eoid == (struct bbuf **)0) 
	return(NOTOK);

    if (*eoid != (struct bbuf *)0) {
	(void) free_bbuf(*eoid);
	*eoid = (struct bbuf *)0;
    }

    if ((bb = oid2prim(doid)) == (struct bbuf *)0) 
	return(NOTOK);

    if ((r = encode_len(bb->length, &lenbb)) != OK) {
	(void) free_bbuf(bb);
	return(r);
    }

    *eoid = alloc_bbuf();
    (*eoid)->data = alloc_uchar(1+lenbb->length+bb->length);
    (*eoid)->length = 1 + lenbb->length + bb->length;

    (*eoid)->data[0] = (CLASS_UNIV | FORM_PRIM | PRIM_OID);
    BCOPY(lenbb->data, &((*eoid)->data[1]), lenbb->length);
    BCOPY(bb->data, &(*eoid)->data[1+lenbb->length], bb->length);

    (void) free_bbuf(bb);
    (void) free_bbuf(lenbb);

    return(OK);
}
