/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

int encode_null(tag, enull)
unsigned char tag;
struct bbuf **enull;
{   struct bbuf *bb= NULLBB, *tmp= NULLBB;
    int ret= NOTOK;

    if (enull == (struct bbuf **)0) 
	goto cleanup;

    FREE_BBUF(*enull);

    if (encode_tag(tag, enull) != OK) 
	goto cleanup;

    if (encode_len(0, &bb) != OK) 
	goto cleanup;

    tmp = *enull;
    *enull = bbufcat(*enull, bb);

    ret = OK;

  cleanup:
    FREE_BBUF(bb);
    FREE_BBUF(tmp);
    if (ret != OK)
	FREE_BBUF(*enull);

    return(ret);
}
