/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_len(edata, elen, dlen, rlength)
unsigned char *edata;
int elen;
int *dlen;
int *rlength;
{
    int i, len, xlen;
	
    if (edata == (unsigned char *)0 || dlen == (int *)0 || rlength == (int *)0)
	return(NOTOK);

    if (elen < 1) 
	return(ASN1_ERR04);

    len = edata[0];

    if (len == LEN_XTND) 
	return(ASN1_ERR05);

    xlen = 0;
    if (len & LEN_XTND) {
	xlen = len & LEN_MASK;
	if (xlen > elen - 1) 
	    return(ASN1_ERR06);
	for (len=edata[1], i=1; i<xlen; i++)
	    len = (len * 0x100) + edata[i+1];
    }

    if (len > elen - 1 - xlen) 
	return(ASN1_ERR07);

    *dlen = len;
    *rlength = 1 + xlen;

    return(OK);
}
