#!/bin/sh

status=1
tmpfile="/tmp/enctext.$$"

trap '/bin/rm -f $tmpfile; exit $status' 0 1 2 3 9 15

umask 177

if [ $# -lt 3 ]; then 
   echo "$0 takes a text file as input and produces an encrypted MOSS " 1>&2
   echo "object in a file as output." 1>&2
   echo " " 1>&2
   echo "Usage: $0 <text file> <encrypted object file> alias <alias> [...]" 1>&2
   echo " " 1>&2
   exit
fi

if [ ! -r "$1" ]; then 
   echo "$0: Unable to read input file $1." 1>&2
   exit
fi
   
echo "Content-Type: text/plain; charset="us-ascii""  > $tmpfile
echo '' >> $tmpfile
cat $1 >> $tmpfile

encobj.sh $tmpfile $2 $*
status=$?

if [ $status -ne 0 ]; then
   echo "$0: encobj.sh returned a non-zero status ($status)." 1>&2
elif [ ! -s $2 ]; then
   echo "$0: encobj.sh did not produce an encrypted message." 1>&2
   status=1
fi

exit
