/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef _CRYPTO_
#define _CRYPTO_

/* Crypto (DEK, IK and SIG) Algorithms */

#define CRYPTO_MASK	0x0F00

#define DES		0x0100
#define RSA		0x0200
#define RSAENC		0x0300

/* Crypto Modes (or Sub-Algorithms) */

#define MODE_MASK	       0x00F0

#define DES_ECB		(DES | 0x0010)	 /* electronic codebook */
#define DES_EDE		(DES | 0x0020)	 /* multiple encryption */
#define DES_CBC		(DES | 0x0030)	 /* cipher block chaining */

#define PUB		0x0010
#define PUB3		0x0020
#define PUBF4		0x0030
#define PRIV		0x0040

#define RSA_PUB		(RSA | PUB)	 /* public key, arbitrary e */
#define RSA_PUB3	(RSA | PUB3)	 /* public key, e = 3 */
#define RSA_PUBF4	(RSA | PUBF4)	 /* public key, e = F4 */
#define RSA_PRIV	(RSA | PRIV)	 /* private key */

#define RSAENC_PUB	(RSAENC | PUB)	 /* public key, arbitrary e */
#define RSAENC_PUB3	(RSAENC | PUB3)	 /* public key, e = 3 */
#define RSAENC_PUBF4	(RSAENC | PUBF4) /* public key, e = F4 */
#define RSAENC_PRIV	(RSAENC | PRIV)	 /* private key */

/* Hash (MIC and CIC) Algorithms */

#define HASH_MASK	0x000F

#define	MD2		0x0001
#define	MD5		0x0002

/* ASN.1 OBJECT IDENTIFIERS for crypto algorithms */

#define RSAENCALG	"1.2.840.113549.1.1.1"	/* RSADSI PKCS #1 */
#define RSAALG		"2.5.8.1.1"		/* CCITT X.509 */
#define DESCBCALG	"1.3.14.3.2.7"		/* NIST OIW SECSIG */
#define MD2ALG		"1.2.840.113549.2.2"	/* RFC 1319 */
#define MD2RSAALG	"1.2.840.113549.1.1.2"	/* RSADSI PKCS #1 */
#define MD5ALG		"1.2.840.113549.2.5" 	/* RFC 1321 */
#define MD5RSAALG	"1.2.840.113549.1.1.4"	/* RSADSI PKCS #1 */

/* Types of crypto algorithms */

#define ANY		0x0000		/* ANY type */
#define CIC		0x0001		/* certificate/CRL integrity checksum */
#define MIC		0x0002		/* message integrity checksum */
#define DEK		0x0004		/* data encryption */
#define IK		0x0008		/* (interchange) key encryption */
#define SIG		0x0010		/* signature */
#define PE		0x0020		/* private key encryption */
#define HASH		0x0040		/* hash */

/* Crypto algorithm table entry */
struct algent {
	int code;			/* internal id integer code */
	char *str;			/* internal id string */
	char *hdrstr;			/* MOSS header id string */
	char *oidstr;			/* object identifier string */
	int type;			/* integer type */
	int minlen;			/* min key length */
	int maxlen;			/* max key length */
};

#define NULL_ALGENT	(struct algent *)0

#define FREE_ALGENT(x)     	if ((x) != NULL_ALGENT) { \
				    (void) freealgent(x); \
				    (x) = NULL_ALGENT; \
				} \
				else


/* Crypto algorithm Table */

#ifndef DEFINE_DATA
extern struct algent algorithms[];
#else /* DEFINE_DATA */
struct algent algorithms[] = {

	/* MIC, CIC and HASH algorithms */
	{ MD2, "MD2", "RSA-MD2", MD2ALG, MIC|CIC|HASH, 0, 0 },
	{ MD5, "MD5", "RSA-MD5", MD5ALG, MIC|CIC|HASH, 0, 0 },

	/* DEK algorithms */
	{ DES_CBC, "DES_CBC", "DES-CBC", DESCBCALG, DEK|PE, 8, 8 },

	/* IK & SIG algorithms */
	{ RSA, "RSA", "RSA", RSAALG, IK|SIG, 256, 1024 },
	{ RSA_PUB, "RSA_PUB", "RSA", RSAALG, IK|SIG, 256, 1024 },
	{ RSA_PUB3, "RSA_PUB3", "RSA", RSAALG, IK|SIG, 256, 1024 },
	{ RSA_PUBF4, "RSA_PUBF4", "RSA", RSAALG, IK|SIG, 256, 1024 },
	{ RSA_PRIV, "RSA_PRIV", "RSA", RSAALG, IK|SIG, 256, 1024 },
	{ RSAENC, "RSAENC", "RSA", RSAENCALG, IK|SIG, 256, 1024 },
	{ RSAENC_PUB, "RSAENC_PUB", "RSA", RSAENCALG, IK|SIG, 256, 1024 },
	{ RSAENC_PUB3, "RSAENC_PUB3", "RSA", RSAENCALG, IK|SIG, 256, 1024 },
	{ RSAENC_PUBF4, "RSAENC_PUBF4", "RSA", RSAENCALG, IK|SIG, 256, 1024 },
	{ RSAENC_PRIV, "RSAENC_PRIV", "RSA", RSAENCALG, IK|SIG, 256, 1024 },

	/* MIC/CIC and SIG algorithms */
	{ MD2|RSA, "MD2_RSA", NULLCP, MD2RSAALG, SIG, 256, 1024 },
	{ MD5|RSA, "MD5_RSA", NULLCP, MD5RSAALG, SIG, 256, 1024 },

	{ 0, NULLCP, NULLCP, NULLCP, 0, 0, 0 }
};
#endif	/* DEFINE_DATA */

/* Crypto algorithm table routines */
extern struct algent *getalgcode(), *getalgstr(), *getalghdrstr(),
		     *getalgoidstr(), *getalgoid(), *dupalgent();


/* Current algorithm, key and mode set by set_key */

#include "bbuf.h"

extern int curalg;
extern struct bbuf *curparms;
extern struct bbuf *curdata;

/* Pseudorandom crypto routine declarations */

extern struct bbuf *seedbb;
extern struct bbuf *seedbysig();
extern struct bbuf *seedbyscript();
extern struct bbuf *pseudorandom();

#endif	/* not _CRYPTO_ */
