/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>		/* we need stderr */
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "userlist.h"
#include "util.h"

static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static int user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static int error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}

struct user_list *validate_user();

mossvalidate_main(argc, argv)
int argc;
char **argv;
{
    char             **av = NULLVP,
                     **me = NULLVP,
                     **user = NULLVP,
                     **myalias = NULLVP;
    char              *puser = NULLCP;
    struct cbstruct    iocbs;
    struct user_list  *roots = NULLUL,
                      *todo = NULLUL,
                      *tmpul = NULLUL,
                      *userl,
                      *valid_path = NULLUL;
    int                trusted;

    if (argc < 3 || !strcmp(argv[1], "help")) {
        (void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s %s\n", *argv, "alias <alias>");
	return(1);
    }

    if (moss_init(argc, argv, &av) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", *argv);
	return(1);
    }

    /* set up callbacks in case we need them */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.out_errs = error_out;
    iocbs.out_user = error_out;

    /* process arguments */

    if (tag_user(av, "alias") == NULLVP) {
	(void) fprintf(stderr, "%s: missing alias\n", *argv);
	return(1);
    }

    /* get my user records so I know where the root is */

    if ((myalias = tag_user(user_tailor, "my-alias")) == NULLVP) {
	fprintf(stderr, "%s: missing my-alias.\n", *argv);
	return(1);
    }

    rewind_indexfile();
    while ((me = get_tv_user("alias", *(myalias+1))) != NULLVP) {
	struct user_list *up;

	up = alloc_ul();
	up->user = me;
	up->next = roots;
	roots = up;
    }
    if (roots == NULLUL) {
	(void) fprintf(stderr, "%s: missing user for tag my-alias value %s\n",
		       *argv, *(myalias+1));
	return(1);
    }

    /* okay, switch to stdout and output the results */
	
    iocbs.out_user = user_out;
	
    /* Print roots */

    for (userl = roots; userl != NULLUL; userl = userl->next) {
	if (userl == roots)
	    cp2cb(iocbs.out_user, "With root ");
	else
	    cp2cb(iocbs.out_user, "And with root ");
	puser = pretty_user(userl->user);
	cp2cb(iocbs.out_user, puser);
	cp2cb(iocbs.out_user, "\n");
	FREE(puser);
    }

    /* Get the list of user records to validate.  We have to do this
       now because validate_user() might need to access the database, 
       too, and we don't want to confuse things.
     */

    rewind_indexfile();

    while ((user = get_tvt_user(av)) != NULLVP) {
	tmpul = alloc_ul();
	tmpul->user = user;
	user = NULLVP;
	tmpul->next = todo;
	todo = tmpul;
    }

    if (todo == NULLUL) {
        cp2cb(iocbs.out_errs,
              "No user records found matching suppliaded alias.\n");
        return(1);
    }

    for (tmpul = todo; tmpul != NULLUL; tmpul = tmpul->next) {

	user = tmpul->user;
	
	/* do the validation */
	
	valid_path = validate_user(user, roots, &trusted);
	
	cp2cb(iocbs.out_user, "\nFound ");
	if (trusted)
	    cp2cb(iocbs.out_user, "trusted");
	else
	    cp2cb(iocbs.out_user, "UNTRUSTED");
	cp2cb(iocbs.out_user, " path for ");
	puser = pretty_user(user);
	cp2cb(iocbs.out_user, puser);
	FREE(puser);
	cp2cb(iocbs.out_user, ":\n");

	
	for (userl = valid_path; userl != NULLUL; userl = userl->next) {
	    if (userl == valid_path) 
		cp2cb(iocbs.out_user, "  Starting with ");
	    else
		cp2cb(iocbs.out_user, "  which is trusted by ");
	    puser = pretty_user(userl->user);
	    cp2cb(iocbs.out_user, puser);
	    FREE(puser);
	    if (userl->next == NULLUL)
		cp2cb(iocbs.out_user, ".\n");
	    else
		cp2cb(iocbs.out_user, ",\n");

	    
	    if (userl->status == BUNKNOWN) 
		cp2cb(iocbs.out_user, "    Status is unknown.\n");
	    else {
		
		if (userl->status & BSLFSGN)
		    cp2cb(iocbs.out_user,
			  "    Self signed.\n");
		
		if (userl->status & BNOVAL)
		    cp2cb(iocbs.out_user, 
			  "    Validity period is not present.\n");
		else if (userl->status & BBADVAL)
		    cp2cb(iocbs.out_user,
			  "    Certificate has expired.\n");
		
		if (userl->status & BNOSIG)         
		    cp2cb(iocbs.out_user,
			  "    Signature is not present.\n"); 
		else if (userl->status & BNOISS) 
		    cp2cb(iocbs.out_user, 
			  "    Issuer record is not present.\n"); 
		else if (userl->status & BBADSIG)
		    cp2cb(iocbs.out_user, 
			  "    Signature is invalid.\n"); else ;
		
		if (userl->status & BNOCRL)
		    cp2cb(iocbs.out_user,
			  "    Issuer CRL is not present.\n");
		else if (userl->status & BBADCRL)
		    cp2cb(iocbs.out_user, 
			  "    Certificate has been revoked by issuer");
		
		if (userl->status & BNOSDN)
		    cp2cb(iocbs.out_user, 
			  "    Certificate subject name is not present.\n");
		else if (userl->status & BNOIDN)
		    cp2cb(iocbs.out_user, 
			  "    Certificate issuer name is not present.\n");
	    }
	    
	}
	
    }

    return(0);
}
