/*
 *  SecuDE Release 4.3 (GMD)
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#ifdef MAC
#include <stdlib.h>        /* wg. malloc() */
#include <ctype.h>         /* wg. isalnum() */
#include <string.h>        /* wg. strlen()... */
#include "Mac.h"
#include "pem.h"
#else
#include "pem.h"
#include "cadb.h"
#endif

#ifdef SYSV
#include <termio.h>
#else
#include <termios.h>
#endif /* SYSV */

#ifdef __STDC__
	static char	*error_addr_cpy	(char *addr, Struct_No addrtype);
	static int	aux_tlexequ	(register char *a, register char *b);
#else
	static char	*error_addr_cpy	();
	static int	aux_tlexequ	();
#endif

/***************************************************************
 *
 * Procedure PSEobj
 *
 ***************************************************************/
#ifdef __STDC__

Key *PSEobj(
	char		 *name
)

#else

Key *PSEobj(
	name
)
char		 *name;

#endif

{
	static Key key;
	static PSESel psesel;

	psesel.app_name = AF_pse.app_name;
	psesel.pin = AF_pse.pin;
	psesel.object.name = name;
	key.key = (KeyInfo *)0;
	key.keyref = 0;
	key.pse_sel = &psesel;
	key.alg = (AlgId *)0;;
	return(&key);
}


/***************************************************************
 *
 * Procedure error_addr_cpy
 *
 ***************************************************************/
#ifdef __STDC__

static char *error_addr_cpy(
	char		 *addr,
	Struct_No	  addrtype
)

#else

static char *error_addr_cpy(
	addr,
	addrtype
)
char		 *addr;
Struct_No	  addrtype;

#endif

{

	PSESel *dd;

	if (!addr) return((char *)0);

	switch (addrtype) {
	case char_n:
		return((char *)aux_cpy_Name(addr));
	case int_n:
		return(addr);
	case DName_n:
		return((char *)aux_cpy_DName((DName *)addr));
	case Certificate_n:
		return((char *)aux_cpy_Certificate((Certificate *)addr));
	case CertificatePair_n:
		return((char *)aux_cpy_CertificatePair((CertificatePair *)addr));
	case Certificates_n:
		return((char *)aux_cpy_Certificates((Certificates *)addr));
	case PKList_n:
		return((char *)aux_cpy_PKList((PKList *)addr));
	case OctetString_n:
		return((char *)aux_cpy_OctetString((OctetString *)addr));
	case BitString_n:
		return((char *)aux_cpy_BitString((BitString *)addr));
	case SET_OF_Certificate_n:
		return((char *)aux_cpy_SET_OF_Certificate((SET_OF_Certificate *)addr));
	case SET_OF_CertificatePair_n:
		return((char *)aux_cpy_SET_OF_CertificatePair((SET_OF_CertificatePair *)addr));
	case AlgId_n:
		return((char *)aux_cpy_AlgId((AlgId *)addr));
	case OCList_n:
		return((char *)aux_cpy_OCList((OCList *)addr));
	case CRLTBS_n:
		return((char *)aux_cpy_CRLTBS((CRLTBS *)addr));
	case CRL_n:
		return((char *)aux_cpy_CRL((CRL *)addr));
	case CRLEntry_n:
		return((char *)aux_cpy_CRLEntry((CRLEntry *)addr));
	case CrlSet_n:
		return((char *)aux_cpy_CrlSet((CrlSet *)addr));
	case Crl_n:
		return((char *)aux_cpy_Crl ((Crl *)addr));
	case PemInfo_n:
		return((char *)aux_cpy_PemInfo((PemInfo *)addr));
	case KeyInfo_n:
		return((char *)aux_cpy_KeyInfo((KeyInfo *)addr));
	case FCPath_n:
		return((char *)aux_cpy_FCPath((FCPath *)addr));
	case PKRoot_n:
		return((char *)aux_cpy_PKRoot((PKRoot *)addr));
	case IssuedCertificate_n:
		return((char *)aux_cpy_IssuedCertificate((IssuedCertificate *)addr));
	case SET_OF_IssuedCertificate_n:
		return((char *)aux_cpy_SET_OF_IssuedCertificate((SET_OF_IssuedCertificate *)addr));
	case SET_OF_Name_n:
		return((char *)aux_cpy_SET_OF_Name((SET_OF_Name *)addr));
	case ToBeSigned_n:
		return((char *)aux_cpy_ToBeSigned((ToBeSigned *)addr));
	case ObjId_n:
		return((char *)aux_cpy_ObjId((ObjId *)addr));
	case KeyBits_n:
		return((char *)aux_cpy_KeyBits((KeyBits *)addr));
	case PSEToc_n:
		return((char *)aux_cpy_PSEToc((PSEToc *)addr));
	case PSESel_n:
		dd = aux_cpy_PSESel((PSESel *)addr);
		if(dd->pin) strzfree(&(dd->pin));
		if(dd->object.pin) strzfree(&(dd->object.pin));
		return((char *)dd);
	}
	return((char *)0);

}

/***************************************************************
 *
 * Procedure aux_set_pse
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_set_pse(
	char	 *psename,
	char	 *cadir
)

#else

RC aux_set_pse(
	psename,
	cadir
)
char	 *psename;
char	 *cadir;

#endif

{
	char *psepath, *pin;

	if (!psename) {
		if(cadir) {
			psename = getenv("CAPSE");
			if(!psename) psename = DEF_CAPSE;
		}
		else {
			psename = getenv("PSE");
			if(!psename) psename = DEF_PSE;
		}
	}

	if (cadir) {
		psepath = (char *) malloc(strlen(cadir) + strlen(psename) + 2);
		if (!psepath) return(-1);
		strcpy(psepath, cadir);
		if (psepath[strlen(psepath) - 1] != PATH_SEPARATION_CHAR)
			strcat(psepath, PATH_SEPARATION_STRING);
		strcat(psepath, psename);
	} else {
		psepath = (char *) malloc(strlen(psename) + 2);
		if (!psepath) return(-1);
		strcpy(psepath, psename);
	}

	if (cadir)
		pin = getenv("CAPIN");
        else
		pin = getenv("USERPIN");

	if (aux_create_AFPSESel(psepath, pin) < 0) return(-1);
	free(psepath);
	return(0);
}


/***************************************************************
 *
 * Procedure aux_create_AFPSESel
 *
 ***************************************************************/
#ifdef __STDC__

int aux_create_AFPSESel(
	char	 *appname,
	char	 *pin
)

#else

int aux_create_AFPSESel(
	appname,
	pin
)
char	 *appname;
char	 *pin;

#endif

{
	int 	   i, pinlen;
	char	 * proc = "aux_create_AFPSESel";


	if (!appname) return - 1;

	AF_pse.app_name = aux_cpy_String(appname);

	if (!pin) {
		AF_pse.pin = CNULL;
		for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = CNULL;
		return 0;
	}

	AF_pse.pin = aux_cpy_String(pin);

/*	for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = aux_cpy_String(pin); */
	for (i = 0; i < PSE_MAXOBJ; i++) AF_pse.object[i].pin = CNULL;

	return 0;
}


/***************************************************************
 *
 * Procedure aux_add_error
 *
 ***************************************************************/
#ifdef __STDC__

void aux_add_error(
	int		  number,
	char		 *text,
	char		 *addr,
	Struct_No	  addrtype,
	char		 *proc
)

#else

void aux_add_error(
	number,
	text,
	addr,
	addrtype,
	proc
)
int		  number;
char		 *text;
char		 *addr;
Struct_No	  addrtype;
char		 *proc;

#endif

{
	struct ErrStack  * err;
	char		 * local_proc = "aux_add_error";


        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_is_error = TRUE;
		err->e_number   = number;
		err->e_text     = aux_cpy_String(text);
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} 
	else {
		err_malloc.e_is_error = TRUE;
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}
        return;
}
/***************************************************************
 *
 * Procedure aux_add_warning
 *
 ***************************************************************/
#ifdef __STDC__

void aux_add_warning(
	int		  number,
	char		 *text,
	char		 *addr,
	Struct_No	  addrtype,
	char		 *proc
)

#else

void aux_add_warning(
	number,
	text,
	addr,
	addrtype,
	proc
)
int		  number;
char		 *text;
char		 *addr;
Struct_No	  addrtype;
char		 *proc;

#endif

{
	struct ErrStack  * err;
	char		 * local_proc = "aux_add_warning";


        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_number   = number;
		err->e_text     = text;
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} else {
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}

	for(err = err_stack; err; err = err->next) err->e_is_error = FALSE;

        return;
}

/***************************************************************
 *
 * Procedure aux_last_error
 *
 ***************************************************************/
#ifdef __STDC__

int aux_last_error(
)

#else

int aux_last_error(
)

#endif
{

	if(err_stack) return(err_stack->e_number);
	else return(0);
}


/***************************************************************
 *
 * Procedure aux_cpy_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_cpy_ObjId(
	ObjId	 *oid
)

#else

ObjId *aux_cpy_ObjId(
	oid
)
ObjId	 *oid;

#endif

{
	ObjId   * dup_oid;
	char	* proc = "aux_cpy_ObjId";


	if ( (oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) )
		return( (ObjId * )0 );

	if ( (dup_oid = (ObjId * )malloc(sizeof(ObjId)))
	     == (ObjId * )0 ) {
		aux_add_error(EMALLOC, "dup_oid", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	if (aux_cpy2_ObjId (dup_oid, oid)) {
		aux_add_error(LASTERROR, "aux_cpy2_ObjId failed", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	return( dup_oid );
}


/***************************************************************
 *
 * Procedure aux_cpy_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

PSESel *aux_cpy_PSESel(
	PSESel	 *psesel
)

#else

PSESel *aux_cpy_PSESel(
	psesel
)
PSESel	 *psesel;

#endif

{
	PSESel  * dup_psesel;
	char	* proc = "aux_cpy_PSESel";

	if(!psesel) return((PSESel *)0);

	if ( (dup_psesel = (PSESel * )calloc(1, sizeof(PSESel))) == (PSESel * )0 ) {
		aux_add_error(EMALLOC, "dup_PSESel", CNULL, 0, proc);
		return( (PSESel * )0 );
	}

	dup_psesel->app_name = aux_cpy_String(psesel->app_name);
	dup_psesel->pin = aux_cpy_String(psesel->pin);
	dup_psesel->object.name = aux_cpy_String(psesel->object.name);
	dup_psesel->object.pin = aux_cpy_String(psesel->object.pin);
	dup_psesel->app_id = psesel->app_id;
	return(dup_psesel);
}


/***************************************************************
 *
 * Procedure aux_cpy2_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_ObjId(
	ObjId	 *dup_oid,
	ObjId	 *oid
)

#else

int aux_cpy2_ObjId(
	dup_oid,
	oid
)
ObjId	 *dup_oid;
ObjId	 *oid;

#endif

{
	int	  i;
	char	* proc = "aux_cpy2_ObjId";


	if ( (oid == (ObjId * )0) || (dup_oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_oid->oid_nelem = oid->oid_nelem;
	if ( !dup_oid->oid_nelem ) {
		dup_oid->oid_nelem = 0;
		dup_oid->oid_elements = (unsigned *)0;
	} else {
		if ( (dup_oid->oid_elements
		     = (unsigned int *)malloc(oid->oid_nelem * sizeof(unsigned int)))
		     == (unsigned int *)0 ) {
			aux_add_error(EMALLOC, "dup_oid->oid_elements", CNULL, 0, proc);
			return( -1 );
		} else
			for ( i = 0; i < oid->oid_nelem; i++)
				dup_oid->oid_elements[i] = oid->oid_elements[i];
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cmp_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_ObjId(
	ObjId	 *oid1,
	ObjId	 *oid2
)

#else

int aux_cmp_ObjId(
	oid1,
	oid2
)
ObjId	 *oid1;
ObjId	 *oid2;

#endif

{
	int	  i;
	char	* proc = "aux_cmp_ObjId";

	if ( !oid1 && !oid2 )
		return( 0) ;
	if ( !oid1 || !oid2 )
		return( 1) ;


	if ( oid1->oid_nelem == oid2->oid_nelem ) {
		for ( i = 0; i < oid1->oid_nelem; i++) {
			if ( oid1->oid_elements[i] != oid2->oid_elements[i] )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cpy_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_cpy_AlgId(
	AlgId	 *aid
)

#else

AlgId *aux_cpy_AlgId(
	aid
)
AlgId	 *aid;

#endif

{
	AlgId   * dup_aid;
	char	* proc = "aux_cpy_AlgId";


	if ( (aid == (AlgId * )0) || (aid->objid == (ObjId * )0) )
		return( (AlgId * )0 );


	if ( (dup_aid = (AlgId * )malloc(sizeof(AlgId))) == (AlgId * )0 ) {
		aux_add_error(EMALLOC, "dup_aid", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	if (aux_cpy2_AlgId (dup_aid, aid)) {
		aux_add_error(LASTERROR, "aux_cpy2_AlgId failed", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	return( dup_aid );
}


/***************************************************************
 *
 * Procedure aux_cpy2_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_AlgId(
	AlgId	 *dup_aid,
	AlgId	 *aid
)

#else

int aux_cpy2_AlgId(
	dup_aid,
	aid
)
AlgId	 *dup_aid;
AlgId	 *aid;

#endif

{
	int			   i;
	rsa_parm_type    	 * rsa_p1;
	desCBC_parm_type 	 * des_p1, * des_p2;
	char			 * proc = "aux_cpy2_AlgId";


	if ( (aid == (AlgId * )0) || (dup_aid == (AlgId * )0) || (aid->objid == (ObjId * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_aid->objid = aux_cpy_ObjId(aid->objid);
	if (!dup_aid->objid) {
		aux_add_error(LASTERROR, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return(-1);
	}

	if ( !aid->param ) {
		dup_aid->param = (char *)0 ;
		return( 0 );
	}

	switch ( aux_ObjId2ParmType( dup_aid->objid ) ) {

	case PARM_INTEGER:
		if ( !(rsa_p1 = (rsa_parm_type * )malloc(sizeof(rsa_parm_type))) ) {
			aux_add_error(EMALLOC, "rsa_p1", CNULL, 0, proc);
			return( -1 );
		}
		*rsa_p1 = RSA_PARM(aid->param);
		dup_aid->param = (char *)rsa_p1;
		break;
	case PARM_KeyBits:
		if ( !(dup_aid->param = (char *)aux_cpy_KeyBits((KeyBits *)aid->param)) ) {
			aux_add_error(LASTERROR, "aux_cpy_KeyBits", CNULL, 0, proc);
			return( -1 );
		}

		break;
	case PARM_OctetString:
		if ( !(des_p1 = (desCBC_parm_type * )
		    malloc(sizeof(desCBC_parm_type))) ) {
			aux_add_error(EMALLOC, "des_p1", CNULL, 0, proc);
			return( -1 );
		}
		des_p2 = (desCBC_parm_type * )(aid->param);
		des_p1->noctets = des_p2->noctets;
		if(des_p2->noctets) {
			if ( !(des_p1->octets = (char *)malloc(des_p1->noctets)) ) {
				aux_add_error(EMALLOC, "des_p1->octets", CNULL, 0, proc);
				return( -1 );
			}
			bcopy(des_p2->octets, des_p1->octets, des_p2->noctets);
		}
		else des_p1->octets = aux_cpy_String("");
		dup_aid->param = (char *)des_p1;
		break;
	default:
		/* non-standard parm ignored */
		dup_aid->param = (char *)0;
		break;
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cmp_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_AlgId(
	AlgId	 *aid1,
	AlgId	 *aid2
)

#else

int aux_cmp_AlgId(
	aid1,
	aid2
)
AlgId	 *aid1;
AlgId	 *aid2;

#endif

{
	int	i;
	rsa_parm_type     * rsa_p1, *rsa_p2;
	desCBC_parm_type * des_p1, *des_p2;
	dhKeyAgreement_parm_type * dh_p1, *dh_p2;

	char	*proc = "aux_cmp_AlgId";

	if ( !aid1 && !aid2 )
		return( 0) ;
	if ( !aid1 || !aid2 )
		return( 1) ;

	if ( !aux_cmp_ObjId(aid1->objid, aid2->objid) ) {

		if ( !aid1->param || !aid2->param ) {
			if ( !aid1->param && !aid2->param )
				return( 0 );
			else
				return( 1 );
		}

		switch ( aux_ObjId2ParmType( aid1->objid ) ) {

		case PARM_NULL:
			return(0);
		case PARM_KeyBits:
			dh_p1 = (dhKeyAgreement_parm_type * )(aid1->param);
			dh_p2 = (dhKeyAgreement_parm_type * )(aid2->param);
			return( aux_cmp_KeyBits(dh_p1, dh_p2) );
		case PARM_INTEGER:
			rsa_p1 = (rsa_parm_type * )(aid1->param);
			rsa_p2 = (rsa_parm_type * )(aid2->param);
			if ( *rsa_p1 == *rsa_p2 )
				return( 0 );
			else
				return( 1 );
		case PARM_OctetString:
			des_p1 = (desCBC_parm_type * )(aid1->param);
			des_p2 = (desCBC_parm_type * )(aid2->param);
			if ( des_p1->noctets == des_p2->noctets ) {
				if(bcmp(des_p1->octets, des_p2->octets, des_p1->noctets)) return(1);
				return( 0 );
			} 
			else
				return( 1 );

		default:
			/* objids are equal, but parms cannot be compared */
			return( 1 );
		}
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cpy_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

KeyInfo *aux_cpy_KeyInfo(
	KeyInfo	 *keyinfo
)

#else

KeyInfo *aux_cpy_KeyInfo(
	keyinfo
)
KeyInfo	 *keyinfo;

#endif

{
	KeyInfo * dup_ki;
	char	* proc = "aux_cpy_KeyInfo";


	if ((keyinfo == (KeyInfo * )0))
		return( (KeyInfo * )0);
	if ((dup_ki = (KeyInfo * )malloc(sizeof(KeyInfo))) == (KeyInfo * )0 ) {
		aux_add_error(EMALLOC, "dup_ki", CNULL, 0, proc);
		return((KeyInfo * )0);
	}
	if (aux_cpy2_KeyInfo (dup_ki, keyinfo)) {
		aux_add_error(LASTERROR, "aux_cpy2_KeyInfo failed", CNULL, 0, proc);
		return( (KeyInfo * )0 );
	}
	return(dup_ki);
}


/***************************************************************
 *
 * Procedure aux_cpy2_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_KeyInfo(
	KeyInfo	 *dup_ki,
	KeyInfo	 *keyinfo
)

#else

int aux_cpy2_KeyInfo(
	dup_ki,
	keyinfo
)
KeyInfo	 *dup_ki;
KeyInfo	 *keyinfo;

#endif

{
	char	* proc = "aux_cpy2_KeyInfo";


	if ( (keyinfo == (KeyInfo * )0) || (dup_ki == (KeyInfo * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}


	dup_ki->subjectAI = aux_cpy_AlgId(keyinfo->subjectAI);
	if (!dup_ki->subjectAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_BitString(&dup_ki->subjectkey, &keyinfo->subjectkey)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy2_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DigestInfo(
	DigestInfo	 *dup_dig,
	DigestInfo	 *dig
)

#else

int aux_cpy2_DigestInfo(
	dup_dig,
	dig
)
DigestInfo	 *dup_dig;
DigestInfo	 *dig;

#endif

{
	char	* proc = "aux_cpy2_DigestInfo";


	if ( (dig == (DigestInfo * )0) || (dup_dig == (DigestInfo * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_dig->digestAI = aux_cpy_AlgId(dig->digestAI);
	if (!dup_dig->digestAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_OctetString(&dup_dig->digest, &dig->digest)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

DigestInfo *aux_cpy_DigestInfo(
	DigestInfo	 *dig
)

#else

DigestInfo *aux_cpy_DigestInfo(
	dig
)
DigestInfo	 *dig;

#endif

{
	DigestInfo  * dup_dig;
	char	   * proc = "aux_cpy_DigestInfo";


	if ((dig == (DigestInfo * )0))
		return( (DigestInfo * )0);
	if ((dup_dig = (DigestInfo * )malloc(sizeof(DigestInfo))) == (DigestInfo * )0 ) {
		aux_add_error(EMALLOC, "dup_dig", CNULL, 0, proc);
		return((DigestInfo * )0);
	}
	if (aux_cpy2_DigestInfo (dup_dig, dig)) {
		aux_add_error(LASTERROR, "aux_cpy2_DigestInfo failed", CNULL, 0, proc);
		return( (DigestInfo * )0 );
	}
	return(dup_dig);
}


/***************************************************************
 *
 * Procedure aux_cpy2_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_EncryptedKey(
	EncryptedKey	 *dup_enki,
	EncryptedKey	 *enki
)

#else

int aux_cpy2_EncryptedKey(
	dup_enki,
	enki
)
EncryptedKey	 *dup_enki;
EncryptedKey	 *enki;

#endif

{
	char	* proc = "aux_cpy2_EncryptedKey";


	if ( (enki == (EncryptedKey * )0) || (dup_enki == (EncryptedKey * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_enki->encryptionAI = aux_cpy_AlgId(enki->encryptionAI);
	if (!dup_enki->encryptionAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}

	dup_enki->subjectAI = aux_cpy_AlgId(enki->subjectAI);
	if (!dup_enki->subjectAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}

	if (aux_cpy2_BitString(&dup_enki->subjectkey, &enki->subjectkey)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

EncryptedKey *aux_cpy_EncryptedKey(
	EncryptedKey	 *enki
)

#else

EncryptedKey *aux_cpy_EncryptedKey(
	enki
)
EncryptedKey	 *enki;

#endif

{
	EncryptedKey  * dup_enki;
	char	      * proc = "aux_cpy_EncryptedKey";


	if ((enki == (EncryptedKey * )0))
		return( (EncryptedKey * )0);
	if ((dup_enki = (EncryptedKey * )malloc(sizeof(EncryptedKey))) == (EncryptedKey * )0 ) {
		aux_add_error(EMALLOC, "dup_enki", CNULL, 0, proc);
		return((EncryptedKey * )0);
	}
	if (aux_cpy2_EncryptedKey (dup_enki, enki)) {
		aux_add_error(LASTERROR, "aux_cpy2_EncryptedKey failed", CNULL, 0, proc);
		return( (EncryptedKey * )0 );
	}
	return(dup_enki);
}


/***************************************************************
 *
 * Procedure aux_cpy_Validity
 *
 ***************************************************************/
#ifdef __STDC__

Validity *aux_cpy_Validity(
	Validity	 *valid
)

#else

Validity *aux_cpy_Validity(
	valid
)
Validity	 *valid;

#endif

{
	Validity   * dup_valid;
	char	   * proc = "aux_cpy_Validity";


	if (! valid)
		return ( (Validity * )0 );

	if ( !(dup_valid = (Validity * )malloc(sizeof(Validity))) ) {
		aux_add_error(EMALLOC, "dup_valid", CNULL, 0, proc);
		return ( (Validity * )0 );
	}

	dup_valid->notbefore = aux_cpy_String(valid->notbefore);
	dup_valid->notafter = aux_cpy_String(valid->notafter);

	return (dup_valid);
}


/***************************************************************
 *
 * Procedure aux_cmp_BitString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_BitString(
	BitString	 *bitstring1,
	BitString	 *bitstring2
)

#else

int aux_cmp_BitString(
	bitstring1,
	bitstring2
)
BitString	 *bitstring1;
BitString	 *bitstring2;

#endif

{
	int	  i, nob, rob;
	char	* proc = "aux_cmp_Bitstring";

	if ( !bitstring1 && !bitstring2 )
		return( 0) ;
	if ( !bitstring1 || !bitstring2 )
		return( 1) ;

	if ( (nob = bitstring1->nbits) == bitstring2->nbits ) {
		rob = nob % 8;
		nob = nob / 8;
		if(bcmp(bitstring1->bits, bitstring2->bits, nob)) return(1);
		if ( rob ) {
			if ( ((unsigned char)bitstring2->bits[nob] >> (8 - rob)) != 
			    ((unsigned char)bitstring1->bits[nob] >> (8 - rob)) )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cmp_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_OctetString(
	OctetString	 *octetstring1,
	OctetString	 *octetstring2
)

#else

int aux_cmp_OctetString(
	octetstring1,
	octetstring2
)
OctetString	 *octetstring1;
OctetString	 *octetstring2;

#endif

{
	int	       s;
	unsigned char  a, b;
	char	       *proc = "aux_cmp_OctetString";

	if ( !octetstring1 && !octetstring2 )
		return( 0) ;
	if ( !octetstring1 || !octetstring2 )
		return( 1) ;

	if (octetstring1->noctets > octetstring2->noctets)
		return(1);
	else if (octetstring1->noctets < octetstring2->noctets)
		return(2);
	else{
		s = 0;
		while (s < octetstring1->noctets && octetstring1->octets[s] == octetstring2->octets[s])
			s++;
		if(s == octetstring1->noctets)
			return(0);
		a = octetstring1->octets[s];
		b = octetstring2->octets[s];
		if(a > b) return(1);
		else return(2);
	}
}


/***************************************************************
 *
 * Procedure aux_cmp_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_KeyInfo(
	KeyInfo	 *keyinfo1,
	KeyInfo	 *keyinfo2
)

#else

int aux_cmp_KeyInfo(
	keyinfo1,
	keyinfo2
)
KeyInfo	 *keyinfo1;
KeyInfo	 *keyinfo2;

#endif

{
	char	* proc = "aux_cmp_KeyInfo";

	if ( !keyinfo1 && !keyinfo2 )
		return( 0) ;
	if ( !keyinfo1 || !keyinfo2 )
		return( 1) ;

	if ( !aux_cmp_AlgId(keyinfo1->subjectAI, keyinfo2->subjectAI) ) {
		return( aux_cmp_BitString(&keyinfo1->subjectkey, &keyinfo2->subjectkey) );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cmp_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_KeyBits(
	KeyBits	 *keybits1,
	KeyBits	 *keybits2
)

#else

int aux_cmp_KeyBits(
	keybits1,
	keybits2
)
KeyBits	 *keybits1;
KeyBits	 *keybits2;

#endif

{
	char	* proc = "aux_cmp_KeyBits";

	if (!keybits1 || !keybits2) {
		if(!keybits1 && !keybits2) return(0);
		return(1);
	}
	if ( aux_cmp_OctetString(&keybits1->part1, &keybits2->part1) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part2, &keybits2->part2) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part3, &keybits2->part3) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part4, &keybits2->part4) ) return( 1 );
	return(0);
}


/***************************************************************
 *
 * Procedure aux_cmp_Signature
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Signature(
	Signature	 *sig1,
	Signature	 *sig2
)

#else

int aux_cmp_Signature(
	sig1,
	sig2
)
Signature	 *sig1;
Signature	 *sig2;

#endif

{
	char	* proc = "aux_cmp_Signature";

	if ( !sig1 && !sig2 )
		return( 0) ;
	if ( !sig1 || !sig2 )
		return( 1) ;

	if ( !aux_cmp_AlgId(sig1->signAI, sig2->signAI) ) {
		return( aux_cmp_BitString(&sig1->signature, &sig2->signature) );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_ObjId2PSEObjectName
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_ObjId2PSEObjectName(
	ObjId	 *given_objid
)

#else

char *aux_ObjId2PSEObjectName(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register int   i;
	char	     * proc = "aux_ObjId2PSEObjectName";

	if (!given_objid) return((char *)0);

	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!aux_cmp_ObjId(given_objid, AF_pse.object[i].oid))
			return(aux_cpy_Name(AF_pse.object[i].name));
	}
	return((char *)0);
}

/***************************************************************
 *
 * Procedure aux_PSEObjectName2ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_PSEObjectName2ObjId(
	char	 *name
)

#else

ObjId *aux_PSEObjectName2ObjId(
	name
)
char	 *name;

#endif

{
	register int   i;
	char	     * proc = "aux_PSEObjectName2ObjId";

	if (!name) return((ObjId * )0);
	for(i = 0; i < PSE_MAXOBJ; i++) {
		if (!strcmp(name, AF_pse.object[i].name))
			return(aux_cpy_ObjId(AF_pse.object[i].oid));
	}
	return((ObjId * )0);
}

/***************************************************************
 *
 * Procedure aux_Name2ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_Name2ObjId(
	char	 *name
)

#else

ObjId *aux_Name2ObjId(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ObjId";

	if (!name)
		return((ObjId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_ObjId(a->algid->objid));
		a++;
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_Name2AlgId(
	char	 *name
)

#else

AlgId *aux_Name2AlgId(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgId";

	if (!name)
		return((AlgId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgType
 *
 ***************************************************************/
#ifdef __STDC__

AlgType aux_Name2AlgType(
	char	 *name
)

#else

AlgType aux_Name2AlgType(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgType";

	if (!name)
		return(NoAlgType);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algtype);
		a++;
	}
	return(NoAlgType);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgEnc
 *
 ***************************************************************/
#ifdef __STDC__

AlgEnc aux_Name2AlgEnc(
	char	 *name
)

#else

AlgEnc aux_Name2AlgEnc(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgEnc";

	if (!name)
		return(NoAlgEnc);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algenc);
		a++;
	}
	return(NoAlgEnc);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgHash
 *
 ***************************************************************/
#ifdef __STDC__

AlgHash aux_Name2AlgHash(
	char	 *name
)

#else

AlgHash aux_Name2AlgHash(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgHash";

	if (!name)
		return(NoAlgHash);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->alghash);
		a++;
	}
	return(NoAlgHash);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgMode
 *
 ***************************************************************/
#ifdef __STDC__

AlgMode aux_Name2AlgMode(
	char	 *name
)

#else

AlgMode aux_Name2AlgMode(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgMode";

	if (!name)
		return(NoAlgMode);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algmode);
		a++;
	}
	return(NoAlgMode);
}

/***************************************************************
 *
 * Procedure aux_Name2AlgSpecial
 *
 ***************************************************************/
#ifdef __STDC__

AlgSpecial aux_Name2AlgSpecial(
	char	 *name
)

#else

AlgSpecial aux_Name2AlgSpecial(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgSpecial";

	if (!name)
		return(NoAlgSpecial);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algspecial);
		a++;
	}
	return(NoAlgSpecial);
}

/***************************************************************
 *
 * Procedure aux_Name2ParmType
 *
 ***************************************************************/
#ifdef __STDC__

ParmType aux_Name2ParmType(
	char	 *name
)

#else

ParmType aux_Name2ParmType(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ParmType";

	if (!name)
		return(NoParmType);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->parmtype);
		a++;
	}
	return(NoParmType);
}




/***************************************************************
 *
 * Procedure aux_ObjId2Name
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_ObjId2Name(
	ObjId	 *given_objid
)

#else

char *aux_ObjId2Name(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2Name";

	if (!given_objid)
		return((char *)0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_Name(a->name));
		a++;
	}
	return((char *)0);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgType
 *
 ***************************************************************/
#ifdef __STDC__

AlgType aux_ObjId2AlgType(
	ObjId	 *given_objid
)

#else

AlgType aux_ObjId2AlgType(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgType";

	if (!given_objid)
		return(NoAlgType);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algtype);
		a++;
	}
	return(NoAlgType);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgEnc
 *
 ***************************************************************/
#ifdef __STDC__

AlgEnc aux_ObjId2AlgEnc(
	ObjId	 *given_objid
)

#else

AlgEnc aux_ObjId2AlgEnc(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgEnc";

	if (!given_objid)
		return(NoAlgEnc);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algenc);
		a++;
	}
	return(NoAlgEnc);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgHash
 *
 ***************************************************************/
#ifdef __STDC__

AlgHash aux_ObjId2AlgHash(
	ObjId	 *given_objid
)

#else

AlgHash aux_ObjId2AlgHash(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgHash";

	if (!given_objid)
		return(NoAlgHash);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->alghash);
		a++;
	}
	return(NoAlgHash);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgSpecial
 *
 ***************************************************************/
#ifdef __STDC__

AlgSpecial aux_ObjId2AlgSpecial(
	ObjId	 *given_objid
)

#else

AlgSpecial aux_ObjId2AlgSpecial(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgSpecial";

	if (!given_objid)
		return(NoAlgSpecial);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algspecial);
		a++;
	}
	return(NoAlgSpecial);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgMode
 *
 ***************************************************************/
#ifdef __STDC__

AlgMode aux_ObjId2AlgMode(
	ObjId	 *given_objid
)

#else

AlgMode aux_ObjId2AlgMode(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgMode";

	if (!given_objid)
		return(NoAlgMode);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algmode);
		a++;
	}
	return(NoAlgMode);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_ObjId2AlgId(
	ObjId	 *given_objid
)

#else

AlgId *aux_ObjId2AlgId(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgId";

	if (!given_objid)
		return((AlgId * )0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


/***************************************************************
 *
 * Procedure aux_ObjId2ParmType
 *
 ***************************************************************/
#ifdef __STDC__

ParmType aux_ObjId2ParmType(
	ObjId	 *given_objid
)

#else

ParmType aux_ObjId2ParmType(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2ParmType";

	if (!given_objid)
		return(NoParmType);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->parmtype);
		a++;
	}
	return(NoParmType);
}


/***************************************************************
 *
 * Procedure aux_oid2syntaxoid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_oid2syntaxoid(
	ObjId	 *given_objid
)

#else

ObjId *aux_oid2syntaxoid(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2syntaxoid";

	if (!given_objid)
		return((ObjId * )0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(aux_cpy_ObjId(a->syntax_oid));
		a++;
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_cpy_Name
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_cpy_Name(
	char	 *namefrom
)

#else

Name *aux_cpy_Name(
	namefrom
)
char	 *namefrom;

#endif

{
	char	* nameto;
	char	* proc = "aux_cpy_Name";


	if ( ! namefrom )
		return ( (Name *) 0);

	nameto = (char *)malloc(strlen(namefrom) + 1);
	if (!nameto)  {
		aux_add_error(EMALLOC, "nameto", CNULL, 0, proc);
		return(nameto);
	}
	strcpy(nameto, namefrom);
	return(nameto);
}


/***************************************************************
 *
 * Procedure aux_cpy_String
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_cpy_String(
	char	 *str
)

#else

Name *aux_cpy_String(
	str
)
char	 *str;

#endif

{
	char	* new;
	char	* proc = "aux_cpy_String";


	if ( ! str )
		return ( (char *) 0);

	new = (char *)malloc(strlen(str) + 1);
	if (!new)  {
		aux_add_error(EMALLOC, "new", CNULL, 0, proc);
		return(new);
	}
	strcpy(new, str);
	return(new);
}

/***************************************************************
 *
 * Procedure aux_cpy_ReducedString
 *
 ***************************************************************/

/*
 *	cut off blanks at begin and end of string a
 *	return pointer to successfully reduced and allocated string, else NULL
 *	return NULL if string a consists of blanks only
 */

#ifdef __STDC__

char *aux_cpy_ReducedString(
	char	 *a
)

#else

char *aux_cpy_ReducedString(
	a
)
char	 *a;

#endif

{
	register char *aa, *afirst, *alast;

	if (!a || !strcmp(a, "") || !(aa = aux_cpy_String(a)) ) return(CNULL);
	afirst = aa;
	while (afirst)  {
		if (*afirst != ' ') break;
		afirst++;
	}
	if (!*afirst)  {
		if (aa) free(aa);
		return(CNULL);
	}
	alast = aa + strlen(aa);
	while (--alast) if (*alast != ' ') break;
	if (alast < aa) return(aa);
	*(++alast) = '\0';
	strcpy(aa, afirst);
	return(aa);
}
		


/***************************************************************
 *
 * Procedure aux_pstrcmp
 *
 ***************************************************************/
#ifdef __STDC__

int aux_pstrcmp(
	register char	 *a,
	register char	 *b
)

#else

int aux_pstrcmp(
	a,
	b
)
register char	 *a;
register char	 *b;

#endif

{
	while (*a == *b) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (*a > *b)
		return (1);
	else
		return (-1);

}


/***************************************************************
 *
 * Procedure aux_tlexequ
 *
 ***************************************************************/
#ifdef __STDC__

static int aux_tlexequ(
	register char	 *a,
	register char	 *b
)

#else

static int aux_tlexequ(
	a,
	b
)
register char	 *a;
register char	 *b;

#endif

{

	while (chrcnv[*a] == chrcnv[*b]) {
		if (*a++ == 0)
			return (0);
		b++;
	}

	if (chrcnv[*a] > chrcnv[*b])
		return (1);
	else
		return (-1);
}


/***************************************************************
 *
 * Procedure aux_lexequ
 *
 ***************************************************************/
#ifdef __STDC__

int aux_lexequ(
	register char	 *str1,
	register char	 *str2
)

#else

int aux_lexequ(
	str1,
	str2
)
register char	 *str1;
register char	 *str2;

#endif

{
	if (!str1)
		if (!str2)
			return (0);
		else
			return (-1);

	if (!str2)
		return (1);

	while (chrcnv[*str1] == chrcnv[*str2]) {
		if (*str1++ == 0)
			return (0);
		str2++;
	}

	if (chrcnv[*str1] > chrcnv[*str2])
		return (1);
	else
		return (-1);
}


/***************************************************************
 *
 * Procedure aux_cmp_Name
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Name(
	char	 *name1,
	char	 *name2
)

#else

int aux_cmp_Name(
	name1,
	name2
)
char	 *name1;
char	 *name2;

#endif

{
	DName  * dname1, *dname2;
	int	 ret;
	char   * proc = "aux_cmp_Name";


	if ( !name1 && !name2 )
		return( 0) ;
	if ( !name1 || !name2 )
		return( 1) ;

	dname1 = aux_Name2DName(name1);
	dname2 = aux_Name2DName(name2);
	if (!dname1 || !dname2) {
		aux_add_error(LASTERROR, "aux_Name2DName failed", CNULL, 0, proc);
		return(-1);
	}
	ret = aux_cmp_DName(dname1, dname2);
	aux_free2_DName(dname1);
	aux_free2_DName(dname2);

	return(ret);
}


/***************************************************************
 *
 * Procedure RDName_comp_cmp
 *
 ***************************************************************/
#ifdef __STDC__

int RDName_comp_cmp(
	RDName	 *a,
	RDName	 *b
)

#else

int RDName_comp_cmp(
	a,
	b
)
RDName	 *a;
RDName	 *b;

#endif

{
	int	  avlen, ret;
	char	* a_value, * b_value;
	ObjId   * syntax_oid;
	char	* proc = "RDName_comp_cmp";

	if(!aux_cmp_ObjId(a->member_IF_0->element_IF_0, b->member_IF_0->element_IF_0) ) {
		syntax_oid = aux_oid2syntaxoid(a->member_IF_0->element_IF_0);
		a_value = prim2str(a->member_IF_0->element_IF_1, &avlen );
		b_value = prim2str(b->member_IF_0->element_IF_1, &avlen );
		if(!aux_cmp_ObjId(syntax_oid, CountryString)) ret = aux_lexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, CaseIgnoreString)) ret = aux_tlexequ(a_value, b_value);
		else if(!aux_cmp_ObjId(syntax_oid, PrintableString)) ret = aux_pstrcmp(a_value, b_value);
		else ret = 1;  /*unknown syntax_oid*/
		aux_free_ObjId(&syntax_oid);
		free(a_value);
		free(b_value);
		return(ret);
	} 
	else return(1);
}


/***************************************************************
 *
 * Procedure aux_cmp_RDName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_RDName(
	register RDName	 *a,
	register RDName	 *b
)

#else

int aux_cmp_RDName(
	a,
	b
)
register RDName	 *a;
register RDName	 *b;

#endif

{
	char	*proc = "aux_cmp_RDName";

	for (; (a != NULLRDNAME) && (b != NULLRDNAME) ; a = a->next, b = b->next) {
		if ( RDName_comp_cmp(a, b) ) return( 1 );
	}

	if ( (a == NULLRDNAME) && (b == NULLRDNAME) )  {
		return( 0 );
	} 
	else return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cmp_DName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_DName(
	register DName	 *a,
	register DName	 *b
)

#else

int aux_cmp_DName(
	a,
	b
)
register DName	 *a;
register DName	 *b;

#endif

{
	char	*proc = "aux_cmp_DName";

	for (; (a != NULLDNAME) && (b != NULLDNAME) ; a = a->next, b = b->next) {
		if ( aux_cmp_RDName(a->element_IF_2, b->element_IF_2) )
			return( 1 );
	}

	if (( a == NULLDNAME) && (b == NULLDNAME)) {
		return( 0 );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_checkPemDNameSubordination
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_checkPemDNameSubordination(
	DName	 *sup,
	DName	 *sub
)

#else

RC aux_checkPemDNameSubordination(
	sup,
	sub
)
DName	 *sup;
DName	 *sub;

#endif

{
	/* Return Value:
	       -1       error
		0	"sub" is NOT subordinate to "sup"
		1	"sub" is subordinate to "sup"
	*/

	char	*proc = "aux_checkPemDNameSubordination";

	if (! sup || ! sub) {
		aux_add_error(EINVALID, "required parameters NOT provided", CNULL, 0, proc);
		return (- 1);
	}

	for (; (sup != NULLDNAME) && (sub != NULLDNAME) ; sup = sup->next, sub = sub->next) {
		if ( aux_cmp_RDName(sup->element_IF_2, sub->element_IF_2) )
			return (FALSE);
	}

	if ( (sup == NULLDNAME && sub == NULLDNAME) || (sup != NULLDNAME && sub == NULLDNAME) )
		return (FALSE);

	/* sup == NULLDNAME && sub != NULLDNAME */
	return (TRUE);

}

/***************************************************************
 *
 * Procedure aux_PemDNameSubordination
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_PemDNameSubordination(
	DName	 *sup,
	DName	 *sub
)

#else

Name *aux_PemDNameSubordination(
	sup,
	sub
)
DName	 *sup;
DName	 *sub;

#endif

{
	/* Return Value:
	       *Name    subordinated part of sub
		NULL	"sub" is NOT subordinate to "sup"
	*/

	char	*proc = "aux_PemDNameSubordination";

	if (! sup || ! sub) {
		aux_add_error(EINVALID, "required parameters NOT provided", CNULL, 0, proc);
		return ((Name *)0);
	}

	for (; (sup != NULLDNAME) && (sub != NULLDNAME) ; sup = sup->next, sub = sub->next) {
		if ( aux_cmp_RDName(sup->element_IF_2, sub->element_IF_2) )
			return ((Name *)0);
	}

	if ( (sup == NULLDNAME && sub == NULLDNAME) || (sup != NULLDNAME && sub == NULLDNAME) )
		return ((Name *)0);

	/* sup == NULLDNAME && sub != NULLDNAME */
	return (aux_DName2Name(sub));

}
/***************************************************************
 *
 * Procedure aux_PCA
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_PCA(
	VerificationResult	 *vr
)

#else

Name *aux_PCA(
	vr
)
VerificationResult	 *vr;

#endif

{
	int index;
	Name *pca, *pcaalias;

	index = 0;
	while (vr->verifstep &&
	       vr->success == TRUE && vr->verifstep[index]) {
	
		if(vr->verifstep[index+1] && vr->verifstep[index+1]->policy_CA) {
			pca = aux_DName2Name(vr->verifstep[index]->cert->tbs->issuer);
			pcaalias = aux_DName2alias(vr->verifstep[index]->cert->tbs->issuer, LOCALNAME);
			if(pcaalias) {
				free(pca);
				pca = pcaalias;
			}
			return(pca);
		} 
		index++;
	
	}
	return((Name *)0);
}

/***************************************************************
 *
 * Procedure aux_cpy_RDName_comp
 *
 ***************************************************************/
#ifdef __STDC__

RDName *aux_cpy_RDName_comp(
	RDName	 *rdn
)

#else

RDName *aux_cpy_RDName_comp(
	rdn
)
RDName	 *rdn;

#endif

{
	register RDName * ptr;
	char		* proc = "aux_cpy_RDName_comp";


	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}

	ptr = (RDName *)malloc(
	    sizeof(RDName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "ptr", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0 = (AttrValueAssertion *)malloc(
	    sizeof(AttrValueAssertion ) );
	if (!ptr->member_IF_0) {
		aux_add_error(EMALLOC, "ptr->member_IF_0", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_0 = (OIDentifier * )aux_cpy_ObjId(rdn->member_IF_0->element_IF_0);
	if (!ptr->member_IF_0->element_IF_0) {
		aux_add_error(LASTERROR, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr->member_IF_0->element_IF_1 = pe_cpy(rdn->member_IF_0->element_IF_1);
	ptr->next = NULLRDNAME;

	return (ptr);
}


/***************************************************************
 *
 * Procedure aux_cpy_RDName
 *
 ***************************************************************/
#ifdef __STDC__

RDName *aux_cpy_RDName(
	RDName	 *rdn
)

#else

RDName *aux_cpy_RDName(
	rdn
)
RDName	 *rdn;

#endif

{
	RDName * start;
	register RDName *eptr;
	register RDName *ptr, *ptr2;
	char	*proc = "aux_cpy_RDName";

	if (rdn == NULLRDNAME) {
		return (NULLRDNAME);
	}
	start = aux_cpy_RDName_comp (rdn);
	if (!start) {
		aux_add_error(LASTERROR, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}
	ptr2 = start;

	for (eptr = rdn->next; eptr != NULLRDNAME; eptr = eptr->next) {
		ptr = aux_cpy_RDName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_RDName_comp failed", CNULL, 0, proc);
			return (NULLRDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


/***************************************************************
 *
 * Procedure aux_cpy_DName_comp
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_cpy_DName_comp(
	register DName	 *dn
)

#else

DName *aux_cpy_DName_comp(
	dn
)
register DName	 *dn;

#endif

{
	register DName  * ptr;
	char		* proc = "aux_cpy_DName_comp";


	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	ptr = (DName *)malloc(sizeof(DName ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->element_IF_2 = aux_cpy_RDName (dn->element_IF_2);
	if (!ptr->element_IF_2) {
		aux_add_error(LASTERROR, "aux_cpy_RDName failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr->next = NULLDNAME;
	return (ptr);
}


/***************************************************************
 *
 * Procedure aux_cpy_DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_cpy_DName(
	register DName	 *dn
)

#else

DName *aux_cpy_DName(
	dn
)
register DName	 *dn;

#endif

{
	DName 	        * start;
	register DName  * eptr, * ptr, * ptr2;
	char		* proc = "aux_cpy_DName";


	if (dn == NULLDNAME) {
		return (NULLDNAME);
	}
	start = aux_cpy_DName_comp (dn);
	if (!start) {
		aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
		return (NULLDNAME);
	}
	ptr2 = start;
	for (eptr = dn->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return (NULLDNAME);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}
	return (start);
}


/***************************************************************
 *
 * Procedure aux_cpy2_DName_comp
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DName_comp(
	DName	 *dup_dname,
	DName	 *dname
)

#else

int aux_cpy2_DName_comp(
	dup_dname,
	dname
)
DName	 *dup_dname;
DName	 *dname;

#endif

{
	char	* proc = "aux_cpy2_DName_comp";


	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_dname->element_IF_2 = aux_cpy_RDName (dname->element_IF_2);
	if (!dup_dname->element_IF_2) {
		aux_add_error(LASTERROR, "aux_cpy_RDName failed", CNULL, 0, proc);
		return(-1);
	}
	dup_dname->next = NULLDNAME;
	return (0);
}


/***************************************************************
 *
 * Procedure aux_cpy2_DName
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_DName(
	DName	 *dup_dname,
	DName	 *dname
)

#else

int aux_cpy2_DName(
	dup_dname,
	dname
)
DName	 *dup_dname;
DName	 *dname;

#endif

{
	register DName * eptr, * ptr, * ptr2;
	int              rcode;
	char	       * proc = "aux_cpy2_DName";


	if ( (dname == (DName * )0) || (dup_dname == (DName * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	rcode = aux_cpy2_DName_comp (dup_dname, dname);
	if (rcode < 0) {
		aux_add_error(LASTERROR, "aux_cpy2_DName_comp failed", CNULL, 0, proc);
		return(-1);
	}
	ptr2 = dup_dname;
	for (eptr = dname->next; eptr != NULLDNAME; eptr = eptr->next) {
		ptr = aux_cpy_DName_comp (eptr);
		if (!ptr) {
			aux_add_error(LASTERROR, "aux_cpy_DName_comp failed", CNULL, 0, proc);
			return(-1);
		}
		ptr2->next = ptr;
		ptr2 = ptr;
	}

	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_keyword2oid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_keyword2oid(
	char	 *keyword
)

#else

ObjId *aux_keyword2oid(
	keyword
)
char	 *keyword;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2oid";

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(aux_cpy_ObjId(a->objid));
		if (strcmp(keyword, a->keyword) == 0)
			return(aux_cpy_ObjId(a->objid));
		a++;
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_keyword2syntaxoid
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_keyword2syntaxoid(
	char	 *keyword
)

#else

ObjId *aux_keyword2syntaxoid(
	keyword
)
char	 *keyword;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_keyword2syntaxoid";

	if (!keyword)
		return((ObjId * )0);
	while (a->abbrev) {
		if (strcmp(keyword, a->abbrev) == 0)
			return(a->syntax_oid);
		if (strcmp(keyword, a->keyword) == 0)
			return(a->syntax_oid);
		a++;
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_oid2keyword
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_oid2keyword(
	ObjId	 *given_objid
)

#else

char *aux_oid2keyword(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AttrList *a = &attrlist[0];
	char	*proc = "aux_oid2keyword";

	if (!given_objid)
		return((char *)0);
	while (a->abbrev) {
		if (!aux_cmp_ObjId(given_objid, a->objid))
			return(a->abbrev);
		a++;
	}
	return((char *)0);
}



/***************************************************************
 *
 * Procedure aux_cpy_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

Certificate *aux_cpy_Certificate(
	Certificate	 *cert
)

#else

Certificate *aux_cpy_Certificate(
	cert
)
Certificate	 *cert;

#endif

{
	int	      i, nob, lim;
	Certificate * dup_cert;
	char	    * proc = "aux_cpy_Certificate";


	if ( (cert == (Certificate * )0) )
		return( (Certificate * )0 );
	if ( (dup_cert = (Certificate * )malloc(sizeof(Certificate))) == (Certificate * )0 ) {
		aux_add_error(EMALLOC, "dup_cert", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	if (aux_cpy2_Certificate (dup_cert, cert)) {
		aux_add_error(LASTERROR, "aux_cpy2_Certificate failed", CNULL, 0, proc);
		return( (Certificate * )0 );
	}

	return( dup_cert );
}


/***************************************************************
 *
 * Procedure aux_cpy2_Signature
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_Signature(
	Signature	 *dup_sig,
	Signature	 *sig
)

#else

int aux_cpy2_Signature(
	dup_sig,
	sig
)
Signature	 *dup_sig;
Signature	 *sig;

#endif

{
	char	* proc = "aux_cpy2_Signature";


	if ( (sig == (Signature * )0) || (dup_sig == (Signature * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_sig->signAI = aux_cpy_AlgId(sig->signAI);
	if (!dup_sig->signAI) {
		aux_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_BitString(&dup_sig->signature, &sig->signature)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_Signature
 *
 ***************************************************************/
#ifdef __STDC__

Signature *aux_cpy_Signature(
	Signature	 *sig
)

#else

Signature *aux_cpy_Signature(
	sig
)
Signature	 *sig;

#endif

{
	Signature  * dup_sig;
	char	   * proc = "aux_cpy_Signature";


	if ((sig == (Signature * )0))
		return( (Signature * )0);
	if ((dup_sig = (Signature * )malloc(sizeof(Signature))) == (Signature * )0 ) {
		aux_add_error(EMALLOC, "dup_sig", CNULL, 0, proc);
		return((Signature * )0);
	}
	if (aux_cpy2_Signature (dup_sig, sig)) {
		aux_add_error(LASTERROR, "aux_cpy2_Signature failed", CNULL, 0, proc);
		return( (Signature * )0 );
	}
	return(dup_sig);
}


/***************************************************************
 *
 * Procedure aux_cpy2_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_Certificate(
	Certificate	 *dup_cert,
	Certificate	 *cert
)

#else

int aux_cpy2_Certificate(
	dup_cert,
	cert
)
Certificate	 *dup_cert;
Certificate	 *cert;

#endif

{
	char	* proc = "aux_cpy2_Certificate";


	if ( (cert == (Certificate * )0) || (dup_cert == (Certificate * )0)  ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_cert->tbs_DERcode = aux_cpy_OctetString(cert->tbs_DERcode);
	dup_cert->tbs = aux_cpy_ToBeSigned(cert->tbs);
	dup_cert->sig = aux_cpy_Signature(cert->sig);

	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy2_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_OctetString(
	OctetString	 *dup_ostr,
	OctetString	 *ostr
)

#else

int aux_cpy2_OctetString(
	dup_ostr,
	ostr
)
OctetString	 *dup_ostr;
OctetString	 *ostr;

#endif

{
	int	  i;
	char	* proc = "aux_cpy2_OctetString";


	if ( (ostr == (OctetString * )0) || (dup_ostr == (OctetString * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_ostr->noctets = ostr->noctets;
	if(ostr->noctets) {
		if ( (dup_ostr->octets = (char *)malloc(dup_ostr->noctets)) == (char *)0 ) {
			aux_add_error(EMALLOC, "dup_ostr->octets", CNULL, 0, proc);
			return( -1 );
		}
		bcopy(ostr->octets, dup_ostr->octets, ostr->noctets);
	}
	else {
		if(ostr->octets) dup_ostr->octets = aux_cpy_String("");
		else dup_ostr->octets = CNULL;
	}


	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy2_BitString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_BitString(
	BitString	 *dup_bstr,
	BitString	 *bstr
)

#else

int aux_cpy2_BitString(
	dup_bstr,
	bstr
)
BitString	 *dup_bstr;
BitString	 *bstr;

#endif

{
	int	  i, nob;
	char	* proc = "aux_cpy2_BitString";


	if ( (bstr == (BitString * )0) || (dup_bstr == (BitString * )0) ) {
		aux_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_bstr->nbits = bstr->nbits;
	nob = dup_bstr->nbits / 8;
	if ( dup_bstr->nbits % 8 )
		nob++;
	if ( (dup_bstr->bits = (char *)malloc(nob)) == (char *)0 ) {
		aux_add_error(EMALLOC, "dup_bstr->bits", CNULL, 0, proc);
		return( 0 );
	}
	bcopy(bstr->bits, dup_bstr->bits, nob);
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_cpy_OctetString(
	OctetString	 *ostr
)

#else

OctetString *aux_cpy_OctetString(
	ostr
)
OctetString	 *ostr;

#endif

{
	OctetString * dup_ostr;
	char	    * proc = "aux_cpy_OctetString";


	if (!ostr)
		return (NULLOCTETSTRING);

	if ( !(dup_ostr = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "dup_ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	if (aux_cpy2_OctetString(dup_ostr, ostr)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	return(dup_ostr);
}


/***************************************************************
 *
 * Procedure aux_cpy_BitString
 *
 ***************************************************************/
#ifdef __STDC__

BitString *aux_cpy_BitString(
	BitString	 *bstr
)

#else

BitString *aux_cpy_BitString(
	bstr
)
BitString	 *bstr;

#endif

{
	BitString * dup_bstr;
	int	    nob, i;
	char	  * proc = "aux_cpy_BitString";


	if (!bstr)
		return (NULLBITSTRING);

	if ( !(dup_bstr = (BitString * )malloc(sizeof(BitString))) ) {
		aux_add_error(EMALLOC, "dup_bstr", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	if (aux_cpy2_BitString(dup_bstr, bstr)) {
		aux_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	return(dup_bstr);
}


/***************************************************************
 *
 * Procedure aux_cpy_PKList
 *
 ***************************************************************/
#ifdef __STDC__

PKList *aux_cpy_PKList(
	PKList	 *list
)

#else

PKList *aux_cpy_PKList(
	list
)
PKList	 *list;

#endif

{
	PKList  * dup_list;
	char	* proc = "aux_cpy_PKList";


	if (!list)
		return ( (PKList * ) 0);
	if ( !(dup_list = (PKList * )malloc(sizeof(PKList))) ) {
		aux_add_error(EMALLOC, "dup_list", CNULL, 0, proc);
		return ( (PKList * ) 0);
	}
	dup_list->element = aux_cpy_ToBeSigned(list->element);
	dup_list->next = aux_cpy_PKList(list->next);

	return(dup_list);
}


/***************************************************************
 *
 * Procedure aux_cpy_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

Certificates *aux_cpy_Certificates(
	Certificates	 *certs
)

#else

Certificates *aux_cpy_Certificates(
	certs
)
Certificates	 *certs;

#endif

{
	Certificates * dup_certs;
	char	     * proc = "aux_cpy_Certificates";


	if (!certs)
		return ( (Certificates * ) 0);

	if ( !(dup_certs = (Certificates * )malloc(sizeof(Certificates))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (Certificates * ) 0);
	}
	dup_certs->usercertificate = aux_cpy_Certificate(certs->usercertificate);
	dup_certs->forwardpath = aux_cpy_FCPath(certs->forwardpath);

	return (dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

CertificatePair *aux_cpy_CertificatePair(
	CertificatePair	 *certs
)

#else

CertificatePair *aux_cpy_CertificatePair(
	certs
)
CertificatePair	 *certs;

#endif

{
	CertificatePair * dup_certs;
	char	        * proc = "aux_cpy_CertificatePair";


	if (!certs)
		return ( (CertificatePair * ) 0);

	if ( !(dup_certs = (CertificatePair * )malloc(sizeof(CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (CertificatePair * ) 0);
	}
	dup_certs->forward = aux_cpy_Certificate(certs->forward);
	dup_certs->reverse = aux_cpy_Certificate(certs->reverse);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_Certificate *aux_cpy_SET_OF_Certificate(
	SET_OF_Certificate	 *certs
)

#else

SET_OF_Certificate *aux_cpy_SET_OF_Certificate(
	certs
)
SET_OF_Certificate	 *certs;

#endif

{
	SET_OF_Certificate * dup_certs;
	char		   * proc = "aux_cpy_SET_OF_Certificate";


	if (!certs)
		return ( (SET_OF_Certificate * ) 0);

	if ( !(dup_certs = (SET_OF_Certificate * )malloc(sizeof(SET_OF_Certificate))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_Certificate * ) 0);
	}
	dup_certs->element = aux_cpy_Certificate(certs->element);
	dup_certs->next = aux_cpy_SET_OF_Certificate(certs->next);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_Name *aux_cpy_SET_OF_Name(
	SET_OF_Name	 *nameset
)

#else

SET_OF_Name *aux_cpy_SET_OF_Name(
	nameset
)
SET_OF_Name	 *nameset;

#endif

{
	SET_OF_Name * dup_nameset;
	char	    * proc = "aux_cpy_SET_OF_Name";


	if (!nameset)
		return ( (SET_OF_Name * ) 0);

	if ( !(dup_nameset = (SET_OF_Name * )malloc(sizeof(SET_OF_Name))) ) {
		aux_add_error(EMALLOC, "dup_nameset", CNULL, 0, proc);
		return ( (SET_OF_Name * ) 0);
	}
	dup_nameset->element = aux_cpy_Name(nameset->element);
	dup_nameset->next = aux_cpy_SET_OF_Name(nameset->next);

	return(dup_nameset);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_CertificatePair *aux_cpy_SET_OF_CertificatePair(
	SET_OF_CertificatePair	 *certs
)

#else

SET_OF_CertificatePair *aux_cpy_SET_OF_CertificatePair(
	certs
)
SET_OF_CertificatePair	 *certs;

#endif

{
	SET_OF_CertificatePair * dup_certs;
	char		       * proc = "aux_cpy_SET_OF_CertificatePair";


	if (!certs)
		return ( (SET_OF_CertificatePair * ) 0);

	if ( !(dup_certs = (SET_OF_CertificatePair * )malloc(sizeof(SET_OF_CertificatePair))) ) {
		aux_add_error(EMALLOC, "dup_certs", CNULL, 0, proc);
		return ( (SET_OF_CertificatePair * ) 0);
	}
	dup_certs->element = aux_cpy_CertificatePair(certs->element);
	dup_certs->next = aux_cpy_SET_OF_CertificatePair(certs->next);

	return(dup_certs);
}


/***************************************************************
 *
 * Procedure aux_cpy_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

FCPath *aux_cpy_FCPath(
	FCPath	 *fcpath
)

#else

FCPath *aux_cpy_FCPath(
	fcpath
)
FCPath	 *fcpath;

#endif

{
	FCPath  * dup_fcpath;
	char	* proc = "aux_cpy_FCPath";


	if (!fcpath)
		return ( (FCPath * ) 0);

	if ( !(dup_fcpath = (FCPath * )malloc(sizeof(FCPath))) ) {
		aux_add_error(EMALLOC, "dup_fcpath", CNULL, 0, proc);
		return ( (FCPath * ) 0);
	}
	dup_fcpath->liste = aux_cpy_SET_OF_Certificate(fcpath->liste);
	dup_fcpath->next_forwardpath = aux_cpy_FCPath(fcpath->next_forwardpath);

	return(dup_fcpath);
}


/***************************************************************
 *
 * Procedure aux_cpy_RecpList
 *
 ***************************************************************/
#ifdef __STDC__

RecpList *aux_cpy_RecpList(
	RecpList	 *list
)

#else

RecpList *aux_cpy_RecpList(
	list
)
RecpList	 *list;

#endif

{
	RecpList * dup_list;
	char	 * proc = "aux_cpy_RecpList";


	if (!list)
		return ( (RecpList * ) 0);

	if ( !(dup_list = (RecpList * )malloc(sizeof(RecpList))) ) {
		aux_add_error(EMALLOC, "dup_list", CNULL, 0, proc);
		return ( (RecpList * ) 0);
	}
	dup_list->recpcert = aux_cpy_Certificate(list->recpcert);
	dup_list->key = aux_cpy_OctetString(list->key);
	dup_list->next = aux_cpy_RecpList(list->next);

	return(dup_list);
}


/***************************************************************
 *
 * Procedure aux_cpy_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

ToBeSigned *aux_cpy_ToBeSigned(
	ToBeSigned	 *tbs
)

#else

ToBeSigned *aux_cpy_ToBeSigned(
	tbs
)
ToBeSigned	 *tbs;

#endif

{
	ToBeSigned * dup_tbs;
	char	   * proc = "aux_cpy_ToBeSigned";


	if (!tbs)
		return ( (ToBeSigned * ) 0);

	if ( !(dup_tbs = (ToBeSigned * )malloc(sizeof(ToBeSigned))) ) {
		aux_add_error(EMALLOC, "dup_tbs", CNULL, 0, proc);
		return ( (ToBeSigned * ) 0);
	}
	dup_tbs->version = tbs->version;
	dup_tbs->serialnumber = aux_cpy_OctetString(tbs->serialnumber);
	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->valid = aux_cpy_Validity(tbs->valid);
	dup_tbs->subject = aux_cpy_DName(tbs->subject);
	dup_tbs->subjectPK = aux_cpy_KeyInfo(tbs->subjectPK);

#ifdef COSINE
	if (tbs->authatts) {
		if ( !(dup_tbs->authatts = (AuthorisationAttributes * )
					 malloc(sizeof(AuthorisationAttributes))) ) {
			aux_add_error(EMALLOC, "dup_tbs->authatts", CNULL, 0, proc);
			return ( (ToBeSigned * ) 0);
		}
		dup_tbs->authatts->country = aux_cpy_Name(tbs->authatts->country);
		dup_tbs->authatts->group = aux_cpy_Name(tbs->authatts->group);
		dup_tbs->authatts->class = tbs->authatts->class;
	}
	else
		dup_tbs->authatts = (AuthorisationAttributes * ) 0;
#endif

	return(dup_tbs);
}


/***************************************************************
 *
 * Procedure aux_cpy_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

KeyBits *aux_cpy_KeyBits(
	KeyBits	 *keybits
)

#else

KeyBits *aux_cpy_KeyBits(
	keybits
)
KeyBits	 *keybits;

#endif

{
	KeyBits * dup_keybits;
	char	* proc = "aux_cpy_KeyBits";


	if (!keybits)
		return ( (KeyBits * ) 0);

	if ( !(dup_keybits = (KeyBits * )malloc(sizeof(KeyBits))) ) {
		aux_add_error(EMALLOC, "dup_keybits", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part1, &keybits->part1)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part2, &keybits->part2)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part3, &keybits->part3)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part4, &keybits->part4)) {
		aux_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}

	return(dup_keybits);
}


/***************************************************************
 *
 * Procedure aux_cpy_Key
 *
 ***************************************************************/
#ifdef __STDC__

Key *aux_cpy_Key(
	Key	 *key
)

#else

Key *aux_cpy_Key(
	key
)
Key	 *key;

#endif

{
	Key     * dup_key;
	char	* proc = "aux_cpy_Key";


	if (!key)
		return ( (Key * ) 0);

	if ( !(dup_key = (Key * )malloc(sizeof(Key))) ) {
		aux_add_error(EMALLOC, "dup_key", CNULL, 0, proc);
		return ( (Key * ) 0);
	}
	dup_key->key = aux_cpy_KeyInfo(key->key);
	dup_key->keyref = key->keyref;
	dup_key->pse_sel = aux_cpy_PSESel(key->pse_sel);
	dup_key->alg = aux_cpy_AlgId(key->alg);

	return(dup_key);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

PSEToc *aux_cpy_PSEToc(
	PSEToc	 *pse
)

#else

PSEToc *aux_cpy_PSEToc(
	pse
)
PSEToc	 *pse;

#endif

{
	PSEToc  * dup_pse;
	char	* proc = "aux_cpy_PSEToc";


	if (!pse)
		return ( (PSEToc * ) 0);

	if ( !(dup_pse = (PSEToc * )malloc(sizeof(PSEToc))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEToc * ) 0);
	}
	dup_pse->owner = aux_cpy_Name(pse->owner);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->obj = aux_cpy_PSEObjects(pse->obj);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEObjects
 *
 ***************************************************************/
#ifdef __STDC__

struct PSE_Objects *aux_cpy_PSEObjects(
	struct PSE_Objects	 *pse
)

#else

struct PSE_Objects *aux_cpy_PSEObjects(
	pse
)
struct PSE_Objects	 *pse;

#endif

{
	struct PSE_Objects * dup_pse;
	char		   * proc = "aux_cpy_PSEObjects";


	if (!pse)
		return ( (struct PSE_Objects * ) 0);

	if ( !(dup_pse = (struct PSE_Objects *)malloc(sizeof(struct PSE_Objects ))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (struct PSE_Objects * ) 0);
	}
	dup_pse->name = aux_cpy_Name(pse->name);
	dup_pse->create = aux_cpy_Name(pse->create);
	dup_pse->update = aux_cpy_Name(pse->update);
	dup_pse->noOctets = pse->noOctets;
	dup_pse->status = pse->status;
	dup_pse->next = aux_cpy_PSEObjects(pse->next);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PSEObject
 *
 ***************************************************************/
#ifdef __STDC__

PSEObject *aux_cpy_PSEObject(
	PSEObject	 *pse
)

#else

PSEObject *aux_cpy_PSEObject(
	pse
)
PSEObject	 *pse;

#endif

{
	PSEObject * dup_pse;
	char	  * proc = "aux_cpy_PSEObject";


	if (!pse)
		return ( (PSEObject * ) 0);

	if ( !(dup_pse = (PSEObject * )malloc(sizeof(PSEObject))) ) {
		aux_add_error(EMALLOC, "dup_pse", CNULL, 0, proc);
		return ( (PSEObject * ) 0);
	}
	dup_pse->objectType = aux_cpy_ObjId(pse->objectType);
	dup_pse->objectValue = aux_cpy_OctetString(pse->objectValue);

	return(dup_pse);
}


/***************************************************************
 *
 * Procedure aux_cpy_PemInfo
 *
 ***************************************************************/
#ifdef __STDC__

PemInfo *aux_cpy_PemInfo(
	PemInfo	 *peminfo
)

#else

PemInfo *aux_cpy_PemInfo(
	peminfo
)
PemInfo	 *peminfo;

#endif

{
	PemInfo * dup_peminfo;
	char	* proc = "aux_cpy_PemInfo";


	if (!peminfo)
		return ( (PemInfo * ) 0);

	if ( !(dup_peminfo = (PemInfo * )malloc(sizeof(PemInfo))) ) {
		aux_add_error(EMALLOC, "dup_peminfo", CNULL, 0, proc);
		return ( (PemInfo * ) 0);
	}
	dup_peminfo->confidential = peminfo->confidential;
	dup_peminfo->clear = peminfo->clear;
	dup_peminfo->encryptKEY = aux_cpy_Key(peminfo->encryptKEY);
	dup_peminfo->origcert = aux_cpy_Certificates(peminfo->origcert);
	dup_peminfo->signAI = aux_cpy_AlgId(peminfo->signAI);
	dup_peminfo->recplist = aux_cpy_RecpList(peminfo->recplist);

	return(dup_peminfo);
}


/***************************************************************
 *
 * Procedure aux_cpy_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

PKRoot *aux_cpy_PKRoot(
	PKRoot	 *pkr
)

#else

PKRoot *aux_cpy_PKRoot(
	pkr
)
PKRoot	 *pkr;

#endif

{
	PKRoot  * dup_pkr;
	char	* proc = "aux_cpy_PKRoot";


	if (!pkr)
		return ( (PKRoot * ) 0);

	if ( !(dup_pkr = (PKRoot * )malloc(sizeof(PKRoot))) ) {
		aux_add_error(EMALLOC, "dup_pkr", CNULL, 0, proc);
		return ( (PKRoot * ) 0);
	}
	dup_pkr->ca = aux_cpy_DName(pkr->ca);
	dup_pkr->newkey = aux_cpy_Serial(pkr->newkey);
	dup_pkr->oldkey = aux_cpy_Serial(pkr->oldkey);

	return(dup_pkr);
}


/***************************************************************
 *
 * Procedure aux_cpy_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

IssuedCertificate *aux_cpy_IssuedCertificate(
	IssuedCertificate	 *isscert
)

#else

IssuedCertificate *aux_cpy_IssuedCertificate(
	isscert
)
IssuedCertificate	 *isscert;

#endif

{
	IssuedCertificate * dup_isscert;
	char	          * proc = "aux_cpy_IssuedCertificate";


	if ( (isscert == (IssuedCertificate * )0) )
		return ( (IssuedCertificate * )0 );
	if ( (dup_isscert = (IssuedCertificate * )malloc(sizeof(IssuedCertificate))) == (IssuedCertificate * )0 ) {
		aux_add_error(EMALLOC, "dup_isscert", CNULL, 0, proc);
		return ( (IssuedCertificate * )0 );
	}

	dup_isscert->serial = aux_cpy_OctetString(isscert->serial);
	dup_isscert->date_of_issue = aux_cpy_Name(isscert->date_of_issue);

	return( dup_isscert );
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_IssuedCertificate *aux_cpy_SET_OF_IssuedCertificate(
	SET_OF_IssuedCertificate	 *isscertset
)

#else

SET_OF_IssuedCertificate *aux_cpy_SET_OF_IssuedCertificate(
	isscertset
)
SET_OF_IssuedCertificate	 *isscertset;

#endif

{
	SET_OF_IssuedCertificate * dup_isscertset;
	char			 * proc = "aux_cpy_SET_OF_IssuedCertificate";


	if (!isscertset)
		return ( (SET_OF_IssuedCertificate * ) 0);

	if ( !(dup_isscertset = (SET_OF_IssuedCertificate * )malloc(sizeof(SET_OF_IssuedCertificate))) ) {
		aux_add_error(EMALLOC, "dup_isscertset", CNULL, 0, proc);
		return  ( (SET_OF_IssuedCertificate * ) 0);
	}
	dup_isscertset->element = aux_cpy_IssuedCertificate(isscertset->element);
	dup_isscertset->next = aux_cpy_SET_OF_IssuedCertificate(isscertset->next);

	return(dup_isscertset);
}


/***************************************************************
 *
 * Procedure aux_cpy_Crl
 *
 ***************************************************************/
#ifdef __STDC__

Crl *aux_cpy_Crl(
	Crl	 *crlpse
)

#else

Crl *aux_cpy_Crl(
	crlpse
)
Crl	 *crlpse;

#endif

{
	Crl * dup_crlpse;
	char   * proc = "aux_cpy_Crl";


	if ( (crlpse == (Crl * )0) )
		return ( (Crl * )0 );
	if ( (dup_crlpse = (Crl * )malloc(sizeof(Crl))) == (Crl * )0 ) {
		aux_add_error(EMALLOC, "dup_crlpse", CNULL, 0, proc);
		return ( (Crl * )0 );
	}

	dup_crlpse->issuer = aux_cpy_DName(crlpse->issuer);
	dup_crlpse->nextUpdate = aux_cpy_Name(crlpse->nextUpdate);
	dup_crlpse->revcerts = aux_cpy_SEQUENCE_OF_CRLEntry(crlpse->revcerts);

	return ( dup_crlpse );
}


/***************************************************************
 *
 * Procedure aux_cpy_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

CrlSet *aux_cpy_CrlSet(
	CrlSet	 *crlset
)

#else

CrlSet *aux_cpy_CrlSet(
	crlset
)
CrlSet	 *crlset;

#endif

{
	CrlSet * dup_crlset;
	char	   * proc = "aux_cpy_CrlSet";


	if (!crlset)
		return ( (CrlSet * ) 0);

	if ( !(dup_crlset = (CrlSet * )malloc(sizeof(CrlSet))) ) {
		aux_add_error(EMALLOC, "dup_crlset", CNULL, 0, proc);
		return ( (CrlSet * ) 0);
	}
	dup_crlset->element = aux_cpy_Crl(crlset->element);
	dup_crlset->next = aux_cpy_CrlSet(crlset->next);

	return(dup_crlset);
}


/***************************************************************
 *
 * Procedure aux_cpy_Serial
 *
 ***************************************************************/
#ifdef __STDC__

struct Serial *aux_cpy_Serial(
	struct Serial	 *serial
)

#else

struct Serial *aux_cpy_Serial(
	serial
)
struct Serial	 *serial;

#endif

{
	struct Serial   * dup_serial;
	char		* proc = "aux_cpy_Serial";


	if (!serial)
		return ( (struct Serial * ) 0);

	if ( !(dup_serial = (struct Serial *)malloc(sizeof(struct Serial ))) ) {
		aux_add_error(EMALLOC, "dup_serial", CNULL, 0, proc);
		return ( (struct Serial * ) 0);
	}

	dup_serial->serial = aux_cpy_OctetString(serial->serial);
	dup_serial->key = aux_cpy_KeyInfo(serial->key);
	dup_serial->valid = aux_cpy_Validity(serial->valid);
	dup_serial->sig = aux_cpy_Signature(serial->sig);

	return (dup_serial);
} 


/***************************************************************
 *
 * Procedure aux_cpy_Aliases
 *
 ***************************************************************/
#ifdef __STDC__

Aliases *aux_cpy_Aliases(
	Aliases	 *aliases
)

#else

Aliases *aux_cpy_Aliases(
	aliases
)
Aliases	 *aliases;

#endif

{
	Aliases   * dup_aliases;
	char	  * proc = "aux_cpy_Aliases";


	if (! aliases)
		return ( (Aliases * )0 );

	if ( !(dup_aliases = (Aliases * )malloc(sizeof(Aliases))) ) {
		aux_add_error(EMALLOC, "dup_aliases", CNULL, 0, proc);
		return ( (Aliases * )0 );
	}

	dup_aliases->aname = aux_cpy_String(aliases->aname);
	dup_aliases->aliasfile = aliases->aliasfile;
	dup_aliases->next = aux_cpy_Aliases(aliases->next);

	return (dup_aliases);
}


/***************************************************************
 *
 * Procedure aux_cpy_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

AliasList *aux_cpy_AliasList(
	AliasList	 *aliaslist
)

#else

AliasList *aux_cpy_AliasList(
	aliaslist
)
AliasList	 *aliaslist;

#endif

{
	AliasList   * dup_aliaslist;
	char	    * proc = "aux_cpy_AliasList";


	if (! aliaslist)
		return ( (AliasList * )0 );

	if ( !(dup_aliaslist = (AliasList * )malloc(sizeof(AliasList))) ) {
		aux_add_error(EMALLOC, "dup_aliaslist", CNULL, 0, proc);
		return ( (AliasList * )0 );
	}

	dup_aliaslist->a = aux_cpy_Aliases(aliaslist->a);
	dup_aliaslist->dname = aux_cpy_Name(aliaslist->dname);
	dup_aliaslist->next = aux_cpy_AliasList(aliaslist->next);

	return (dup_aliaslist);
}


/***************************************************************
 *
 * Procedure aux_determine_Signer
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_determine_Signer(
	VerificationResult	 * verres,
	Boolean			 * authentication
)

#else

Name *aux_determine_Signer(
	verres,
	authentication
)
VerificationResult    * verres;
Boolean		      * authentication;

#endif

{
	Name            * signer;
	Boolean   	  dn_subordination_violation = FALSE;
	int       	  crlcheck = 0, index;

	char		* proc = "aux_determine_Signer";


	if (! verres || ! authentication) {
		aux_add_error(EINVALID, "Parameters not present", CNULL, 0, proc);
		return(CNULL);
	}

	if (verres->verifstep) {
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->dn_subordination_violation == TRUE){
				dn_subordination_violation = TRUE;
				break;
			}
			index++;
		}
		index = 0;
		while(verres->verifstep[index]){
			if(verres->verifstep[index]->crlcheck == CRL_NOT_AVAILABLE){
				crlcheck == CRL_NOT_AVAILABLE;
				break;
			}
			index++;
		} /* while */
	} /* if */

	if(! verres->verifstep || ! verres->verifstep[0])
		signer = aux_cpy_Name(verres->top_name);
	else
		signer = aux_DName2Name(verres->verifstep[0]->cert->tbs->subject);
	if(! signer){
		AUX_ADD_ERROR;
		return(CNULL);
	}

	if (verres->success == TRUE && dn_subordination_violation == FALSE && crlcheck == 0)
		* authentication = TRUE;
	else
		* authentication = FALSE;


	return(signer);
}



/* #include "iso3166.h" */
#ifndef MAC
#include <ctype.h>
#endif /* MAC */

/***************************************************************
 *
 * Procedure aux_check_3166
 *
 ***************************************************************/
#ifdef __STDC__

int aux_check_3166(
	char	 *a
)

#else

int aux_check_3166(
	a
)
char	 *a;

#endif

{
	int	bitno;

	if (strlen (a) != 2)
		return 0;

	if (islower ((u_char) a[0]))
		a[0] = toupper (a[0]);
	if (islower ((u_char) a[1]))
		a[1] = toupper (a[1]);

	/*return (isupper ((u_char) a[0]) && isupper((u_char) a[1]) && is3166 (a));*/
	return (isupper ((u_char) a[0]) && isupper((u_char) a[1]));
}


/***************************************************************
 *
 * Procedure aux_check_print_string
 *
 ***************************************************************/
#ifdef __STDC__

int aux_check_print_string(
	register char	 *str
)

#else

int aux_check_print_string(
	str
)
register char	 *str;

#endif

{

	for (; *str != 0; str++) {
		if ((isascii((*str) & 0xff)) && (isalnum ((*str) & 0xff)))
			continue;      /*isascii() and isalnum() from /usr/include/ctype.h */

		switch (*str) {
		case 047:  /* ' */
		case '(':
		case ')':
		case '+':
		case '-':
		case '.':
		case ',':
		case '/':
		case ':':
		case '=':
		case '?':
		case ' ':
			continue;
		default:
			return (0);
		}
	}
	return (1);
}


/****************************************************************************/

extern int	errno;
/***************************************************************
 *
 * Procedure aux_create_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

Certificates *aux_create_Certificates(
	Certificate	 *cert,
	FCPath		 *fcpath
)

#else

Certificates *aux_create_Certificates(
	cert,
	fcpath
)
Certificate	 *cert;
FCPath		 *fcpath;

#endif

{
	Certificates * certs;
	char	     * proc = "aux_create_Certificates";


	if (!cert) {
		aux_add_error(EINVALID, "cert empty", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs = (Certificates * )calloc(1, sizeof(Certificates))))  {
		aux_add_error(EMALLOC, "certs", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if (!(certs->usercertificate = aux_cpy_Certificate(cert))) {
		aux_add_error(LASTERROR, "aux_cpy_Certificate failed", CNULL, 0, proc);
		return ( (Certificates * )0);
	}

	if(fcpath) {
                if (!(certs->forwardpath = aux_cpy_FCPath(fcpath))) {
        		aux_add_error(LASTERROR, "aux_cpy_FCPath failed", CNULL, 0, proc);
        		return ( (Certificates * )0);
        	}
        }

	return(certs);

}


/***************************************************************
 *
 * Procedure aux_create_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

FCPath *aux_create_FCPath(
	Certificate	 *cert
)

#else

FCPath *aux_create_FCPath(
	cert
)
Certificate	 *cert;

#endif

{
	FCPath       * fcpath;
	char	     * proc = "aux_create_FCPath";


	if (! cert) {
		aux_add_error(EINVALID, "cert empty", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	if (!(fcpath = (FCPath * )calloc(1, sizeof(FCPath))))  {
		aux_add_error(EMALLOC, "fcpath", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	if (!(fcpath->liste = (SET_OF_Certificate * )calloc(1, sizeof(SET_OF_Certificate))))  {
		aux_add_error(EMALLOC, "fcpath->liste", CNULL, 0, proc);
		return ( (FCPath * )0);
	}
	
	if (!(fcpath->liste->element = aux_cpy_Certificate(cert))) {
		aux_add_error(LASTERROR, "aux_cpy_Certificate failed", CNULL, 0, proc);
		return ( (FCPath * )0);
	}

	fcpath->liste->next = (SET_OF_Certificate *) 0;
	fcpath->next_forwardpath = (FCPath *) 0;

	return(fcpath);

}


/****************************************************************************/

extern int	errno;
/***************************************************************
 *
 * Procedure aux_create_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

PKRoot *aux_create_PKRoot(
	Certificate	 *cert1,
	Certificate	 *cert2
)

#else

PKRoot *aux_create_PKRoot(
	cert1,
	cert2
)
Certificate	 *cert1;
Certificate	 *cert2;

#endif

{
	PKRoot * pkroot;
	struct Serial *newkey, *oldkey;
	char	     * proc = "aux_create_PKRoot";


	if (!cert1) {
		aux_add_error(EINVALID, "cert1 empty", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot = (PKRoot * )calloc(1, sizeof(PKRoot))))  {
		aux_add_error(EMALLOC, "pkroot", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(pkroot->ca = aux_cpy_DName(cert1->tbs->subject))) {
		aux_add_error(LASTERROR, "aux_cpy_DName failed", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}

	if (!(newkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
		aux_add_error(EMALLOC, "newkey", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	pkroot->newkey = newkey;
	newkey->serial = aux_cpy_OctetString(cert1->tbs->serialnumber);
	newkey->version = cert1->tbs->version;
	if(!(newkey->key = aux_cpy_KeyInfo(cert1->tbs->subjectPK))) {
		aux_add_error(EMALLOC, "newkey->key", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->valid = aux_cpy_Validity(cert1->tbs->valid))) {
		aux_add_error(EMALLOC, "newkey->valid", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(!(newkey->sig = aux_cpy_Signature(cert1->sig))) {
		aux_add_error(EMALLOC, "newkey->sig", CNULL, 0, proc);
		return ( (PKRoot * )0);
	}
	if(cert2) {
		if (!(oldkey = (struct Serial * )malloc(sizeof(struct Serial))))  {
			aux_add_error(EMALLOC, "oldkey", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		pkroot->oldkey = oldkey;
		oldkey->serial = aux_cpy_OctetString(cert2->tbs->serialnumber);
		oldkey->version = cert2->tbs->version;
		if(!(oldkey->key = aux_cpy_KeyInfo(cert2->tbs->subjectPK))) {
			aux_add_error(EMALLOC, "oldkey->key", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->valid = aux_cpy_Validity(cert2->tbs->valid))) {
			aux_add_error(EMALLOC, "oldkey->valid", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
		if(!(oldkey->sig = aux_cpy_Signature(cert2->sig))) {
			aux_add_error(EMALLOC, "oldkey->sig", CNULL, 0, proc);
			return ( (PKRoot * )0);
		}
	}
		

	return(pkroot);

}

/****************************************************************************/

extern int	errno;
/***************************************************************
 *
 * Procedure aux_create_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

Certificate *aux_create_Certificate(
	ToBeSigned	 *tbs
)

#else

Certificate *aux_create_Certificate(
	tbs
)
ToBeSigned	 *tbs;

#endif

{
	Certificate * cert;
	char	    * proc = "aux_create_Certificate";


	if (!tbs) {
		aux_add_error(EINVALID, "tbs empty", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	if (!(cert = (Certificate * )malloc(sizeof(Certificate))))  {
		aux_add_error(EMALLOC, "cert", CNULL, 0, proc);
		return ( (Certificate * )0);
	}

	cert->tbs = aux_cpy_ToBeSigned(tbs);

	cert->sig = (Signature *)0;
	cert->tbs_DERcode = (OctetString *)0;

	return(cert);

}


/****************************************************************************/


/***************************************************************
 *
 * Procedure aux_cmp_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_Certificate(
	Certificate	 *a,
	Certificate	 *b
)

#else

int aux_cmp_Certificate(
	a,
	b
)
Certificate	 *a;
Certificate	 *b;

#endif

{
	int	rc;

	if ( !a && !b )
		return( 0) ;
	if ( !a || !b )
		return( 1) ;


	if (a->tbs->version != b->tbs->version) return(1);
	if (aux_cmp_OctetString(a->tbs->serialnumber, b->tbs->serialnumber))
		return(1);

	if (aux_cmp_DName(a->tbs->issuer, b->tbs->issuer)) return(1);
	if (aux_cmp_DName(a->tbs->subject, b->tbs->subject)) return(1);
	if (aux_cmp_KeyInfo(a->tbs->subjectPK, b->tbs->subjectPK)) return(1);
	if (aux_cmp_Signature(a->sig, b->sig)) return(1);
	return(0);
}



/****************************************************************************/

/***************************************************************
 *
 * Procedure aux_cmp_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_CertificatePair(
	CertificatePair	 *a,
	CertificatePair	 *b
)

#else

int aux_cmp_CertificatePair(
	a,
	b
)
CertificatePair	 *a;
CertificatePair	 *b;

#endif

{
	int	rc;

	if ( !a && !b )
		return( 0) ;
	if ( !a || !b )
		return( 1) ;

	if (a->forward == (Certificate * ) 0) {
		if (b->forward == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->forward == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->forward, b->forward);
	}

	if (rc != 0)
		return (rc);

	if (a->reverse == (Certificate * ) 0) {
		if (b->reverse == (Certificate * ) 0)
			rc = 0;
		else
			rc = 1;
	} else {
		if (b->reverse == (Certificate * ) 0)
			rc = 1;
		else
			rc = aux_cmp_Certificate(a->reverse, b->reverse);
	}

	return (rc);
}



/*******************************************************************************
 *
 *      aux-routines for certificate revocation according to PEM
 *
 *******************************************************************************/

/***************************************************************
 *
 * Procedure aux_cpy_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

CRLEntry *aux_cpy_CRLEntry(
	CRLEntry	 *crlentry
)

#else

CRLEntry *aux_cpy_CRLEntry(
	crlentry
)
CRLEntry	 *crlentry;

#endif

{
	CRLEntry * dup_crlentry;
	char	   * proc = "aux_cpy_CRLEntry";


	if ( crlentry == (CRLEntry * )0 )
		return ( (CRLEntry * )0 );

	if ( !(dup_crlentry = (CRLEntry * )malloc(sizeof(CRLEntry))) ) {
		aux_add_error(EMALLOC, "dup_crlentry", CNULL, 0, proc);
		return ( (CRLEntry * )0 );
	}

	dup_crlentry->serialnumber = aux_cpy_OctetString(crlentry->serialnumber);
	dup_crlentry->revocationDate = aux_cpy_Name( crlentry->revocationDate);

	return (dup_crlentry);
}


/***************************************************************
 *
 * Procedure aux_cpy_SEQUENCE_OF_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

SEQUENCE_OF_CRLEntry *aux_cpy_SEQUENCE_OF_CRLEntry(
	SEQUENCE_OF_CRLEntry	 *seq
)

#else

SEQUENCE_OF_CRLEntry *aux_cpy_SEQUENCE_OF_CRLEntry(
	seq
)
SEQUENCE_OF_CRLEntry	 *seq;

#endif

{
	SEQUENCE_OF_CRLEntry * dup_seq;
	char		       * proc = "aux_cpy_SEQUENCE_OF_CRLEntry";


	if ( (seq == (SEQUENCE_OF_CRLEntry * )0) )
		return ( (SEQUENCE_OF_CRLEntry * )0 );

	if ( !(dup_seq = (SEQUENCE_OF_CRLEntry * )malloc(sizeof(SEQUENCE_OF_CRLEntry))) ) {
		aux_add_error(EMALLOC, "dup_seq", CNULL, 0, proc);
		return ( (SEQUENCE_OF_CRLEntry * )0 );
	}
	/*copy first revoked certificate within the sequence:*/
	dup_seq->element = aux_cpy_CRLEntry(seq->element);
	dup_seq->next = aux_cpy_SEQUENCE_OF_CRLEntry(seq->next);

	return (dup_seq);
}


/***************************************************************
 *
 * Procedure aux_cpy_CRL
 *
 ***************************************************************/
#ifdef __STDC__

CRL *aux_cpy_CRL(
	CRL	 *crl
)

#else

CRL *aux_cpy_CRL(
	crl
)
CRL	 *crl;

#endif

{
	int	     i, nob, lim;
	CRL * dup_crl;
	char	   * proc = "aux_cpy_CRL";


	if ( crl == (CRL * )0 )
		return ( (CRL * )0 );

	if ( !(dup_crl = (CRL * )malloc(sizeof(CRL))) ) {
		aux_add_error(EMALLOC, "dup_crl", CNULL, 0, proc);
		return ( (CRL * )0 );
	}

	/*  Folgende Abfrage ist UNBEDINGT NOTWENDIG, da innerhalb von  ds_modifyentry()  
	 *  die Funktion entry_cpy()  aufgerufen wird, die die einzelnen Attribute 
	 *  innerhalb des betreffenden Eintrages kopiert (und nicht nur das zu modifizierende 
	 *  Attribut!):    
	 *		entryptr = entry_cpy (real_entry);
	 */

	dup_crl->tbs_DERcode = aux_cpy_OctetString(crl->tbs_DERcode);
	dup_crl->tbs = aux_cpy_CRLTBS(crl->tbs);
	dup_crl->sig = aux_cpy_Signature(crl->sig);

	return (dup_crl);
}


/***************************************************************
 *
 * Procedure aux_cpy_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

CRLTBS *aux_cpy_CRLTBS(
	CRLTBS	 *tbs
)

#else

CRLTBS *aux_cpy_CRLTBS(
	tbs
)
CRLTBS	 *tbs;

#endif

{
	CRLTBS   * dup_tbs;
	char		* proc = "aux_cpy_CRLTBS";


	if ( tbs == (CRLTBS * )0 )
		return ( (CRLTBS * )0 );

	if ( !(dup_tbs = (CRLTBS * )malloc(sizeof(CRLTBS))) ) {
		aux_add_error(EMALLOC, "dup_tbs ", CNULL, 0, proc);
		return ( (CRLTBS * )0 );
	}

	dup_tbs->signatureAI = aux_cpy_AlgId(tbs->signatureAI);
	dup_tbs->issuer = aux_cpy_DName(tbs->issuer);
	dup_tbs->revokedCertificates = aux_cpy_SEQUENCE_OF_CRLEntry(tbs->revokedCertificates);
	dup_tbs->lastUpdate = aux_cpy_Name(tbs->lastUpdate);
	dup_tbs->nextUpdate = aux_cpy_Name(tbs->nextUpdate);

	return (dup_tbs);
}


/***************************************************************
 *
 * Procedure aux_cpy_OCList
 *
 ***************************************************************/
#ifdef __STDC__

OCList *aux_cpy_OCList(
	OCList	 *ocl
)

#else

OCList *aux_cpy_OCList(
	ocl
)
OCList	 *ocl;

#endif

{
	OCList  * dup_ocl;
	char	* proc = "aux_cpy_OCList";


	if ( ocl == (OCList * )0 )
		return ( (OCList * )0 );

	if ( !(dup_ocl = (OCList * )malloc(sizeof(OCList))) ) {
		aux_add_error(EMALLOC, "dup_ocl ", CNULL, 0, proc);
		return ( (OCList * )0 );
	}

	dup_ocl->serialnumber = aux_cpy_OctetString(ocl->serialnumber);
	dup_ocl->ccert = aux_cpy_Certificate(ocl->ccert);
	dup_ocl->next = aux_cpy_OCList(ocl->next);

	return (dup_ocl);
}


/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemMessageLocal *aux_cpy_SET_OF_PemMessageLocal(
	SET_OF_PemMessageLocal	 *old
)

#else

SET_OF_PemMessageLocal *aux_cpy_SET_OF_PemMessageLocal(
	old
)
SET_OF_PemMessageLocal	 *old;

#endif

{
	SET_OF_PemMessageLocal *new = (SET_OF_PemMessageLocal *)0, *new2;

	while(old) {
		if(new) {
			NEWSTRUCT(new2->next, SET_OF_PemMessageLocal, (SET_OF_PemMessageLocal *) 0, 
										aux_free_SET_OF_PemMessageLocal(&new))
			new2 = new2->next;
		}
		else {
			NEWSTRUCT(new2, SET_OF_PemMessageLocal, (SET_OF_PemMessageLocal *) 0, 
										aux_free_SET_OF_PemMessageLocal(&new))
			new = new2;
		}
		new2->next = (SET_OF_PemMessageLocal *)0;
		new2->element = aux_cpy_PemMessageLocal(old->element);
		if(old->element && !new2->element) AUX_ERROR_RETURN((SET_OF_PemMessageLocal *) 0, 
										aux_free_SET_OF_PemMessageLocal(&new))
		old = old->next;
	}

	return(new);
}

/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_DName
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_DName *aux_cpy_SET_OF_DName(
	SET_OF_DName	 *old
)

#else

SET_OF_DName *aux_cpy_SET_OF_DName(
	old
)
SET_OF_DName	 *old;

#endif

{
	SET_OF_DName *new = (SET_OF_DName *)0, *new2;

	while(old) {
		if(new) {
			NEWSTRUCT(new2->next, SET_OF_DName, (SET_OF_DName *) 0, 
										aux_free_SET_OF_DName(&new))
			new2 = new2->next;
		}
		else {
			NEWSTRUCT(new2, SET_OF_DName, (SET_OF_DName *) 0, 
										aux_free_SET_OF_DName(&new))
			new = new2;
		}
		new2->next = (SET_OF_DName *)0;
		new2->element = aux_cpy_DName(old->element);
		if(old->element && !new2->element) AUX_ERROR_RETURN((SET_OF_DName *) 0, 
										aux_free_SET_OF_DName(&new))
		old = old->next;
	}

	return(new);
}

/***************************************************************
 *
 * Procedure aux_cpy_VerificationStep
 *
 ***************************************************************/
#ifdef __STDC__

VerificationStep *aux_cpy_VerificationStep(
	VerificationStep	 *old
)

#else

VerificationStep *aux_cpy_VerificationStep(
	old
)
VerificationStep	 *old;

#endif

{
	VerificationStep *new = (VerificationStep *)0;

	if(old) {
		NEWSTRUCT(new, VerificationStep, (VerificationStep *) 0, aux_free_VerificationStep(&new))



		new->crlcheck = old->crlcheck;
		new->supplied = old->supplied;
		new->policy_CA = old->policy_CA;
		new->dn_subordination_violation = old->dn_subordination_violation;


		new->cert = aux_cpy_Certificate(old->cert);

		if(old->cert && !new->cert) AUX_ERROR_RETURN((VerificationStep *) 0, 
										aux_free_VerificationStep(&new))

		new->date = aux_cpy_String(old->date);

		if(old->date && !new->date) AUX_ERROR_RETURN((VerificationStep *) 0, 
										aux_free_VerificationStep(&new))

		new->valid = aux_cpy_Validity(old->valid);

		if(old->valid && !new->valid) AUX_ERROR_RETURN((VerificationStep *) 0, 
										aux_free_VerificationStep(&new))

	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

VerificationResult *aux_cpy_VerificationResult(
	VerificationResult	 *old
)

#else

VerificationResult *aux_cpy_VerificationResult(
	old
)
VerificationResult	 *old;

#endif

{
	VerificationResult *new = (VerificationResult *)0;
	int		    n;

	if(old) {
		NEWSTRUCT(new, VerificationResult, (VerificationResult *) 0, aux_free_VerificationResult(&new))


		if(old->verifstep) {
			for(n = 0; old->verifstep[n]; n++) ;

			new->verifstep = (VerificationStep **)calloc(n+1, sizeof(VerificationStep * ));
			for( ; n >= 0; n--) {
				new->verifstep[n] = aux_cpy_VerificationStep(old->verifstep[n]);

				if(old->verifstep[n] && !new->verifstep[n]) AUX_ERROR_RETURN((VerificationResult *) 0, 
										aux_free_VerificationResult(&new))
			}
		}
		else new->verifstep = (VerificationStep **)0;

		new->trustedKey = old->trustedKey;
		new->success = old->success;
		new->textverified = old->textverified;


		new->top_name = aux_cpy_Name(old->top_name);

		if(old->top_name && !new->top_name) AUX_ERROR_RETURN((VerificationResult *) 0, 
										aux_free_VerificationResult(&new))

		new->valid = aux_cpy_Validity(old->valid);

		if(old->valid && !new->valid) AUX_ERROR_RETURN((VerificationResult *) 0, 
										aux_free_VerificationResult(&new))

		new->top_serial = aux_cpy_OctetString(old->top_serial);

		if(old->top_serial && !new->top_serial) AUX_ERROR_RETURN((VerificationResult *) 0, 
										aux_free_VerificationResult(&new))
	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemMessageLocal *aux_cpy_PemMessageLocal(
	PemMessageLocal	 *old
)

#else

PemMessageLocal *aux_cpy_PemMessageLocal(
	old
)
PemMessageLocal	 *old;

#endif

{
	PemMessageLocal *new = (PemMessageLocal *)0;

	if(old) {
		NEWSTRUCT(new, PemMessageLocal, (PemMessageLocal *) 0, aux_free_PemMessageLocal(&new))

		new->header = aux_cpy_PemHeaderLocal(old->header);

		if(old->header && !new->header) AUX_ERROR_RETURN((PemMessageLocal *) 0, 
										aux_free_PemMessageLocal(&new))

		new->body = aux_cpy_OctetString(old->body);

		if(old->body && !new->body) AUX_ERROR_RETURN((PemMessageLocal *) 0, 
										aux_free_PemMessageLocal(&new))

		new->error = aux_cpy_String(old->error);

		if(old->error && !new->error) AUX_ERROR_RETURN((PemMessageLocal *) 0, 
										aux_free_PemMessageLocal(&new))

		new->comment = aux_cpy_String(old->comment);

		if(old->comment && !new->comment) AUX_ERROR_RETURN((PemMessageLocal *) 0, 
										aux_free_PemMessageLocal(&new))

		new->validation_result = aux_cpy_VerificationResult(old->validation_result);

		if(old->validation_result && !new->validation_result) AUX_ERROR_RETURN((PemMessageLocal *) 0, 
										aux_free_PemMessageLocal(&new))
	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemHeaderLocal *aux_cpy_PemHeaderLocal(
	PemHeaderLocal	 *old
)

#else

PemHeaderLocal *aux_cpy_PemHeaderLocal(
	old
)
PemHeaderLocal	 *old;

#endif

{
	PemHeaderLocal *new = (PemHeaderLocal *)0;

	if(old) {
		NEWSTRUCT(new, PemHeaderLocal, (PemHeaderLocal *) 0, aux_free_PemHeaderLocal(&new))

		new->rfc_version = old->rfc_version;
		new->proctype = old->proctype;
		new->content_domain = old->content_domain;

		new->dek_fields = aux_cpy_PemDekLocal(old->dek_fields);

		if(old->dek_fields && !new->dek_fields) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

		new->certificates = aux_cpy_Certificates(old->certificates);

		if(old->certificates && !new->certificates) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

		new->root_certificate = aux_cpy_Certificate(old->root_certificate);

		if(old->root_certificate && !new->root_certificate) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

		new->mic_fields = aux_cpy_PemMicLocal(old->mic_fields);

		if(old->mic_fields && !new->mic_fields) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

		new->crl_fields = aux_cpy_SET_OF_CRLWithCertificates(old->crl_fields);

		if(old->crl_fields && !new->crl_fields) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

		new->crl_rr_fields = aux_cpy_SET_OF_DName(old->crl_rr_fields);

		if(old->crl_rr_fields && !new->crl_rr_fields) AUX_ERROR_RETURN((PemHeaderLocal *) 0, 
										aux_free_PemHeaderLocal(&new))

	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemDekLocal *aux_cpy_PemDekLocal(
	PemDekLocal	 *old
)

#else

PemDekLocal *aux_cpy_PemDekLocal(
	old
)
PemDekLocal	 *old;

#endif

{
	PemDekLocal *new = (PemDekLocal *)0;

	if(old) {
		NEWSTRUCT(new, PemDekLocal, (PemDekLocal *) 0, ;)

		new->dekinfo_enc_alg = aux_cpy_AlgId(old->dekinfo_enc_alg);

		if(old->dekinfo_enc_alg && !new->dekinfo_enc_alg) AUX_ERROR_RETURN((PemDekLocal *) 0, 
										aux_free_PemDekLocal(&new))

		new->keyinfo_enc_alg = aux_cpy_AlgId(old->keyinfo_enc_alg);

		if(old->keyinfo_enc_alg && !new->keyinfo_enc_alg) AUX_ERROR_RETURN((PemDekLocal *) 0, 
										aux_free_PemDekLocal(&new))

		new->keyinfo_dek = aux_cpy_BitString(old->keyinfo_dek);

		if(old->keyinfo_dek && !new->keyinfo_dek) AUX_ERROR_RETURN((PemDekLocal *) 0, 
										aux_free_PemDekLocal(&new))

		new->recipients = aux_cpy_SET_OF_PemRecLocal(old->recipients);

		if(old->recipients && !new->recipients) AUX_ERROR_RETURN((PemDekLocal *) 0, 
										aux_free_PemDekLocal(&new))

	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_PemRecLocal *aux_cpy_SET_OF_PemRecLocal(
	SET_OF_PemRecLocal	 *old
)

#else

SET_OF_PemRecLocal *aux_cpy_SET_OF_PemRecLocal(
	old
)
SET_OF_PemRecLocal	 *old;

#endif

{
	SET_OF_PemRecLocal *new = (SET_OF_PemRecLocal *)0, *new2;

	while(old) {
		if(new) {
			NEWSTRUCT(new2->next, SET_OF_PemRecLocal, (SET_OF_PemRecLocal *) 0, 
										aux_free_SET_OF_PemRecLocal(&new))
			new2 = new2->next;
		}
		else {
			NEWSTRUCT(new2, SET_OF_PemRecLocal, (SET_OF_PemRecLocal *) 0, 
										aux_free_SET_OF_PemRecLocal(&new))
			new = new2;
		}
		new2->next = (SET_OF_PemRecLocal *)0;
		new2->element = aux_cpy_PemRecLocal(old->element);
		if(old->element && !new2->element) AUX_ERROR_RETURN((SET_OF_PemRecLocal *) 0, 
										aux_free_SET_OF_PemRecLocal(&new))
		old = old->next;
	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

SET_OF_CRLWithCertificates *aux_cpy_SET_OF_CRLWithCertificates(
	SET_OF_CRLWithCertificates	 *old
)

#else

SET_OF_CRLWithCertificates *aux_cpy_SET_OF_CRLWithCertificates(
	old
)
SET_OF_CRLWithCertificates	 *old;

#endif

{
	SET_OF_CRLWithCertificates *new = (SET_OF_CRLWithCertificates *)0, *new2;

	while(old) {
		if(new) {
			NEWSTRUCT(new2->next, SET_OF_CRLWithCertificates, (SET_OF_CRLWithCertificates *) 0, 
										aux_free_SET_OF_CRLWithCertificates(&new))
			new2 = new2->next;
		}
		else {
			NEWSTRUCT(new2, SET_OF_CRLWithCertificates, (SET_OF_CRLWithCertificates *) 0, 
										aux_free_SET_OF_CRLWithCertificates(&new))
			new = new2;
		}
		new2->next = (SET_OF_CRLWithCertificates *)0;
		new2->element = aux_cpy_CRLWithCertificates(old->element);
		if(old->element && !new2->element) AUX_ERROR_RETURN((SET_OF_CRLWithCertificates *) 0, 
										aux_free_SET_OF_CRLWithCertificates(&new))
		old = old->next;
	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

CRLWithCertificates *aux_cpy_CRLWithCertificates(
	CRLWithCertificates	 *old
)

#else

CRLWithCertificates *aux_cpy_CRLWithCertificates(
	old
)
CRLWithCertificates	 *old;

#endif

{
	CRLWithCertificates *new = (CRLWithCertificates *)0;

	if(old) {
		NEWSTRUCT(new, CRLWithCertificates, (CRLWithCertificates *) 0, ;)

		new->crl = aux_cpy_CRL(old->crl);

		if(old->crl && !new->crl) AUX_ERROR_RETURN((CRLWithCertificates *) 0, 
										aux_free_CRLWithCertificates(&new))


		new->certificates = aux_cpy_Certificates(old->certificates);

		if(old->certificates && !new->certificates) AUX_ERROR_RETURN((CRLWithCertificates *) 0, 
										aux_free_CRLWithCertificates(&new))


	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemRecLocal *aux_cpy_PemRecLocal(
	PemRecLocal	 *old
)

#else

PemRecLocal *aux_cpy_PemRecLocal(
	old
)
PemRecLocal	 *old;

#endif

{
	PemRecLocal *new = (PemRecLocal *)0;

	if(old) {
		NEWSTRUCT(new, PemRecLocal, (PemRecLocal *) 0, ;)

		new->enc_alg = aux_cpy_AlgId(old->enc_alg);

		if(old->enc_alg && !new->enc_alg) AUX_ERROR_RETURN((PemRecLocal *) 0, 
										aux_free_PemRecLocal(&new))

		new->dek = aux_cpy_BitString(old->dek);

		if(old->dek && !new->dek) AUX_ERROR_RETURN((PemRecLocal *) 0, 
										aux_free_PemRecLocal(&new))

		new->certificate = aux_cpy_Certificate(old->certificate);

		if(old->certificate && !new->certificate) AUX_ERROR_RETURN((PemRecLocal *) 0, 
										aux_free_PemRecLocal(&new))


	}

	return(new);
}
/***************************************************************
 *
 * Procedure aux_cpy_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

PemMicLocal *aux_cpy_PemMicLocal(
	PemMicLocal	 *old
)

#else

PemMicLocal *aux_cpy_PemMicLocal(
	old
)
PemMicLocal	 *old;

#endif

{
	PemMicLocal *new = (PemMicLocal *)0;

	if(old) {
		NEWSTRUCT(new, PemMicLocal, (PemMicLocal *) 0, ;)

		new->PEM_conformant = old->PEM_conformant;

		new->signAI = aux_cpy_AlgId(old->signAI);

		if(old->signAI && !new->signAI) AUX_ERROR_RETURN((PemMicLocal *) 0, 
										aux_free_PemMicLocal(&new))

		new->mic = aux_cpy_BitString(old->mic);

		if(old->mic && !new->mic) AUX_ERROR_RETURN((PemMicLocal *) 0, 
										aux_free_PemMicLocal(&new))
	}

	return(new);
}






/***************************************************************
 *
 * Procedure aux_get_abs_path
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_get_abs_path(
	char	 *path,
	char	 *file
)

#else

char *aux_get_abs_path(
	path,
	file
)
char	 *path;
char	 *file;

#endif

{
	char 	*abs_path,
		*home,
		*proc = "aux_get_abs_path";
	int 	 length = 0;

	if(file) length = strlen(file) + 1;

	if(path[0] != PATH_SEPARATION_CHAR) {
		home = getenv("HOME");
		if (!home) home = "";
		abs_path = (char *)malloc(strlen(home)+strlen(path)+length + 2);
		if (!abs_path) {
			aux_add_error(EMALLOC, "abs_path", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(abs_path, home);
		strcat(abs_path, PATH_SEPARATION_STRING);
		strcat(abs_path, path);

		if(strlen(home)) free(home);
	}
	else {
		abs_path = (char *)malloc(strlen(path)+length+1);
		if (!abs_path) {
			aux_add_error(EMALLOC, "abs_path", CNULL, 0, proc);
			return(CNULL);
		}
		strcpy(abs_path, path);
	}
	if(file) {
		strcat(abs_path, PATH_SEPARATION_STRING);
		strcat(abs_path, file);
	}
	return(abs_path);

}



#ifdef SINIX

/*  This extension includes routines for SECUDE, which are not available
 *  on a MX300i.
 *
 *  Author: M. Munzert, SIEMENS AG, ZFE ST SN 5
 *  Date:   20.4.93
 */


#include <unistd.h>          /* setruid */


/* set (real) uid */

int setruid(uid_t uid)
{
  /* this routine may cause errors !!! */
  return (setuid(uid));
}

/* string compare, not case sensitive */

/***************************************************************
 *
 * Procedure strcasecmp
 *
 ***************************************************************/
/*
#ifdef __STDC__

int strcasecmp(
	char	 *s1,
	char	 *s2
)

#else

int strcasecmp(
	s1,
	s2
)
char	 *s1;
char	 *s2;

#endif

{
   not yet implemented: defined in C-Library for SunOS or HP-UX
  printf("\n strcasecmp !!!\n");
  return (strcmp(s1,s2));
}
*/

/* converts network byte-order ulongs to host byte-order */
/* conversion as necessary for MX300i */
/* mun: 29.4.93, SIEMENS AG, ZFE ST SN 5 */

/***************************************************************
 *
 * Procedure ntohl
 *
 ***************************************************************/
#ifdef __STDC__

unsigned ntohl(
	unsigned long	  netlong
)

#else

unsigned ntohl(
	netlong
)
unsigned long	  netlong;

#endif

{
   unsigned long ret;

   ret = (netlong>>24)&0x000000ff; 
   ret += ((netlong>>8)&0x0000ff00);
   ret += ((netlong<<8)&0x00ff0000);
   ret += ((netlong<<24)&0xff000000);
   return(ret);
}

#endif



#ifdef __STDC__

RC aux_input_from_device(
	char *output,
	char *input,
	Boolean echo
)

#else

RC aux_input_from_device(
	output,
	input,
	echo
)
char *output;
char *input;
Boolean echo;


#endif



{

	int		keyboard, n = 0;
	char		*proc = "aux_input_from_device";

#ifdef SYSV
 	struct termio o_par;
 	struct termio n_par;
#else
 	struct termios o_par;
 	struct termios n_par;
#endif


	keyboard = open(input_device, O_RDWR);

	if(keyboard < 0)  {
		aux_add_error(ETTY, "Can't open device", (char *) input_device, char_n, proc);
		return(-1);
	}


#ifdef SYSV
      ioctl(keyboard, TCGETA, &o_par);
      ioctl(keyboard, TCGETA, &n_par);
#else
      tcgetattr(keyboard, &o_par);
      tcgetattr(keyboard, &n_par);
#endif
      if(echo) n_par.c_lflag |=   ECHO | ICANON;
      else     n_par.c_lflag &= ~(ECHO) | ICANON;

#ifdef SYSV
      ioctl(keyboard, TCSETAW, &n_par);
#else
      tcsetattr(keyboard, TCSAFLUSH, &n_par);
#endif


	

	write(keyboard, output, strlen(output));


	n = read(keyboard, input, 999);

	if(n < 0) {
		aux_add_error(ETTY, "Can't read device", (char *) input_device, char_n, proc);
		return(-1);
	}


	

	if(!echo) write(keyboard, "\n", 1);

#ifdef SYSV
	ioctl(keyboard, TCSETAW, &o_par);
#else
	tcsetattr(keyboard, TCSAFLUSH, &o_par);
#endif

	


	input[n-1] = '\0';

	close(keyboard);


	return(0);
}

#ifdef __STDC__

char *aux_getpass(
	char *output
)

#else

char *aux_getpass(
	output
)
char *output;


#endif



{

	char *pw;

	if(!strcmp(input_device, "/dev/tty")) return((char *)getpass(output));

	if(!(pw = (char *) malloc(1000))) return((char *)0);

	if(aux_input_from_device(output, pw, FALSE) < 0 ) {
		free(pw);
		return((char *) 0);
	}
	pw = realloc(pw, strlen(pw) + 1);

	return(pw);

}


#include <varargs.h>
/***************************************************************
 *
 * Procedure FPRINTF
 *
 ***************************************************************/
/*
#ifdef __STDC__

FPRINTF(
	FILE	  *ff,
	char      *format,
	int        va_alist
)

#else 
*/
FPRINTF(
	ff,
	format,
	va_alist
)
FILE	 *ff;
char     *format;
va_dcl

/* #endif */

{
	va_list args;
	int i;
	static Boolean indent = TRUE;
	
	if(indent) for(i = 0; i < print_indent; i++) fprintf(ff, " ");

	va_start(args);
	vfprintf(ff, format, args);
	va_end(args);

	if(format[strlen(format) - 1] == '\n') indent = TRUE;
	else indent = FALSE;

	return(0);
}

	


/***************************************************************
 *
 * Procedure CATSPRINTF
 *
 ***************************************************************/
/*
#ifdef __STDC__

char *CATSPRINTF(
	char	  *string,
	char      *format,
	int        va_alist
)

#else 
*/
char *CATSPRINTF(
	string,
	format,
	va_alist
)
char	 *string;
char     *format;
va_dcl

/* #endif */

{
	static Boolean indent = TRUE;
	va_list args;
	int i;
	char tmp[1000];
	char *proc = "CATSPRINTF";

	tmp[0] = '\0';
	if(indent && print_indent) for(i = 0; i < print_indent; i++) strcat(tmp, " ");
	va_start(args);
	vsprintf(tmp + strlen(tmp), format, args);
	va_end(args);
	if(tmp[strlen(tmp) - 1] == '\n') indent = TRUE;
	else indent = FALSE;

	if(string) string = realloc(string, strlen(string) + strlen(tmp) + 1);
	else {
		string = malloc(strlen(tmp) + 1);
		string[0] = '\0';
	}
	if(!string) {
		aux_add_error(EMALLOC, "string", CNULL, 0, proc);
		return(CNULL);
	}
	strcat(string, tmp);

	return(string);
}
/***************************************************************
 *
 * Procedure aux_sappend_char
 *
 ***************************************************************/
/*
#ifdef __STDC__

RC aux_sappend_char(
	OctetString	  *string,
	char      *format,
	int        va_alist
)

#else 
*/
RC aux_sappend_char(
	string,
	format,
	va_alist
)
OctetString	 *string;
char     *format;
va_dcl

/* #endif */

{
	va_list args;
	int i;
	char tmp[1000];
	char *proc = "aux_sappend_char";

	va_start(args);
	vsprintf(tmp, format, args);
	va_end(args);

	if(!string) {
		aux_add_error(EINVALID, "No OctetString given", CNULL, 0, proc);
		return(-1);
	}
	if(aux_append_char(string, tmp) < 0)  {
		AUX_ADD_ERROR;
		return(-1);
	}


	return(0);
}
#ifdef __STDC__

char *CATNSTR(
	char	  *string,
	char      *cat,
	int        chars
)

#else 
char *CATNSTR(
	string,
	cat,
	chars
)
char	 *string;
char     *cat;
int	  chars;

#endif 

{
	char *proc = "CATNSTR";


	if(!cat || !chars) chars = 0;
	else if(chars < 0) chars = strlen(cat);

	if(string) {
		string = realloc(string, strlen(string) + chars + 1);
		if(!string) {
			aux_add_error(EMALLOC, "string", CNULL, 0, proc);
			return(CNULL);
		}
	}
	else {
		string = malloc(chars + 1);
		if(!string) {
			aux_add_error(EMALLOC, "string", CNULL, 0, proc);
			return(CNULL);
		}
		string[0] = '\0';
	}
	if(chars) strncat(string, cat, chars);

	return(string);
}

