/* disconnect.c
 *
 * $Id: disconnect.c,v 1.14 1999/02/25 00:33:31 nisse Exp $ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1998 Niels Mller
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "disconnect.h"

#include "connection.h"
#include "format.h"
#include "parse.h"
#include "ssh.h"
#include "werror.h"
#include "xalloc.h"

struct lsh_string *format_disconnect(int code, const char *msg, 
                                     const char *language)
{
  return ssh_format("%c%i%z%z",
		    SSH_MSG_DISCONNECT,
		    code,
		    msg, language);
}

static int do_disconnect(struct packet_handler *closure UNUSED,
			 struct ssh_connection *connection UNUSED,
			 struct lsh_string *packet)
{
  struct simple_buffer buffer;
  unsigned msg_number;
  UINT32 length;
  UINT32 reason;
  UINT8 *msg;
  
  simple_buffer_init(&buffer, packet->length, packet->data);

  if (parse_uint8(&buffer, &msg_number)
      && (msg_number == SSH_MSG_DISCONNECT)
      && (parse_uint32(&buffer, &reason))
      && (parse_string(&buffer, &length, &msg))
      /* FIXME: Language tag is ignored */ )
    {
      /* FIXME: Display a better message */
      werror("Disconnect for reason %i\n%ups\n", reason, length, msg);
    }
  else
    werror("Invalid disconnect message!\n");

  lsh_string_free(packet);
  
  /* FIXME: Mark the file as closed, somehow (probably a variable in
   * the write buffer) */

  return LSH_CLOSE;
}

struct packet_handler *make_disconnect_handler(void)
{
  NEW(packet_handler, res);

  res->handler = do_disconnect;
  return res;
}
