/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)certx.h	1.3 95/11/17"
 

/*
This is the certificate discovery protocol.  This part of the
protocol is defined by the certx class.
    0                   1                   2                   3
    0 1 2 3 4 5 6 7 0 1 2 3 4 5 6 7 0 1 2 3 4 5 6 7 0 1 2 3 4 5 6 7
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   | VERS  |ACTION |    STATUS     |  MKID  NSID   |NUMBER-OF-CERTS|
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                            MKID                               ~
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

This part of the protocol is defined by the certentry protocol

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |  CERT-TYPE    |   NSID        | CERT-LENGTH                   |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                Certificate                                    ~
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

The class operates in the following way:

	You declare a variable of type certx.  You assign the portions
	of the certx class to the request/response your sending out.  You
	then pass a struct certentry to the routine certx::addcert.  This
	will let the certx class know you are sending this certificate and
	increase number-of-certs.  When you are ready to send the request
	the routine certx::encode will produce a Bstream consisting of
	the byte stream suitable for sending down the wire.

	The other two methods in certx of interest  are certx::decode
	and certx::getcert.  decode takes a Bstream and creates a certx
	and some number of certentry fields.    getcert will return the
	certentry struct for that certificate.

*/


#define CDP_PORT		6455	// certd port
#define CDP_CLIENT_PORT		6456	// requester port

// Actions
#define CDP_REQUEST		1 	
#define	CDP_RESPONSE		2

#define MAXCERTBUF	65536		// 64k datagrams

// Responses that are sent by the certd.  LOCALERR is for local consumtion
// only.

#define CDP_STATUS_LOCALERR	-1
#define CDP_STATUS_OK		0
#define	CDP_STATUS_ERROR	1
#define	CDP_STATUS_NOTFOUND	2
#define CDP_STATUS_NONSID	3

class certentry 
#ifdef RW
: public ListElem 
#endif
{
public:
	u_char certtype;			// Type of certificate
	u_char nsid;				// Nsid of this key keyid
	Bstream cert;				// The certificate itself
	certentry();				// initializers
	certentry(u_char, u_char, Bstream);
	certentry& operator=(const certentry&);	
	Bstream encode();			// create a Bstream from this
	decode(Bstream&);			// fill in this struct 
	void print();				
};

class certx {
	u_char ncerts;		// number of certs in the request.
	certentry *certs[255];  // Ok since we can ncerts is one byte
public:
	u_char version;		// Protocol Version number.
	u_char action;		// Action requested.
	u_char status;		// Status for response.
	u_char nsidmkid;	// nsid of the mkid.
	Bstream mkid;		// Master Key id for which certs are requested.
	certx();		// empty initializer
	~certx();		// delete it
	certx( u_char, u_char, u_char, Bstream);
	Bstream encode();	// Make a bstream from this struct.
	decode(Bstream);	// Take a bstream and fill in this struct.
	addcert(certentry);	// Add a certificate to this request.
	certentry getcert(int);	// get a certificate in this request.
	void print();		// print this structure.
};
