/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)certx.C	1.4 95/11/20"

#include <sys/types.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "Bstream.h"
#include "Bigint.h"
#include "my_types.h"
#include "certx.h"
#include "SkipCert.h"
#include "skip_conf.h"

extern int nsid_sizes[];
// Routines to implement the certificate discovery protocol classes certx
// and certentry.  see certx.h for uses of these two classes.


certentry::certentry(){
	certtype=nsid=0;
}

certentry::certentry(u_char type, u_char nid, Bstream certdata)
{
	certtype=type;
	nsid=nid;
	cert=certdata;
}

// Take a certentry and encode it as Bstream.  This is returned in network
// order suitable for sending over the wire.
Bstream certentry::encode() 
{
	Bstream final;
	u_short len;
	len=htonl(cert.getlength());
	final=Bstream(1,&certtype)+Bstream(1,&nsid)+
			Bstream(2,(u_char *)&len)+cert;
	return final;
}
void certentry::print(){
	SkipCert *c;
	printf("CERT-TYPE: %d\n", certtype);
	printf("NSID: %d\n", nsid);
	c = decode_SkipCert(certtype, cert);
	c->print();
}

// Take a network ordered Bstream and fill in a certentry function.  This 
// routine is ususally called by certx::decode
certentry::decode(Bstream &str)
{
	int len;
	u_short n;
	int certlen;
	len=str.getlength();
	if (len < 4)
		return 1;
	str.fetchbyte(certtype);
	str.fetchbyte(nsid);

	certlen=*(u_short *)str.getdatap();
	certlen=ntohs(certlen);
	str.consume(2);

	if (len < certlen+4 )
		return 1;
	cert=str;
	return 0;
}

void certx::print()
{
	int i;
	certentry c;
	String temp;
	printf("Version = %d\n",version);
	printf("action = %d\n", action);
	printf("status = %d\n", status );
	printf("MKID NSID = %d\n",nsidmkid);
	printf("ncerts = %d\n",ncerts);
	temp=mkid.gethexstr();
	printf("MKID=%s\n",(const char *)temp);
	i=0;
	do {
		c=getcert(i);
		if (c.certtype == 0)
			break;
		printf("Certificate %d\n",i);
		c.print();
		i++;
	} while(1);
		
}

certx::~certx() {
	for (int i=0; i< ncerts; i++) 
		delete certs[i];	
}
certx::certx() {
	version=1;
	action=status=nsidmkid=ncerts=0;
}

certx::certx(u_char act, u_char stat, u_char nsid, Bstream mk)
{
	version=1;
	action=act&0x0f;
	nsidmkid=nsid;
	mkid=mk;
	status=stat;
	ncerts = 0;
}

// Take a certx class and encode it into a network ordered bstream suitable
// for sending over the wire.

Bstream certx::encode()
{
	Bstream hdr;
	Bstream cert;
	u_char veraction;
// First prepare the outer part of the certificate discovery packet
	veraction=1<<4|action;
	hdr=Bstream(1,&veraction)+Bstream(1,&status)+Bstream(1,&nsidmkid)+
	    Bstream(1,&ncerts)+mkid;

// now prepare an inner entry for each certentry which has been added
	for (int i=0; i<ncerts; i++) {
		cert=certs[i]->encode();
		hdr+=cert;
	}
	return hdr;
}

// Decode a Certificate discovery bstream.  This will fill in the outer (certx)
// header and call certentry::decode for each certificate.
certx::decode(Bstream str)
{
	int len;
	int nsidlen;
	u_char numcerts;
	u_char veraction;
	len=str.getlength();
	if (len < 4) 
		return 1;

	len-=4;
	str.fetchbyte(veraction);
	version=(veraction & 0xf0) >> 4;
	action = veraction &0x0f;
	str.fetchbyte(status);
	str.fetchbyte(nsidmkid);
	str.fetchbyte(numcerts);


	if (nsidmkid == 0 || nsidmkid > MAX_NSIDS)
		return 1;
	nsidlen=nsid_sizes[nsidmkid];

	if (len < nsidlen)
		return 1;
	len-=4;
	mkid=Bstream(nsidlen,str.getdatap());
	str.consume(nsidlen);

	for (int i=0; i< numcerts; i++) {
		certentry t;
		if (t.decode(str))
			return 1;
		addcert(t);
	}
	return 0;
}

// Tell the certx class about a new certificate.  This routine is used to
// build a certificate discovery request.
certx::addcert(certentry c)
{
	certentry *t;
	t = new certentry;
	*t = c;
	certs[ncerts]=t;
	ncerts++;
	return 0;
}

// return a certentry for the certx structure.  
certentry certx::getcert(int n)
{
	int j=0;
	if ( n >= ncerts ) {
		certentry n;
		return n;
	}
	return *certs[n];
	certentry empty;
	return empty;
}

certentry& certentry::operator=(const certentry& a)
{
	certtype=a.certtype;
	nsid=a.nsid;
	cert=a.cert;
	return *this;
}
