/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_sunos.h	1.3 95/11/22 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * Solaris 1.x system includes
 */
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/user.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/syslog.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <net/if.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/in_var.h>

#ifdef KERNEL

#include <sys/mbuf.h>
#include <sun/vddrv.h>
#include <sys/syslog.h>
#include <sys/conf.h>
#include <sys/protosw.h>
#include <sys/kernel.h>
#include <sys/domain.h>
#include <net/netisr.h>

#define	PANIC(s)		panic(s)

/*
 * 4.x memory management macros
 */
#include <sys/kmem_alloc.h>
#define	MEM_ALLOC(m)		new_kmem_zalloc(m, KMEM_NOSLEEP)
#define	MEM_FREE(m, n)		kmem_free(m, n)
#define	BCOPY(s, d, n)		bcopy(s, d, n)
#define	BZERO(s,n)		bzero(s,n)
#define	STATIC			static

#define KMEM_ALLOC(a, b)	(void *) new_kmem_alloc((a), (b))
#define KMEM_ZALLOC(a, b)	(void *) new_kmem_zalloc((a), (b))
#define KMEM_FREE(a, b)		kmem_free((a), (b))
#define ALIGNED(x)		(((unsigned int)(x)&(skip_alignment - 1)) == 0)

/*
 * 4.x lock management macros
 */
#define	MUTEX_T			int
#define	MUTEX_INIT(m, n)
#define	MUTEX_DESTROY(m)
#define	MUTEX_ENTER(m)		(*m) = splnet()
#define	MUTEX_EXIT(m)		splx(*m)

/*
 * 4.x buffer management macros
 */
#define	SKIP_BUF_T		struct mbuf
#define	BUFSTART(m)		mtod(m, unsigned char *)
#define	BUFEND(m)		(mtod(m, unsigned char *) + m->m_len)
#define	BUFLEN(m)		(m->m_len)
#define	BUFGROW(m, n)		(m->m_len += n)
#define	BUFFREE(m)		m_freem(m)

/*
 * Notifier interface
 */
#define	SKIP_NOTIFYQ_T		int
#define	SKIP_SET_NOTIFIER(n, q)	(n = q)

/*
 * 4.x logging defines
 */
#define skip_log(s)		log(LOG_KERN, s)
#define skip_log1(s, t)		log(LOG_KERN, s, t)
#define skip_log2(s, t, q)	log(LOG_KERN, s, t, q)

/*
 * 4.x debugging defines
 */
#define	SKIP_DEBUG(s)		if (skip_key_debug) printf(s)
#define	SKIP_DEBUG1(s, t)	if (skip_key_debug) printf(s, t)
#define	SKIP_DEBUG2(s, t, q)	if (skip_key_debug) printf(s, t, q)

#endif /* KERNEL */

#ifdef  __cplusplus
}
#endif
