/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)descbc_wrapper.c	1.5 95/11/15 Sun Microsystems"

#ifdef SYSV
#include <skip_sysv.h>
#endif

#ifdef SUNOS
#include <skip_sunos.h>
#endif

#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

#include "skip_proto.h"
#include "skip_types.h"
#include "skip_crypt.h"

/*
 * SunOS 5.x loadble driver wrapper for the des_cbc encryptor
 *
 */
extern const skip_cryptor_t	des_cbc_module;
extern const skip_cryptor_t	des_cbc_module_v1;
extern const unsigned int	des_cbc_id;
extern char			des_cbc_name[];
extern unsigned int		des_cbc_busy;

char _depends_on[] = "drv/skip_key";

/*
 * Module linkage information for the kernel.
 */
extern struct mod_ops 	mod_miscops;

static struct modlmisc modlmisc = {
	&mod_miscops,		/* misc_modops */
	des_cbc_name,		/* strmod_linkinfo */
};

static struct modlinkage modlinkage = {
        MODREV_1,		/* ml_rev, has to be MODREV_1 */
	(void *) &modlmisc,	/* ml_linkage, NULL-terminated list of */
	NULL			/* linkage structures                 */
};


/*
 * add the crypt module to the table of cryptors
 * at position specifid by module_id
 */
_init()
{
	
	if (skip_install_cryptmod(&des_cbc_module_v1, SKIP_DES_CBC, 
					SKIP_V1) < 0)
		return EINVAL;
	if (skip_install_cryptmod(&des_cbc_module,SKIP_CRYPT_DES_CBC,
				SKIP_V2) < 0)
		return EINVAL;
	return (mod_install(&modlinkage));
}

/*
 * remove the module from the table of cryptors
 */
_fini()
{
	if (des_cbc_busy) {
		return (EBUSY);
	}
	skip_remove_cryptmod(SKIP_DES_CBC, SKIP_V1);
	skip_remove_cryptmod(SKIP_CRYPT_DES_CBC, SKIP_V2);
	return (mod_remove(&modlinkage));
}

_info(modinfop)
struct	modinfo *modinfop;
{
	return (mod_info(&modlinkage, modinfop));
}
