/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)test_ca.C	1.5 95/12/04 Sun Microsystems"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "asn1_der.h"
#include "ObjId.h"
#include "Name.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "X509skip.h"
#include "Passwd.h"
#include "CRL.h"

#include "bn.h"
#include "bnprint.h"
#include "bn_glue.h"
#include "dsa.h"
#include "ca.h"
#include "userfuncs.h"
#include "utils.h"

#define	DSA_KEYSIZE	256

void
make_ca(char *caname, int life_t, int crl_t, char *pass)
{
	Bstream nullbstr, certreq, privkey, encryptedPrivKey,
		publickey, CRL, passphrase;
	String	errormsg;
	Name	nullname;
	struct	BigNum	p, q, g, x, y;
	Bigint	prime, subprime, gen, secret, pub;
	int retval;

	// check that the CA name is valid
	Name caName(caname);
	if (caName == nullname) {
		fprintf(stderr, "Invalid Distinguished Name\n");
		exit(1);
	}

	// Save the CA name in file
	Bstream canamestr(strlen(caname), (byte *)caname);
	canamestr.store(CANAME_FILE);

	if (pass == NULL) 
		pass = passwd_confident("Enter CA password: ");
	if (pass == NULL) {
		printf("Password must be provided.\n");
		exit(1);
	}
	passphrase = Bstream(strlen(pass), (unsigned char *)pass);

	// get a seed.  This could be chosen by the user, but for now
	// it's just a random number.
	prompt_user_for_randomness();
	Bstream seed = get_random_bytes(32);

	// initialize BigNums
	bnInit();
	bnBegin(&p);
	bnBegin(&q);
	bnBegin(&g);
	bnBegin(&x);
	bnBegin(&y);

	// create a DSA key-pair for the CA
	retval = dsaGen(&p, DSA_KEYSIZE, &q, 160, &g, &x, &y, seed.getdatap(),
			seed.getlength(), stderr);
	if (retval < 0) {
		fprintf(stderr, "error generating dsa keys\n");
		goto failed;
	}

	// coversions ...
	BigNum_to_Bigint(&p, &prime);
	BigNum_to_Bigint(&q, &subprime);
	BigNum_to_Bigint(&g, &gen);
	BigNum_to_Bigint(&x, &secret);
	BigNum_to_Bigint(&y, &pub);


	// BER encoding of Private Key value
	fprintf(stderr, "BER encoding the Private Key value...\n");
	privkey = asn1_der_encode_dsa_privkey(prime, subprime, gen, secret);
	if (privkey == nullbstr) {
		fprintf(stderr, "Error encoding the DSA private key\n");
		goto failed;
	}

	// Encrypt private key info
	fprintf(stderr, "Encrypting encoded private key...\n");
	encryptedPrivKey = passwd_encrypt(passphrase, privkey, md5,
					errormsg);
	if (encryptedPrivKey == nullbstr) {
		fprintf(stderr, "%s", (const char *)errormsg);
		goto failed;
	}

#ifdef DEBUG
	// Store private key info in file
	privkey.store("privkey");
#endif
	// Store encrypted private key info in file
	encryptedPrivKey.store(CA_PRIVKEY_FILE);

	// BER encoding of Public Key value
	fprintf(stderr, "BER encoding the Public Key value...\n");
	publickey = asn1_der_encode_dsa_publickey(prime, subprime, gen, pub);
	if (publickey == nullbstr) {
		fprintf(stderr, "Error encoding the DSA public key\n");
		goto failed;
	}

	// Make certificate request information for this CA
	fprintf(stderr, "BER encoding the certificate request...\n");
	certreq = asn1_der_encode_certreq(caname, publickey, privkey);
	if (certreq == nullbstr) {
		printf("failed to encode the cert request\n");
		goto failed;
	}
	certreq.store(CA_CERTREQ_FILE);

#ifdef RW
	// Create an empty CRL to begin with
	fprintf(stderr, "Generating initial CRL...\n");
	CRL = initial_CRL(privkey, caname, crl_t);
	CRL.store(CA_CRL_FILE);
#endif

	(void) system((char *)((const char *)
		("/bin/rm -rf " + (String) CERT_DATABASE_DIR)));
	(void) system((char *)((const char *)
		("/bin/mkdir " + (String) CERT_DATABASE_DIR)));
	(void) system((char *)((const char *)
		("/bin/rm -rf " + (String) NEXT_SERIALNUM_FILE)));

	// Create the first certificate that is the
	// CA's own self-signed certificate. This
	// will be certificate serial # 1. 
	fprintf(stderr, "Issuing CAs self-signed certificate...\n");
	retval = dsa_newcert(CA_CERTREQ_FILE, CA_CERT_FILE, life_t,
				passphrase);
	if (retval < 0) {
		fprintf(stderr, "error issuing cert\n");
		goto failed;
	}

failed:
	// no longer need the bignums
	bnEnd(&y);
	bnEnd(&x);
	bnEnd(&g);
	bnEnd(&q);
	bnEnd(&p);
	exit(retval);
}

void
usage(const char *progname)
{
	(void) fprintf(stderr,
		"Usage: %s <CA Distinguished Name>\n", progname);
	(void) fprintf(stderr, "\t[-l <certificate lifetime (months)>]\n");
	(void) fprintf(stderr, "\t[-u <CRL update frequency (months)>]\n");
        exit(1);
}

main(int argc, char **argv)
{
	char *pass = NULL, *caname = NULL;
	int c, lifetime = 12, crl_update = 1;
	extern char *optarg;
	extern int optind, opterr;

	camode = TRUE;

	while ((c = getopt(argc, argv, "p:t:u:")) != EOF)
	switch (c) {
		case 'p':       // note, this is not documented
			pass = optarg;
			break;
		case 't':
			lifetime = atoi(optarg);
			break;
		case 'u':
			crl_update = atoi(optarg);
			break;
		case '?':
		default:
			usage(argv[0]);
	}

	if (lifetime <= 0) {
		fprintf(stderr,
			"Certificate lifetime has to be at least a month.\n");
		usage(argv[0]);
	}
	if (crl_update <= 0) {
		fprintf(stderr,
			"CRL update frequency has to be at least a month.\n");
		usage(argv[0]);
	}

	if (optind >= argc)
		usage(argv[0]);
		// ca name 
	make_ca(argv[optind], lifetime, crl_update, pass);
}
