#!/bin/sh
#
#pragma ident "@(#)install_skip_keys.sh	1.12 95/11/27 SunMicrosystems"
#
# Script to install the ZeroAssuranceCA issued key package
# onto an End-system SKIP node

SUNOS=`/bin/uname -r | /bin/sed 's/\..*//g'`
if [ $SUNOS = 5 ]; then
	SKIP_BIN=/opt/SUNWicg/bin
	SKIP_ETC=/etc/opt/SUNWicg/skip
else
	SKIP_BIN=/usr/skip/bin
	SKIP_ETC=/etc/skip
fi

SKIP_PATH=${SKIP_PATH-$SKIP_BIN}
PATH=${SKIP_PATH}:/bin:/usr/ucb:$PATH export PATH

if [ $# -lt 1 ]
then
	echo "$0 certificate-file"
	exit 1
fi
filename=$1
USER=`whoami`

if [ $USER != "root" ]
then
	echo "$0: you must be root to run this command."
	exit 1
fi

if [ ! -d $SKIP_PATH ]; then
	echo "$0: cannot find $SKIP_PATH - is SKIP installed?"
	exit 1
fi

if [ ! -d $SKIP_ETC ]; then
	echo "$0: cannot find $SKIP_ETC - is SKIP installed?"
	exit 1
fi

DIR=/tmp/skip$$
mkdir $DIR
cp $1 $DIR/tempfile
cd $DIR

if (grep 'begin' tempfile >/dev/null)
then
	echo "$0: uudecode..."
	uudecode <tempfile
elif (grep 'BEGIN PGP MESSAGE' tempfile >/dev/null)
then
	echo "$0: running PGP to decrypt..."
	cat tempfile | pgp -f >keys.tar
else
	echo "$0: file does not appear to be key file."
	exit 1
fi

tar -xf keys.tar
md5 my_X509_cert my_secret_i ZeroAssurance_Cert > md5.newsums

echo "Comparing MD5 checksums..."
diff md5.newsums md5.sums 

if [ $? -ne 0 ]
then
	echo "$0: md5 sums do not match!!!"
	exit 1
fi
echo "$0: checksums are good."
echo "$0: Moving files into place...."

mv my_X509_cert my_secret_i ZeroAssurance_Cert $SKIP_ETC
rm -f $SKIP_ETC/CA_Cert
ln -s $SKIP_ETC/ZeroAssurance_Cert $SKIP_ETC/CA_Cert

skip_init_certbase
skip_add_cert -n 1 -t X509 $SKIP_ETC/my_X509_cert
cd /tmp
rm -rf $DIR

echo "$0: you should now reboot the machine to initialize SKIP."
