/* pututmpentry.c: The opiepututmpentry() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified by cmetz for OPIE 2.21. Use simpler wtmp code -- please
              submit a bug report if this breaks on your system.
	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration, trickery
	      to avoid an ifdef in pututmpentry's declaration. Let Autoconf
              take one last stab at finding utmp/wtmp files. Report read()
              errors. Added HP-UX kluge. Fill in ut_pid and ut_type.
              Disabled check for LOGIN_PROCESS. Pass a timezone parameter
              to gettimeofday(). Use symbolic lseek() whence values. Make
              sure opie.h is the last header.
        Modified at NRL for OPIE 2.2. Moved into different name and subdir.
	Written at NRL for OPIE 2.0.
*/

#include "opie_cfg.h"

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <utmp.h>
#include <string.h>
#include <time.h>
#include <syslog.h>

#if DOUTMPX
#include <utmpx.h>
#endif	/* DOUTMPX */

#include "opie.h"

#ifndef _PATH_UTMP
#ifdef UTMP_FILE
#define _PATH_UTMP	UTMP_FILE
#else /* UTMP_FILE */
#ifdef PATH_UTMP_AC
#define _PATH_UTMP      PATH_UTMP_AC
#else /* PATH_UTMP_AC */
#define _PATH_UTMP       "/etc/utmp"
#endif /* PATH_UTMP_AC */
#endif /* UTMP_FILE */
#endif /* _PATH_UTMP */

#ifndef _PATH_UTMPX
#ifdef PATH_UTMPX_AC
#define _PATH_UTMPX      PATH_UTMPX_AC
#else /* PATH_UTMPX_AC */
#define _PATH_UTMPX     "/etc/utmpx"
#endif /* PATH_UTMPX_AC */
#endif  /* _PATH_UTMPX */

#ifndef _PATH_WTMP
#ifdef WTMP_FILE
#define _PATH_WTMP	WTMP_FILE
#else /* WTMP_FILE */
#ifdef PATH_WTMP_AC
#define _PATH_WTMP      PATH_WTMP_AC
#else /* PATH_WTMP_AC */
#define _PATH_WTMP      "/usr/adm/wtmp"
#endif /* PATH_WTMP_AC */
#endif /* WTMP_FILE */
#endif

#ifndef _PATH_WTMPX
#ifdef PATH_WTMPX_AC
#define _PATH_WTMPX      PATH_WTMPX_AC
#else /* PATH_WTMPX_AC */
#define _PATH_WTMPX     "/usr/adm/wtmpx"
#endif /* PATH_WTMPX_AC */
#endif	/* _PATH_UTMPX */

#ifndef DOOURUTMP
#define DOOURUTMP 1 
#endif /* DOOURUTMP */

VOIDRET opiepututmpentry FUNCTION((line, UTMPX), char *line AND
				  struct UTMPX *UTMPX)
{
  struct utmp utmp2, utmp3;
  int i, j, f, utmp_slot = 0;
  char *line2;
#ifdef hpux
  char *line3 = "pty/12345";
#endif /* hpux */

#if DOUTMPX
  struct utmpx utmp2x, utmp3x;
  struct utmp *utmp = (struct utmp *) malloc(sizeof(struct utmp));
  int utmpx_slot = 0;

  if (!utmp)
    return;
#endif	/* DOUTMPX */

#if HAVE_UT_PID
  UTMPX->ut_pid = getpid();
#endif /* HAVE_UT_PID */
#if HAVE_UT_TYPE && defined(USER_PROCESS)
  UTMPX->ut_type = USER_PROCESS;
#endif /* HAVE_UT_TYPE && defined(USER_PROCESS) */

  line2 = line;
  if (!strncmp(line, "/dev/", 5)) {
    line2 += 5;
    strncpy(UTMPX->ut_line, line2, sizeof(UTMPX->ut_line));
  }

#ifdef hpux
  strcpy(line3 + 4, line2);
#endif /* hpux */

#if DOUTMPX
  if ((f = open(_PATH_UTMPX, O_RDWR)) < 0) {
    perror("getutmp");
    goto l1;
  }

#ifdef HAVE_ONE_ARG_GETTIMEOFDAY
  gettimeofday(&utmpx->ut_tv, NULL);
#endif /* HAVE_ONE_ARG_GETTIMEOFDAY */  

  i = 0;

#if HAVETTYSLOT
  if ((i = ttyslot()) < 0)
    i = lseek(f, 0, SEEK_END) / sizeof(struct utmpx);

  lseek(f, (i * sizeof(struct utmpx)), SEEK_SET);
  write(f, (char *) utmpx, sizeof(struct utmpx));
#else	/* HAVETTYSLOT */
  while(read(f, (char *) &utmp2x, sizeof(struct utmpx)) == sizeof(struct utmpx)) {
    if ((!strncmp(utmp2x.ut_line, line, sizeof(utmp2x.ut_line)) || 
	!strncmp(utmp2x.ut_line, line2, sizeof(utmp2x.ut_line)) 
#ifdef hpux
     || !strncmp(utmp2x.ut_line, line3, sizeof(utmp2x.ut_line))
#endif /* hpux */
        )
#if 0 && defined(LOGIN_PROCESS)
	&& (utmp2x.ut_type == LOGIN_PROCESS)
#endif /* LOGIN_PROCESS */
      ) {
#ifdef DEBUG
      fprintf(stderr, "Using utmpx slot %d.\n", i);
#endif	/* DEBUG */
      lseek(f, i * sizeof(struct utmpx), SEEK_SET);
      write(f, (char *) utmpx, sizeof(struct utmpx));
      utmpx_slot = i;
      goto l1;
    }
    i++;
  };
#endif	/* HAVETTYSLOT */

l1:
  close(f);

  strncpy(utmp->ut_name, utmpx->ut_name, sizeof(utmp->ut_name));
  strncpy(utmp->ut_id, utmpx->ut_id, sizeof(utmp->ut_id));
  strncpy(utmp->ut_line, utmpx->ut_line, sizeof(utmp->ut_line));
  utmp->ut_pid = utmpx->ut_pid;
  utmp->ut_type = utmpx->ut_type;
  memcpy(&utmp->ut_exit, &utmpx->ut_exit, sizeof(utmp->ut_exit));
#endif	/* DOUTMPX */

  if ((f = open(_PATH_UTMP, O_RDWR)) < 0) {
    perror("getutmp");
    goto l2;
  }
  time(&utmp->ut_time);

#if HAVETTYSLOT
#if !DOUTMPX
  if ((i = ttyslot()) < 0)
    i = lseek(f, 0, SEEK_END) / sizeof(struct utmp);
#endif

  lseek(f, (i * sizeof(struct utmp)), SEEK_SET);
  write(f, (char *) utmp, sizeof(struct utmp));
#else	/* HAVETTYSLOT */
  i = 0;

  while(read(f, (char *) &utmp2, sizeof(struct utmp)) == sizeof(struct utmp)) {
    if ((!strncmp(utmp2.ut_line, line, sizeof(utmp2.ut_line)) || 
	!strncmp(utmp2.ut_line, line2, sizeof(utmp2.ut_line)) 
#ifdef hpux
     || !strncmp(utmp2.ut_line, line3, sizeof(utmp2.ut_line))
#endif /* hpux */
        )
#if 0 && defined(LOGIN_PROCESS)
	&& (utmp2.ut_type == LOGIN_PROCESS)
#endif	/* LOGIN_PROCESS */
      ) {
#ifdef DEBUG
      fprintf(stderr, "Using utmp slot %d.\n", i);
#endif	/* DEBUG */
      lseek(f, (i * sizeof(struct utmp)), SEEK_SET);
      write(f, (char *) utmp, sizeof(struct utmp));
      utmp_slot = i;

      goto l2;
    }
    i++;
  }
  while (j == sizeof(struct utmp));
#endif	/* HAVETTYSLOT */

l2:
  close(f);

#if DOUTMPX
  if (utmp_slot != utmpx_slot) {
    syslog(LOG_ERR, "using different slots for utmp and utmpx?! (utmp=%d, utmpx=%d)", utmp_slot, utmpx_slot);
    syslog(LOG_ERR, "one or both of these files may be corrupt");
  }

  if ((f = open(_PATH_WTMPX, O_RDWR)) < 0) {
    perror("getutmp");
    goto l3;
  }
  if ((i = lseek(f, 0, SEEK_END)) < 0)
    goto l3;
#if 0
  i -= (i % sizeof(struct utmpx)) + sizeof(struct utmpx);

  do {
    lseek(f, i, SEEK_SET);
    j = read(f, (char *) &utmp3x, sizeof(struct utmpx));
    if ((j == sizeof(struct utmpx)) && !memcmp(&utmp3x, &utmp2x,
					       sizeof(struct utmpx))) {
      lseek(f, i, SEEK_SET);
      write(f, (char *) utmpx, sizeof(struct utmpx));

      goto l3;
    }
    i -= sizeof(struct utmpx);
  }
  while (j == sizeof(struct utmpx));

  lseek(f, 0, SEEK_END);
#endif /* 0 */
  write(f, (char *) utmpx, sizeof(struct utmpx));
l3:
  close(f);
#endif	/* DOUTMPX */
  if ((f = open(_PATH_WTMP, O_RDWR)) < 0) {
    perror("getutmp");
    goto l4;
  }
  if ((i = lseek(f, 0, SEEK_END)) < 0)
    goto l4;

#if 0
  i -= (i % sizeof(struct utmp)) + sizeof(struct utmp);

  do {
    lseek(f, i, SEEK_SET);
    j = read(f, (char *) &utmp3, sizeof(struct utmp));
    if ((j == sizeof(struct utmp)) && !memcmp(&utmp3, &utmp2,
					      sizeof(struct utmp))) {
      lseek(f, i, SEEK_SET);
      write(f, (char *) utmp, sizeof(struct utmp));

      goto l4;
    }
    i -= sizeof(struct utmp);
  }
  while (j == sizeof(struct utmp));

  lseek(f, 0, SEEK_END);
#endif /* 0 */
  write(f, (char *) utmp, sizeof(struct utmp));

l4:
  close(f);

#if DOUTMPX
  free(utmp);
#endif	/* DOUTMPX */

  return;
}
