.SUFFIXES: .c .asm .obj .exe .exm .map

DOSCMD	?= doscmd
OBJS	+= ${SRCS:R:S/$/.obj/g}
CC	= ${DOSCMD} cl
LD	= ${DOSCMD} link
CFLAGS	= -AS -Gs -Fm -I${.CURDIR}/../include
CFLAGS	+= ${COPTS}
AS	= ${DOSCMD} masm
LXOBJS	?= ${.CURDIR}/../tools/csvc.obj ${.CURDIR}/../tools/crt0.obj
EXE	?= ${TARGET:R:S/$/.exe/g}
MAP	?= ${TARGET:R:S/$/.map/g}
MKDEP	?= mkdep
C6include = /usr/local/c6/include

.MAIN:	all

all:	${TARGET}

${EXE} ${MAP}: ${OBJS}
#	${CC} -AS -Fm -o ${EXE} ${OBJS} ${LXOBJS:S/\//\\\\/g}
	echo ${OBJS} ${LXOBJS:S/\//\\\\/g} | fmt | sed -e 's/$$/ +/' > linkfile
	echo "/farcall/noi/m" >> linkfile
	echo ${EXE} >> linkfile
	echo "${MAP};" >> linkfile
	${LD} @linkfile

.exe.exm: ${MAP}
	${DOSCMD} e2m ${.IMPSRC:R}
	@echo

.c.obj:
	${CC} ${CFLAGS} -c -o ${.TARGET} ${.IMPSRC}

.asm.obj:
	${AS} -o ${.TARGET} ${.IMPSRC}

.if !target(clean)
clean:
	rm -f ${TARGET} ${EXE} ${MAP} ${OBJS} ${CLEANFILES}
.endif

.if !target(depend)
depend: .depend
.depend: ${SRCS}
.if defined(TARGET)
	${MKDEP} ${_MKDEP} ${CFLAGS:M-[ID]*} -I$(C6include) ${.ALLSRC:M*.c}
.endif
.endif

