#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <fist.h>

int
main(int argc, char *argv[])
{
  int fd, ret, val=0;

  if (argc < 2 || argc > 3) {
    fprintf(stderr, "Usage: %s file [val]\n", argv[0]);
    exit(1);
  }

  fd = open(argv[1], O_RDONLY);
  if (fd < 0) {
    perror(argv[1]);
    exit(1);
  }
  /* if specified 3rd arg, want to set debug level */
  if (argc == 3) {
    val = atoi(argv[2]);
    ret = ioctl(fd, FIST_IOCTL_SET_DEBUG_VALUE, val);
    if (ret < 0) {
      perror("ioctl set");
      exit(1);
    }
  } else {
    ret = ioctl(fd, FIST_IOCTL_GET_DEBUG_VALUE, &val);
    if (ret < 0) {
      perror("ioctl get");
      exit(1);
    }
    printf("ioctl returned value %d\n", val);
  }

  close(fd);
  exit(0);
}
