dnl aclocal.m4 file for fist-2.0
dnl Contains definitions for specialized GNU-autoconf macros.
dnl Author: Erez Zadok <ezk@cs.columbia.edu>
dnl
dnl DO NOT EDIT DIRECTLY!  Generated automtically by maintainers from
dnl aux/Makefile!
dnl
dnl ######################################################################
dnl UNCOMMENT THE NEXT FEW LINES FOR DEBUGGING CONFIGURE
dnl define([AC_CACHE_LOAD], )dnl
dnl define([AC_CACHE_SAVE], )dnl
dnl ======================================================================



dnl ######################################################################
dnl check if compiler can handle "void *"
AC_DEFUN(AC_C_VOID_P,
[
AC_CACHE_CHECK(if compiler can handle void *,
ac_cv_c_void_p,
[
# try to compile a program which uses void *
AC_TRY_COMPILE(
[ ],
[
void *vp;
], ac_cv_c_void_p=yes, ac_cv_c_void_p=no)
])
if test "$ac_cv_c_void_p" = yes
then
  AC_DEFINE(voidp, void *)
else
  AC_DEFINE(voidp, char *)
fi
])
dnl ======================================================================


dnl ######################################################################
dnl New versions of the cache functions which also dynamically evaluate the
dnl cache-id field, so that it may contain shell variables to expand
dnl dynamically for the creation of $ac_cv_* variables on the fly.
dnl In addition, this function allows you to call COMMANDS which generate
dnl output on the command line, because it prints its own AC_MSG_CHECKING
dnl after COMMANDS are run.
dnl
dnl ======================================================================
dnl AC_CACHE_CHECK_DYNAMIC(MESSAGE, CACHE-ID, COMMANDS)
define(AC_CACHE_CHECK_DYNAMIC,
[
ac_tmp=`echo $2`
if eval "test \"`echo '$''{'$ac_tmp'+set}'`\" = set"; then
  AC_MSG_CHECKING([$1])
  echo $ac_n "(cached) $ac_c" 1>&AC_FD_MSG
else
  $3
  AC_MSG_CHECKING([$1])
fi
ac_tmp_val=`eval eval "echo '$''{'$ac_tmp'}'"`
AC_MSG_RESULT($ac_tmp_val)
])
dnl ======================================================================


dnl ######################################################################
dnl AC_HOST_MACROS: define HOST_CPU, HOST_VENDOR, and HOST_OS
AC_DEFUN(AC_HOST_MACROS,
[
# these are defined already by the macro 'CANONICAL_HOST'
  AC_MSG_CHECKING("host cpu")
  AC_DEFINE_UNQUOTED(HOST_CPU, "$host_cpu")
  AC_MSG_RESULT($host_cpu)

  AC_MSG_CHECKING("vendor")
  AC_DEFINE_UNQUOTED(HOST_VENDOR, "$host_vendor")
  AC_MSG_RESULT($host_vendor)

  AC_MSG_CHECKING("host full OS name and version")
  # normalize some host OS names
  case ${host_os} in
	# linux is linux is linux, regardless of RMS.
	linux-gnu* | lignux* )	host_os=linux ;;
  esac
  AC_DEFINE_UNQUOTED(HOST_OS, "$host_os")
  AC_MSG_RESULT($host_os)

# break host_os into host_os_name and host_os_version
  AC_MSG_CHECKING("host OS name")
  host_os_name=`echo $host_os | sed 's/\..*//g'`
  # normalize some OS names
  case ${host_os_name} in
	# linux is linux is linux, regardless of RMS.
	linux-gnu* | lignux* )	host_os_name=linux ;;
	# remove version number
	solaris* ) host_os_name=solaris;;
	freebsd* ) host_os_name=freebsd;;
  esac
  AC_DEFINE_UNQUOTED(HOST_OS_NAME, "$host_os_name")
  AC_MSG_RESULT($host_os_name)

# parse out the OS version of the host
  AC_MSG_CHECKING("host OS version")
changequote(<<, >>)dnl
  host_os_version=`echo $host_os | sed 's/^[^0-9]*//g'`
changequote([, ])dnl
  if test -z "$host_os_version"
  then
	host_os_version=`(uname -r) 2>/dev/null` || host_os_version=unknown
  fi
# keep only major and minor version (make x.y.z.w => x.y)
changequote(<<, >>)dnl
  host_os_version=`echo $host_os_version | sed 's/^\([0-9]*\.[0-9]*\).*/\1/g'`
changequote([, ])dnl
  AC_DEFINE_UNQUOTED(HOST_OS_VERSION, "$host_os_version")
  AC_MSG_RESULT($host_os_version)
# figure out host architecture (different than CPU)
  AC_MSG_CHECKING("host OS architecture")
  host_arch=`(uname -m) 2>/dev/null` || host_arch=unknown
  # normalize some names
  case ${host_arch} in
	sun4* )	host_arch=sun4 ;;
	sun3x )	host_arch=sun3 ;;
	sun )	host_arch=`(arch) 2>/dev/null` || host_arch=unknown ;;
	i?86 )	host_arch=i386 ;; # all x86 should show up as i386
  esac
  AC_DEFINE_UNQUOTED(HOST_ARCH, "$host_arch")
  AC_MSG_RESULT($host_arch)

# figure out host name
  AC_MSG_CHECKING("host name")
  host_name=`(hostname || uname -n) 2>/dev/null` || host_name=unknown
  AC_DEFINE_UNQUOTED(HOST_NAME, "$host_name")
  AC_MSG_RESULT($host_name)

# set os name + version
  HOST_SHORT_OS_VER=${host_os_name}-${host_os_version}
  AC_SUBST(HOST_SHORT_OS_VER)

# figure out user name
  AC_MSG_CHECKING("user name")
  if test -n "$USER"
  then
    user_name="$USER"
  else
    if test -n "$LOGNAME"
    then
      user_name="$LOGNAME"
    else
      user_name=`(whoami) 2>/dev/null` || user_name=unknown
    fi
  fi
  AC_DEFINE_UNQUOTED(USER_NAME, "$user_name")
  AC_MSG_RESULT($user_name)

# figure out configuration date
  AC_MSG_CHECKING("configuration date")
  config_date=`(date) 2>/dev/null` || config_date=unknown_date
  AC_DEFINE_UNQUOTED(CONFIG_DATE, "$config_date")
  AC_MSG_RESULT($config_date)

])
dnl ======================================================================


dnl ######################################################################
dnl check if a local configuration file exists
AC_DEFUN(AC_LOCALCONFIG,
[AC_MSG_CHECKING(a local configuration file)
if test -f localconfig.h
then
  AC_DEFINE(HAVE_LOCALCONFIG_H)
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT(no)
fi
])
dnl ======================================================================


dnl ######################################################################
dnl AC_MSG: a simple printout message
define(AC_MSG,
[echo "*** $1:" 1>&AC_FD_MSG])
dnl ======================================================================


dnl ######################################################################
dnl Package name
AC_DEFUN(AC_NAME_PACKAGE,
[AC_MSG_CHECKING(package name)
AC_DEFINE_UNQUOTED(PACKAGE, "$1")
AC_MSG_RESULT(\"$1\")
])
dnl ======================================================================


dnl ######################################################################
dnl Version of package
AC_DEFUN(AC_NAME_VERSION,
[AC_MSG_CHECKING(version of package)
AC_DEFINE_UNQUOTED(VERSION, "$1")
AC_MSG_RESULT(\"$1\")
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for CPPFLAGS (-I options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_CPPFLAGS,
[AC_MSG_CHECKING(for configuration/compilation (-I) preprocessor flags)
AC_ARG_ENABLE(cppflags,
[  --enable-cppflags[=ARG] configure/compile with ARG (-I) preprocessor flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  CPPFLAGS="$CPPFLAGS $enableval"
  export CPPFLAGS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Debugging: "yes" means general, and "no" means none.
AC_DEFUN(AC_OPT_DEBUG,
[AC_MSG_CHECKING(for debugging options)
AC_ARG_ENABLE(debug,
[  --enable-debug[=ARG]    enable debugging (yes/no)],
[
if test "$enableval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(DEBUG)
else
  AC_MSG_RESULT(no)
fi
],
[
  # default is no debugging
  AC_MSG_RESULT(no)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Which options to add to CFLAGS for compilation?
dnl NOTE: this is only for final compiltions, not for configure tests)
AC_DEFUN(AC_OPT_FIST_CFLAGS,
[AC_MSG_CHECKING(for additional C option compilation flags)
AC_ARG_ENABLE(fist-cflags,
[  --enable-fist-cflags[=ARG]
                          compile package with ARG additional C flags],
[if test "$enableval" = ""; then
  FIST_CFLAGS=""
  AC_SUBST(FIST_CFLAGS)
  AC_MSG_RESULT(none)
else
  # check if fist supplied configure option without argument
  if test "$enableval" = "yes"; then
    FIST_CFLAGS=""
    AC_SUBST(FIST_CFLAGS)
    AC_MSG_RESULT(none)
  else
    # fist supplied a cflags option to configure
    FIST_CFLAGS="$enableval"
    AC_SUBST(FIST_CFLAGS)
    AC_MSG_RESULT($enableval)
  fi
fi], [
  # default is to have no additional C flags
  FIST_CFLAGS=""
  AC_SUBST(FIST_CFLAGS)
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for LDFLAGS (-L options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_LDFLAGS,
[AC_MSG_CHECKING(for configuration/compilation (-L) library flags)
AC_ARG_ENABLE(ldflags,
[  --enable-ldflags[=ARG]  configure/compile with ARG (-L) library flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  LDFLAGS="$LDFLAGS $enableval"
  export LDFLAGS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for LIBS (-l options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_LIBS,
[AC_MSG_CHECKING(for configuration/compilation (-l) library flags)
AC_ARG_ENABLE(libs,
[  --enable-libs[=ARG]     configure/compile with ARG (-l) library flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  LIBS="$LIBS $enableval"
  export LIBS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Specify additional compile options based on the OS and the compiler
AC_DEFUN(AC_OS_CFLAGS,
[
AC_CACHE_CHECK(additional compiler flags,
ac_cv_os_cflags,
[
case "${host_os}" in
# 	irix6* )
# 		case "${CC}" in
# 			cc )
# 				# do not use 64-bit compiler
# 				ac_cv_os_cflags="-32 -Wl,-woff,84"
# 				;;
# 		esac
# 		;;
# 	osf4* )
# 		# get the right version of struct sockaddr
# 		case "${CC}" in
# 			cc )
# 				ac_cv_os_cflags="-std -D_SOCKADDR_LEN"
# 				;;
# 			* )
# 				ac_cv_os_cflags="-D_SOCKADDR_LEN"
# 				;;
# 		esac
# 		;;
# 	osf* )
# 		# get the right version of struct sockaddr
# 		case "${CC}" in
# 			cc )
# 				ac_cv_os_cflags="-std -D_SOCKADDR_LEN -D_NO_PROTO"
# 				;;
# 			* )
# 				ac_cv_os_cflags="-D_SOCKADDR_LEN -D_NO_PROTO"
# 				;;
# 		esac
# 		;;
# 	solaris2.6* | sunos5.6* )
# 		# turn on 64-bit file offset interface
# 		case "${CC}" in
# 			* )
# 				ac_cv_os_cflags="-D_LARGEFILE64_SOURCE"
# 				;;
# 		esac
# 		;;
# 	OFF-sunos4* )
# 		# make sure passing whole structures is handled in gcc
# 		case "${CC}" in
# 			gcc )
# 				ac_cv_os_cflags="-fpcc-struct-return"
# 				;;
# 		esac
# 		;;
	* )	ac_cv_os_cflags="" ;;
esac
])
CFLAGS="$CFLAGS $ac_cv_os_cflags"
])
dnl ======================================================================


dnl ######################################################################
dnl Specify additional cpp options based on the OS and the compiler
AC_DEFUN(AC_OS_CPPFLAGS,
[
AC_CACHE_CHECK(additional preprocessor flags,
ac_cv_os_cppflags,
[
case "${host_os}" in

# off for now, posix may be a broken thing for nextstep3...
#	nextstep* )
#		ac_cv_os_cppflags="-D_POSIX_SOURCE"
#		;;
	* )	ac_cv_os_cppflags="" ;;
esac
])
CPPFLAGS="$CPPFLAGS $ac_cv_os_cppflags"
])
dnl ======================================================================


dnl ######################################################################
dnl end of aclocal.m4 for fist-2.0
