/* loop.c
   Pass data between two sockets, with and without encryption
   Thanks to Matthew Ghio for most of the socket code. */

#include <netdb.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <termio.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>

void loop(int fd,int remotefd) {
  unsigned char c;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  struct termio tiostr;
  int r=1;
  int w=1;
  char buffer[1024];
  int o;

  fcntl(remotefd, O_NDELAY);
  fcntl(fd, O_NDELAY);

#ifdef ULTRIX
  ioctl(fd, TCGETA, &tiostr);
#else
  ioctl(fd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
  tiostr.c_cc[VINTR]=0;
  tiostr.c_cc[VQUIT]=0;
  tiostr.c_cc[VEOF]=0;
#ifdef ULTRIX
  ioctl(fd, TCSETA, &tiostr);
#else
  ioctl(fd, TCSETS, &tiostr);
#endif

#ifdef ULTRIX
  ioctl(remotefd, TCGETA, &tiostr);
#else
  ioctl(remotefd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
#ifdef ULTRIX
  ioctl(remotefd, TCSETA, &tiostr);
#else
  ioctl(remotefd, TCSETS, &tiostr);
#endif
  
  while(r!=0&&w!=0) {
    FD_ZERO(&writefds);
    FD_ZERO(&exceptfds);
    FD_ZERO(&readfds);
    FD_SET(fd, &readfds);
    FD_SET(remotefd, &readfds);
    FD_SET(fd, &exceptfds);
    FD_SET(remotefd, &exceptfds);        
    select(16, &readfds, &writefds, &exceptfds,(struct timeval *)0);
    if(FD_ISSET(fd,&readfds)) {
      w=read(fd,buffer,1024);if (w>0)
      {
        o=0;
        while(o<w) o+=write(remotefd,buffer+o,w-o);
      }
    }
    if(FD_ISSET(remotefd,&readfds)) {
      r=read(remotefd,buffer,1024);if (r>0)
      {
        o=0;
        while(o<r) o+=write(fd,buffer+o,r-o);
      }
    }
  }

  close(remotefd);
  close(fd);
  
}

#ifdef TESTLOOP
void main()
{
  register char *p;
  register char *ipaddr;
  register int x;
  int connection_ok;
  int remotefd;
  int fd;
  struct sockaddr_in remoteserver;
  
  remoteserver.sin_family = AF_INET;
  remoteserver.sin_port = htons(23);
  
  ipaddr = (char *)&remoteserver.sin_addr;
  *ipaddr++=127;
  *ipaddr++=0;
  *ipaddr++=0;
  *ipaddr++=1;

  remotefd = socket(AF_INET, SOCK_STREAM, 0);

  connection_ok = connect (remotefd, (struct sockaddr *)&remoteserver, sizeof(remoteserver));

  if (connection_ok < 0)
    {
      printf ("Connection Error\n");
      fflush (stdout);
      exit(1);
    }

  /* Okay, connection established. */

  fd=0; /* From stdin to remote */
  loop(fd,remotefd);
}
#endif

void desloop(int fd,int remotefd,unsigned char *key) {
  unsigned char c;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  struct termio tiostr;
  int r=1;
  int w=1;
  char buffer[1024];
  int o,a;

  unsigned char (*ks1)[8];
  unsigned char (*ks2)[8];
  unsigned char (*ks3)[8];
  static unsigned char inc1[8];
  static unsigned char inc2[8];
  static unsigned char inc3[8];
  static unsigned char iv0a[8];
  static unsigned char iv1a[8];
  static unsigned char iv2a[8];
  static unsigned char iv3a[8];
  static unsigned char iv0b[8];
  static unsigned char iv1b[8];
  static unsigned char iv2b[8];
  static unsigned char iv3b[8];
  char bytecount[2]={0,0};

  fcntl(remotefd, O_NDELAY);
  fcntl(fd, O_NDELAY);

#ifdef ULTRIX
  ioctl(fd, TCGETA, &tiostr);
#else
  ioctl(fd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
  tiostr.c_cc[VINTR]=0;
  tiostr.c_cc[VQUIT]=0;
  tiostr.c_cc[VEOF]=0;
#ifdef ULTRIX
  ioctl(fd, TCSETA, &tiostr);
#else
  ioctl(fd, TCSETS, &tiostr);
#endif

#ifdef ULTRIX
  ioctl(remotefd, TCGETA, &tiostr);
#else
  ioctl(remotefd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
#ifdef ULTRIX
  ioctl(remotefd, TCSETA, &tiostr);
#else
  ioctl(remotefd, TCSETS, &tiostr);
#endif

  ks1 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);
  ks2 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);
  ks3 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);

  desinit(1); /* No initial or final permutations */
  setkey(key+1000,ks1);
  setkey(key+1008,ks2);
  setkey(key+1016,ks3);
  bcopy(key+976,inc1,8);
  bcopy(key+984,inc2,8);
  bcopy(key+992,inc3,8);
  bcopy(key+968,iv0a,8);bcopy(key+968,iv0b,8);
  bcopy(key+960,iv1a,8);bcopy(key+960,iv1b,8);
  bcopy(key+952,iv2a,8);bcopy(key+952,iv2b,8);
  bcopy(key+944,iv3a,8);bcopy(key+944,iv3b,8);
  bzero(key,1024);

  while(r!=0&&w!=0) {
    FD_ZERO(&writefds);
    FD_ZERO(&exceptfds);
    FD_ZERO(&readfds);
    FD_SET(fd, &readfds);
    FD_SET(remotefd, &readfds);
    FD_SET(fd, &exceptfds);
    FD_SET(remotefd, &exceptfds);        
    select(16, &readfds, &writefds, &exceptfds,(struct timeval *)0);
    if(FD_ISSET(fd,&readfds)) {
      w=read(fd,buffer,1024);if (w>0)
      {
        for(a=0;a<w;a++) {
          bytecount[0]&=7;
          if (bytecount[0]==0) {
            do_tdes_block(ks1,ks2,ks3,iv0a,iv1a,iv2a,iv3a,inc1,inc2,inc3);
          }
          buffer[a]^=iv0a[bytecount[0]++];
        }
        o=0;
        while(o<w) o+=write(remotefd,buffer+o,w-o);
      }
    }
    if(FD_ISSET(remotefd,&readfds)) {
      r=read(remotefd,buffer,1024);if (r>0)
      {
        for(a=0;a<r;a++) {
          bytecount[1]&=7;
          if (bytecount[1]==0) {
            do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
          }
          buffer[a]^=iv0b[bytecount[1]++];
        }
        o=0;
        while(o<r) o+=write(fd,buffer+o,r-o);
      }
    }
  }

  close(remotefd);
  close(fd);

  free(ks1);free(ks2);free(ks3);
  desdone();
}


/* Exclusive-or one 8-byte block onto another */
bxor(unsigned char *a,unsigned char *b){
  a[0]^=b[0];a[1]^=b[1];a[2]^=b[2];a[3]^=b[3];
  a[4]^=b[4];a[5]^=b[5];a[6]^=b[6];a[7]^=b[7];
}

/* Sum two blocks for counter */
bsum(unsigned char *a,unsigned char *b){
  int c,d=0;
  for(c=8;c--;)
  {
    d+=a[c]+b[c];
    a[c]=d;
    d=d>>8;
  }
}

do_tdes_block(unsigned char **ks1,unsigned char **ks2,unsigned char **ks3,
unsigned char *iv,unsigned char *iv1,unsigned char *iv2,unsigned char *iv3,
unsigned char *inc1,unsigned char *inc2,unsigned char *inc3) {
    bsum(iv1,inc1);
    bsum(iv2,inc2);
    bsum(iv3,inc3);
    bxor(iv,iv1);
    endes(iv,ks1);
    bxor(iv,iv2);
    endes(iv,ks2);
    bxor(iv,iv3);
    endes(iv,ks3);
}
