/* opie_cfg.h: Various configuration-type pieces of information for OPIE.
               Or, at least, the common portion of it.

%%% portions-copyright-cmetz
Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified by cmetz for OPIE 2.3. Splatted with opie_auto.h.
	        Obseleted many symbols. Changed OPIE_PASS_{MIN,MAX} to
		OPIE_SECRET_{MIN,MAX}.
        Modified by cmetz for OPIE 2.2. Got rid of ANSIPROTO and ARGS.
                Got rid of TRUE and FALSE definitions. Moved UINT4 to
                opie.h and removed UINT2.
	Modified at NRL for OPIE 2.1. Fixed sigprocmask declaration.
		Gutted for autoconf. Split up for autoconf.
	Written at NRL for OPIE 2.0.

	History of opie_auto.h:

	Modified by cmetz for OPIE 2.22. Support the Solaris TTYPROMPT drain
		bamage on all systems -- it doesn't hurt others, and it's
		not something Autoconf can check for yet.
        Modified by cmetz for OPIE 2.2. Don't replace sigprocmask by ifdef.
                Added configure check for LS_COMMAND. Added setreuid/setgid
                band-aids.
        Modified at NRL for OPIE 2.2. Require /etc/shadow for Linux to use
                shadow passwords.
        Modified at NRL for OPIE 2.11. Removed version defines.
	Modified at NRL for OPIE 2.1. Fixed sigprocmask declaration.
		Gutted for autoconf. Split up for autoconf.
	Written at NRL for OPIE 2.0.
*/

#define VERSION "2.3 BETA 5 -- NOT FOR REDISTRIBUTION"
#define DATE    "Friday, August 23, 1996"

#ifndef unix
#define unix 1
#endif /* unix */

#include "config.h"
#include "options.h"

/* System characteristics */

#if HAVE_ETC_SECURETTY
#ifndef DOSECURETTY
#define DOSECURETTY 1
#endif /* DOSECURETTY */
#endif	/* HAVE_ETC_SECURETTY */

#if HAVE_GETUTXLINE
#ifndef DOUTMPX
#define DOUTMPX 1
#endif	/* DOUTMPX */
#define UTMPX utmpx
#else /* HAVE_GETUTXLINE */
#define UTMPX utmp
#endif /* HAVE_GETUTXLINE */

#if !HAVE_SETEUID && HAVE_SETRESUID
#define seteuid(x) setresuid(-1, x, -1)
#endif /* !HAVE_SETEUID && HAVE_SETRESUID */

#if !HAVE_SETEGID && HAVE_SETRESGID
#define setegid(x) setresgid(-1, x, -1)
#endif /* !HAVE_SETEGID && HAVE_SETRESGID */

/* Adapted from the Autoconf hypertext info pages */
#if HAVE_DIRENT_H
#include <dirent.h>
#else /* HAVE_DIRENT_H */
#define dirent direct
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif /* HAVE_SYS_NDIR_H */
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif /* HAVE_SYS_DIR_H */
#if HAVE_NDIR_H
#include <ndir.h>
#endif /* HAVE_NDIR_H */
#endif /* HAVE_DIRENT_H */

#if !HAVE_ATEXIT
#if HAVE_ON_EXIT
#define atexit on_exit
#else /* HAVE_ON_EXIT */
#define atexit(x)
#endif /* HAVE_ON_EXIT */
#endif /* !HAVE_ATEXIT */

#if !HAVE_STRCHR && HAVE_INDEX
#define strchr(s,c)    index((s),(c))
#endif /* !HAVE_STRCHR && HAVE_INDEX */

#if !HAVE_STRRCHR && HAVE_RINDEX
#define strrchr(s,c)    rindex((s),(c))
#endif /* !HAVE_STRRCHR && HAVE_RINDEX */

#if !HAVE_GETCWD && HAVE_GETWD
#define getcwd(buf,t)  getwd((buf))
#endif /* !HAVE_GETCWD && HAVE_GETWD */

#if !HAVE_SYSCONF && HAVE_GETDTABLESIZE
#define sysconf(_SC_OPEN_MAX) getdtablesize()
#endif /* !HAVE_SYSCONF && HAVE_GETDTABLESIZE */

/* BSDs sometimes don't print the group w/o -g */
#ifndef LS_COMMAND
#if HAVE_LS_G_FLAG
#define LS_COMMAND "/bin/ls -lgA"
#else /* HAVE_LS_G_FLAG */
#define LS_COMMAND "/bin/ls -lA"
#endif /* HAVE_LS_G_FLAG */
#endif	/* LS_COMAND */

#ifndef MAIL_DIR
#ifdef PATH_MAIL
#define MAIL_DIR PATH_MAIL
#else /* PATH_MAIL */
#ifdef _PATH_MAIL
#define MAIL_DIR _PATH_MAIL
#else /* _PATH_MAIL */
#ifdef _PATH_MAILDIR
#define MAIL_DIR _PATH_MAILDIR
#else /* _PATH_MAILDIR */
#define MAIL_DIR "/usr/spool/mail"
#endif /* _PATH_MAILDIR */
#endif /* _PATH_MAIL */
#endif /* PATH_MAIL */
#endif /* MAIL_DIR */

#if !defined(sigmask) && !HAVE_SIGMASK && !HAVE_SIGMASK_MACRO
/* sigmask() is a handy BSD macro that is not POSIX or SYSV */
#define sigmask(m)   (1 << ((m)-1))
#endif

/* Not sure how I'll do this yet... */
#define HAVETTYSLOT 0
#if 0
#ifndef HAVETTYSLOT
#ifdef IS_A_BSD
#define HAVETTYSLOT 1	/* BSD man pages say it appeared in V7 */
#endif	/* IS_A_BSD */
#ifdef IS_A_SYSV
#define HAVETTYSLOT 0	/* But some System Vs appear to have "fixed" it */
#endif	/* IS_A_SYSV */
#endif	/* HAVETTYSLOT */
#endif /* 0 */

#if HAVE_SHADOW_H && HAVE_GETSPENT && HAVE_ENDSPENT
#define HAVE_SHADOW 1
#if defined(linux) && !HAVE_ETC_SHADOW 
#undef HAVE_SHADOW
#define HAVE_SHADOW 0
#endif /* defined(linux) && !HAVE_ETC_SHADOW */
#endif /* HAVE_SHADOW_H && HAVE_GETSPENT && HAVE_ENDSPENT */

#if !HAVE_SETEUID && HAVE_SETREUID
#define seteuid(x) setreuid(-1, x)
#endif /* !HAVE_SETEUID && HAVE_SETREUID */

#if !HAVE_SETEGID && HAVE_SETREGID
#define setegid(x) setregid(-1, x)
#endif /* !HAVE_SETEGID && HAVE_SETREGID */

/* If the user didn't specify, default to MD5 */
#ifndef MDX
#define MDX 5
#endif	/* MDX */

#ifndef DOUTMPX
#define DOUTMPX 0
#endif	/* DOUTMPX */

#ifndef UTMPX
#if DOUTMPX
#define UTMPX utmpx
#else	/* DOUTMPX */
#define UTMPX utmp
#endif	/* DOUTMPX */
#endif /* UTMPX */

#ifndef _PATH_BSHELL
#define _PATH_BSHELL    "/bin/sh"
#endif

#ifndef _PATH_DEVNULL
#define _PATH_DEVNULL	  "/dev/null"
#endif

#ifndef _PATH_FTPUSERS
#define	_PATH_FTPUSERS	"/etc/ftpusers"
#endif

#ifndef TTYGRPNAME
#define TTYGRPNAME	"tty"	/* name of group to own ttys */
#endif

#ifndef NO_LOGINS_FILE
#define NO_LOGINS_FILE	"/etc/nologin"
#endif

#ifndef QUIET_LOGIN_FILE
#define QUIET_LOGIN_FILE  ".hushlogin"
#endif

#ifndef OPIE_ALWAYS_FILE
#define OPIE_ALWAYS_FILE ".opiealways"
#endif

#ifndef OPIE_LOCK_PREFIX
#define OPIE_LOCK_PREFIX "/tmp/opie-lock."
#endif

#ifndef OPIE_LOCK_TIMEOUT
#define OPIE_LOCK_TIMEOUT (30*60)
#endif

#ifndef KEY_FILE
#define KEY_FILE          "/etc/opiekeys"
#endif

#ifndef EXT_KEY_FILE
#define EXT_KEY_FILE      "/etc/opiekeys2"
#endif /* EXT_KEY_FILE */

#ifndef MOTD_FILE
#define MOTD_FILE         "/etc/motd"
#endif

#ifndef SECURETTY
#define SECURETTY         "/etc/securetty"
#endif	/* SECURETTY */

#ifndef NBBY
#define NBBY 8	/* Reasonable for modern systems */
#endif	/* NBBY */

#ifndef LOGIN_PATH
#define LOGIN_PATH "/usr/ucb:/bin:/usr/bin"
#endif	/* LOGIN_PATH */

#ifndef DOANONYMOUS
#define DOANONYMOUS 0
#endif	/* DOANONYMOUS */

#ifndef POINTER
#define POINTER unsigned char *
#endif /* POINTER */

#define _OPIE 1
