/* parsechallenge.c: The _opieparsechallenge() library function.

%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

        History:

	Created by cmetz for OPIE 2.3 using generator.c as a guide.
*/

#include "opie_cfg.h"
#if HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#include "opie.h"

struct algorithm {
  char *name;
  int num;
};

static struct algorithm algorithms[] = {
  { "md5", 5 },
  { "md4", 4 },
#if 0
  { "sha", 3 },
#endif /* 0 */
  { NULL, 0 },
};

int _opieparsechallenge FUNCTION((buffer, algorithm, sequence, seed), char *buffer AND int *algorithm AND int *sequence AND char **seed)
{
  char *c;

  if (!(c = strchr(buffer, ' ')))
    return 1;

  *(c++) = 0;

  {
    struct algorithm *a;

    for (a = algorithms; a->name && strcmp(buffer, a->name); a++);
    if (!a->name)
      return -1;

    *algorithm = a->num;
  }

  buffer = c;

  if (!(c = strchr(buffer, ' ')))
    return -1;

  *(c++) = 0;

  if (!(*sequence = atoi(buffer)))
    return -1;

  buffer = c;

  if (c = strchr(buffer, ' '))
    *c = 0;

  if (c = strchr(buffer, '\n'))
    *c = 0;

  *seed = buffer;

  return 0;
}
