/* opie_cfg.h: Various configuration-type pieces of information for OPIE.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Written at NRL for OPIE 2.0.
*/
#define VERSION "2.02 Release"
#define DATE    "Friday, August 11, 1995"

/* ----------------------------------------------------------------------
   SunOS 4.1.x has a file <paths.h> with many of these appropriate defined.
   Other systems don't have any such file.  This file sets up "reasonable"
   default guesses for these files and structure names.

   For best results, include this header AFTER all of the system header
   files.

   You should edit the SYSTEM_DEFINES line in the supplied Makefile to
   define these as appropriate for your system.  If the symbols are defined on
   the command-line via the Makefile, those command-line definitions should
   override these definitions because we've protected our guesses with
   "#ifndef" in front.

       rja
----------------------------------------------------------------------*/

#ifdef SOLARIS
#ifndef SVR4
#define SVR4 1
#endif	/* SVR4 */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#ifndef DOUTMPX
#define DOUTMPX 1
#endif	/* DOUTMPX */
#endif	/* SOLARIS */

#ifdef HPUX
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#define seteuid(x) setresuid(-1, x, -1)
#define setegid(x) setresgid(-1, x, -1)
#ifndef _PATH_WTMP
#define _PATH_WTMP "/etc/wtmp"
#endif	/* _PATH_WTMP */
#ifndef DOSECURETTY
#define DOSECURETTY 1
#endif	/* DOSECURETTY */
#endif	/* HPUX */

#ifdef SUNOS
#ifndef BSD4_3
#define BSD4_3 1
#endif	/* BSD4_3 */
#ifndef HAVE_DIRENT
#define HAVE_DIRENT 1
#endif	/* HAVE_DIRENT */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#ifndef NEED_STRERROR
#define NEED_STRERROR 1
#endif	/* NEED_STRERROR */
#define atexit on_exit
#endif	/* SUNOS */

/* SVR4 -> IS_A_SYSV */
#ifdef SVR4
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#endif	/* SVR4 */

/* BSD4_3 -> OPIE_BSD */
#ifdef BSD4_3
#ifndef IS_A_BSD
#define IS_A_BSD 1
#endif	/* IS_A_BSD */
#endif	/* BSD4_3 */

#if !defined(SYSV) && !defined(IS_A_SYSV) && defined(BSD)
#ifndef IS_A_BSD
#define IS_A_BSD 1
#endif	/* IS_A_BSD */
#endif	/* !defined(SYSV) && !defined(IS_A_SYSV) && defined(BSD) */

#if !defined(BSD) && !defined(IS_A_BSD) && defined(SYSV)
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#endif	/* !defined(BSD) && !defined(IS_A_BSD) && defined(SYSV) */

#if defined(IS_A_BSD) && defined(IS_A_SYSV)
You cannot be both IS_A_BSD and IS_A_SYSV at the same time.
#endif	/* defined(IS_A_BSD) && defined(IS_A_SYSV) */

#if !defined(IS_A_BSD) && !defined(IS_A_SYSV)
     You must specify the kind of system you are on(See the Makefile).
#endif	/* !defined(IS_A_BSD) && !defined(IS_A_SYSV) */

/* If the user didn't specify, default to MD5 */
#ifndef MDX
#define MDX 5
#endif	/* MDX */

/* If the user didn't specify, figure out what file to use for perm setting */
#ifndef PERMSFILE
#if defined(SOLARIS) || defined(linux)
#define PERMSFILE "/etc/logindevperm"
#endif	/* SOLARIS */
#ifdef SUNOS
#define PERMSFILE "/etc/fbtab"
#endif	/* SUNOS */
/* Otherwise, leave out PERMSFILE support (can we say BLOAT?) */
#endif	/* PERMSFILE */

#ifdef IS_A_BSD
 /* backwards compatibility for older BSD systems */
#ifndef COMPAT_43
#define COMPAT_43 1
#endif	/* COMPAT_43 */
#ifndef USE_OLD_TTY
#define USE_OLD_TTY 1
#endif	/* USE_OLD_TTY */
#ifdef NEED_STRING
#ifndef strchr
#define strchr(s,c)    index((s),(c))
#endif
#ifndef strrchr
#define strrchr(s,c)   rindex((s),(c))
#endif
#endif /* NEED_STRING */
#ifndef SUNOS /* These really shouldn't need to be defined for any system
                 that is reasonably POSIX... */
#ifndef getcwd
#define getcwd(buf,t)  getwd((buf))
#endif
#ifndef sigsuspend
#define sigsuspend(mask)   sigpause(mask)
#endif
#ifndef sigprocmask
#define sigprocmask(how,set,oset) (((how) == SIG_BLOCK) ? sigblock((set)) : \
							sigsetmask((set)))
#endif
#endif /* !SUNOS */
#ifndef sysconf
 /* sysconf first appeared in POSIX */
#define sysconf(_SC_OPEN_MAX)        getdtablesize()
#endif
 /* BSDs sometimes don't print the group w/o -g */
#ifndef LS_COMMAND
#define LS_COMMAND "/bin/ls -lgA"
#endif	/* LS_COMAND */

 /* BSD traditionally keeps incoming mail in /usr/spool/mail */
#define MAIL_DIR          "/usr/spool/mail/"
#endif

#ifdef IS_A_SYSV
/* All modern SYSV systems have the dirent directory entry structure */
#ifndef HAVE_DIRENT
#define HAVE_DIRENT 1
#endif	/* HAVE_DIRENT */
/* SYSV traditionally keeps incoming mail in /usr/mail */
#ifndef MAIL_DIR
#define MAIL_DIR       "/usr/mail/"
#endif	/* MAIL_DIR */
#ifndef sigmask
/* sigmask() is a handy BSD macro that is not POSIX or SYSV */
#define sigmask(m)   (1 << ((m)-1))
#endif
#ifndef vfork
#define vfork fork	/* System Vs generally don't do vfork */
#endif

 /* SysVs sometimes don't print the owner w/ -g */
#ifndef LS_COMMAND
#define LS_COMMAND "/bin/ls -lA"
#endif	/* LS_COMAND */

#endif

#ifndef DOUTMPX
#define DOUTMPX 0
#endif	/* DOUTMPX */

#if DOUTMPX
#define UTMPX utmpx
#else	/* DOUTMPX */
#define UTMPX utmp
#endif	/* DOUTMPX */

#ifndef HAVETTYSLOT
#ifdef IS_A_BSD
#define HAVETTYSLOT 1	/* BSD man pages say it appeared in V7 */
#endif	/* IS_A_BSD */
#ifdef IS_A_SYSV
#define HAVETTYSLOT 0	/* But some System Vs appear to have "fixed" it */
#endif	/* IS_A_SYSV */
#endif	/* HAVETTYSLOT */

#define	FALSE	0
#define	TRUE	-1

#ifndef _PATH_BSHELL
#define _PATH_BSHELL    "/bin/sh"
#endif

#ifndef _PATH_DEVNULL
#define _PATH_DEVNULL	  "/dev/null"
#endif

#ifndef _PATH_FTPUSERS
#define	_PATH_FTPUSERS	"/etc/ftpusers"
#endif

#ifndef TTYGRPNAME
#define TTYGRPNAME	"tty"	/* name of group to own ttys */
#endif

#ifndef NO_LOGINS_FILE
#define NO_LOGINS_FILE	"/etc/nologin"
#endif

#ifndef QUIET_LOGIN_FILE
#define QUIET_LOGIN_FILE  ".hushlogin"
#endif

#ifndef OPIE_ALWAYS_FILE
#define OPIE_ALWAYS_FILE ".opiealways"
#endif

#ifndef OPIE_LOCK_PREFIX
#define OPIE_LOCK_PREFIX "/tmp/opie-lock."
#endif

#ifndef OPIE_LOCK_TIMEOUT
#define OPIE_LOCK_TIMEOUT (30*60)
#endif

#ifndef KEY_FILE
#define KEY_FILE          "/etc/opiekeys"
#endif

#ifndef MOTD_FILE
#define MOTD_FILE         "/etc/motd"
#endif

#ifndef SECURETTY
#define SECURETTY         "/etc/securetty"
#endif	/* SECURETTY */

#if     defined(__TURBOC__) || defined(__STDC__) || defined(LATTICE)
#define ANSIPROTO       1
#endif

#ifndef __ARGS
#ifdef  ANSIPROTO
#define __ARGS(x)       x
#else
#define __ARGS(x)       ()
#endif
#endif

#ifndef NBBY
#define NBBY 8	/* Reasonable for modern systems */
#endif	/* NBBY */

#ifndef DOMOTD
#define DOMOTD 1
#endif	/* DOMOTD */

#ifndef LOGIN_PATH
#define LOGIN_PATH "/usr/ucb:/bin:/usr/bin"
#endif	/* LOGIN_PATH */

#ifndef DOANONYMOUS
#define DOANONYMOUS 0
#endif	/* DOANONYMOUS */

#if NEED_ATEXIT
#define atexit(x)
#endif	/* NEED_ATEXIT */
