#ifndef _DESLOGIN_H
#define _DESLOGIN_H

/*
 * The protocol version is sent by the daemon, and used by the client to
 * ensure that the correct handshaking is performed.  This allows the
 * protocol to be extened in the future.  
 */
#define PROTOCOL_VERS		"1.00"	/* version of protcol */
#define VERS_SIZE		16	/* max chars of version string + 1 */

#ifndef SETUP_TIMEOUT
#define	SETUP_TIMEOUT		30000	/* ms for login sequence handshakes */
#endif
#ifndef LOGIN_TIMEOUT
#define LOGIN_TIMEOUT		30	/* login timeout (sec) */
#endif
#ifndef INACTIVITY_TIMEOUT
#define INACTIVITY_TIMEOUT	1200	/* inactivity timeout (sec) */
#endif					/* Should be short for security */
#ifndef DESLOGIN_PORT
#define DESLOGIN_PORT		3005	/* port for /etc/services */
#endif
#ifndef DESLOGIN_GW_PORT
#define DESLOGIN_GW_PORT	3006	/* default gateway for deslogingw */
#endif
#ifndef DLPASSWD_PORT
#define DLPASSWD_PORT 		3007  	/* default change password port */
#endif
#ifndef SERVICE_NAME
#define SERVICE_NAME		"deslogin" /* default name for /etc/services */
#endif
#ifndef GW_SERVICE_NAME
#define GW_SERVICE_NAME		"deslogingw"
#endif
#ifndef PW_SERVICE_NAME
#define PW_SERVICE_NAME		"dlpasswd"
#endif
#ifndef LOGIN_PROG
/* 
 * Login is in /bin on most machines I can find.
 *   (SunOs 4.1, DEC OSF1, DEC MIPS, HP-UX)
 */
#define	LOGIN_PROG		"/bin/login"	/* login program for -w opt */
#endif

#define PHRASE_SIZE		255	/* maximum length of a passphrase+1 */

#if !defined(ERRMSG) /* { */
#if (!defined(sparc) && !defined(sun3)) || defined(__SOLARIS__) /* { ANSI */
#define	ERRMSG	strerror(errno)	
#else  /* } { strerror missing on SunOS 4.1.3_U1 */
#define ERRMSG	sys_errlist[errno] 

extern char 	*sys_errlist[];
#endif /* } */
#endif /* } */

extern int  	 errno;

extern char 	*progName;
extern int	debug;
extern int	verbose;

#if defined(__STDC__) || defined(__cplusplus)
/*
 * Defined in <stdlib.h> but only if _AES_SOURCE is #defined, which
 * requires _XOPEN_SOURCE also.  I don't want to import other symbols.
 */
#if defined(__cplusplus)
extern "C" {
#endif
#if 0
#ifndef __GNUC__	/* gnu declares getopt in stdlib.h with no const */
int getopt(int, char * const [], const char *);
#endif
#endif
#if defined(__cplusplus)
}
#endif
#else
extern int getopt();
#endif

#if (defined(sparc) || defined(sun3)) && !defined(__SOLARIS__)
/*
 * Unfortunately, the SunOS 4.1.1 does not have atexit.  This is a kludge to
 * provide that functionality on the suns using a sun-specific library call.
 */
#define atexit	on_exit
#endif

#endif
