/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/**************************************************************

	aux conversion utilities

	for the sake of efficiency, watch for certain machine
	dependencies relying on the bit/byte ordering of (int)
	in case of vax

	created: 01.3.91	rdn

**************************************************************/
#ifdef MAC
#include <stdlib.h>
#endif /* MAC */

#include "secure.h"
#ifdef TEST
#include <stdio.h>
#endif

#define APCONV

#define rfcval(x)	(rfctable[ascii(x)])
#define hexval(x)	(hextable[ascii(x)])

#ifndef EBCDIC
#define ascii(x)	((x)&0x7f)
#else
extern ascii();
#endif

#ifndef vax
typedef union {
	struct {
		unsigned int	c0:6, c1:6, c2:6, c3:6;
	}	 c;
	char	C[3];
}       MAP3;

typedef union {
	struct {
		unsigned int	c0:4, c1:4;
	}	 c;
	char	C0;
}       MAP2;
#endif


static OctetString * newocts(size)
int	size;
{
	OctetString * result;
	char	    * proc = "newocts";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif


	if ( !(result = (OctetString * )calloc(1, sizeof(OctetString))) )	
		return (NULLOCTETSTRING);
	result->noctets = size;
	result->octets = (char *)malloc(size);

	if (!result->octets) 
		free(result), result = NULLOCTETSTRING;

	return result;
}


static void
maptorfc(in, out, len)
char	*in, *out;
int	len;
{
	static rfctable[64] = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
		'U', 'V', 'W', 'X', 'Y', 'Z',
		'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
		'u', 'v', 'w', 'x', 'y', 'z',
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
		'+', '/' 	};

	MAP3	s;
	int	tri;

	for (tri = len; tri >= 3; tri -= 3) {
		s.C[0] = *in++;
		s.C[1] = *in++;
		s.C[2] = *in++;
		*out++ = rfctable[s.c.c0];
		*out++ = rfctable[s.c.c1];
		*out++ = rfctable[s.c.c2];
		*out++ = rfctable[s.c.c3];
	}
	switch (tri) {
	case 1:	
		s.C[0] = *in++;
		s.C[1] = 0;
		*out++ = rfctable[s.c.c0];
		*out++ = rfctable[s.c.c1];
		*out++ = '=';
		*out++ = '=';
		break;

	case 2: 
		s.C[0] = *in++;
		s.C[1] = *in++;
		s.C[2] = 0;
		*out++ = rfctable[s.c.c0];
		*out++ = rfctable[s.c.c1];
		*out++ = rfctable[s.c.c2];
		*out++ = '=';
		break;

	default: 
		break;
	}
	return;
}


static void
maprfc( in, out, len)
char*	in;
char*	out;
int	len;
{
	static rfctable[128] = {
		/*	x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 10 11 12 13 14 15		*/
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 00 .. 0F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 10 .. 1F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 	/* 20 .. 2F */
		52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, 	/* 30 .. 3F */
		-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 	/* 40 .. 4F */
		15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, 	/* 50 .. 5F */
		-1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 	/* 60 .. 6F */
		41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, 	/* 70 .. 7F */
	};
	MAP3	s;
	int	quattro;

	for ( quattro = len; quattro >= 4; quattro -= 4) {
		s.c.c0 = rfcval( *in++);
		s.c.c1 = rfcval( *in++);
		s.c.c2 = rfcval( *in++);
		s.c.c3 = rfcval( *in++);
		*out++ = s.C[0];
		*out++ = s.C[1];
		*out++ = s.C[2];
	}

	switch ( quattro ) {
	case 1:	/* decoding error */
		break;
	case 2:
		s.c.c0 = rfcval( *in++);
		s.c.c1 = rfcval( *in++);
		*out++ = s.C[0];
		break;
	case 3:
		s.c.c0 = rfcval( *in++);
		s.c.c1 = rfcval( *in++);
		s.c.c2 = rfcval( *in++);
		*out++ = s.C[0];
		*out++ = s.C[1];
		break;
	default:
		break;
	}
}


static void
maptohex( in, out, len )
char*	in;
char*	out;
int	len;
{
	static hextable[16] = {
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
		'A', 'B', 'C', 'D', 'E', 'F',
	};
	MAP2	s;
	int	bi;

	for (bi = len; bi > 0; bi--) {
		s.C0 = *in++;
		*out++ = hextable[s.c.c0];
		*out++ = hextable[s.c.c1];
	}
	return;
}


static void
maphex( in, out, len )
char*	in;
char*	out;
int	len;
{
	static hextable[128] = {
		/*	x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 10 11 12 13 14 15		*/
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 00 .. 0F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 10 .. 1F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 20 .. 2F */
		0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, 	/* 30 .. 3F */
		-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 40 .. 4F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 50 .. 5F */
		-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 60 .. 6F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 70 .. 7F */
	};
	MAP2	s;
	int	bi;

	for (bi = len; bi >= 2; bi -= 2) {
		s.c.c0 = hexval( *in++);
		s.c.c1 = hexval( *in++);
		*out++ = s.C0;
	}
	if (bi) {
		s.c.c0 = hexval( *in++);
		s.c.c1 = 0;
		*out++ = s.C0;
	}
	return;
}


#ifdef APCONV

static void
maptoap( in, out, len )
char*	in;
char*	out;
int	len;
{
	static aptable[16] = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
	};
	MAP2	s;
	int	bi;

	for (bi = len; bi > 0; bi--) {
		s.C0 = *in++;
		*out++ = aptable[s.c.c0];
		*out++ = aptable[s.c.c1];
	}
	return;
}


static char	
apval(x)
int	x;
{
	char	c = ascii(x);

	if (('A' <= c) && (c <= 'P') )	
		return c - 'A';
	if (('a' <= c) && (c <= 'p') )	
		return c - 'a';
	return - 1;
}


static void
mapap( in, out, len )
char*	in;
char*	out;
int	len;
{
	MAP2	s;
	int	bi;

	for (bi = len; bi >= 2; bi -= 2) {
		s.c.c0 = apval( *in++);
		s.c.c1 = apval( *in++);
		*out++ = s.C0;
	}
	if (bi) {
		s.c.c0 = apval( *in++);
		s.c.c1 = 0;
		*out++ = s.C0;
	}
	return;
}


#endif


/**************************** external **************************/

OctetString
*aux_encrfc(), *aux_decrfc(), *aux_enchex(), *aux_dechex();

#ifdef APCONV
OctetString *aux_encap(), *aux_decap();
#endif


OctetString * aux_encrfc( in )
OctetString * in;
{
	OctetString * v;
	int	      vlen;
	char	    * proc = "aux_encrfc";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	vlen = (in->noctets + 2) / 3 * 4;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptorfc( in->octets, v->octets, in->noctets );
	return v;
}


OctetString*aux_decrfc( in )
OctetString*	in;
{
	OctetString * 	v;
	int	vlen, l;
	extern char	*strrchr();
	char	*proc = "aux_decrfc";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	if ((vlen = in->noctets & 0x03)) {	/* assume padding stripped */
		vlen += in->noctets / 4 * 3 - 1;
		l = in->noctets;
	} else {
		vlen = in->noctets / 4 * 3;
		l = in->noctets;
		if (in->octets[in->noctets-1] == '=') {
			vlen--;
			l--;
			if (in->octets[in->noctets-2] == '=')
				vlen--, l--;
		}
	}
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maprfc( in->octets, v->octets, l );
	return v;
}


OctetString*aux_enchex( in )
OctetString*	in;
{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_enchex";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = in->noctets * 2;
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptohex( in->octets, v->octets, in->noctets );
	return v;
}


OctetString*aux_dechex( in )
OctetString*	in;
{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_dechex";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = (in->noctets + 1) / 2;
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maphex( in->octets, v->octets, in->noctets );
	return v;
}

OctetString*aux_encap( in )
OctetString*	in;
{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_encap";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = in->noctets * 2;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptoap( in->octets, v->octets, in->noctets );
	return v;
}


OctetString*aux_decap( in )
OctetString*	in;
{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_decap";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = (in->noctets + 1) / 2;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	mapap( in->octets, v->octets, in->noctets );
	return v;
}
