-----BEGIN PGP SIGNED MESSAGE-----

		     Phil's Pretty Good Software
			       presenta

				 ===
				 PGP
				 ===

			 Pretty Good Privacy
			Intimidad Bastante Buena
		 Cifrado de clave pblica para todos


		      --------------------------
			Gua del Usuario de PGP
		      Volumen II: Temas especiales
		      ----------------------------
			 por Philip Zimmermann
		   Revisado el 14 de junio de 1993


		   PGP Versin 2.3 - 13 junio 93
			 Programa escrito por
			  Philip Zimmermann
				 con
	    Branko Lankester, Hal Finney y Peter Gutmann




Sinopsis:  PGP utiliza criptografa de clave pblica para proteger el
correo electrnico y los ficheros de datos.  Comunquese con seguridad
con personas a las que nunca ha visto, sin necesidad de tener canales
seguros para intercambiar claves.  PGP es rpido y tiene muchas
prestaciones, que incluyen una completa gestin de claves, firmas
digitales, compresin de datos y un buen diseo ergonmico.


Programa y documentacin (c) Copyright 1990-1993 Philip Zimmermann.
Para mayor informacin sobre licencias, distribucin, copyright,
patentes, marcas registradas, limitaciones de responsabilidad y
controles de exportacin de PGP, vase la seccin "Consideraciones
legales".

( indica que hay una nota del traductor en el fichero NOTAS.TRA)


Indice
======

Descripcin general
Temas especiales
  Eleccin de claves por su propio identificador
  Separacin de las firmas de los mensajes
  Desencriptacin del mensaje dejando la firma
  Envo de ficheros de texto ASCII entre distintos entornos
  Eliminacin de los restos del texto normal en el disco
  Visualizacin del texto descifrado en la pantalla
  Cmo hacer un mensaje "Slo para sus ojos"
  Conservacin del nombre original del fichero de texto normal
  Modificacin del identificador de usuario o de la frase de contrasea
  Modificacin de los parmetros de confianza de una clave pblica
  Comprobacin de que todo est bien en el fichero de claves pblicas
  Verificacin de una clave pblica por telfono
  Utilizacin de PGP como un filtro UNIX
  Supresin de las preguntas innecesarias:  BATCHMODE
  Respuesta "S" obligada a las preguntas de confirmacin:  FORCE
  PGP devuelve a la coraza ("shell") el estado de salida
  Variable de entorno para la frase de contrasea
  Establecimiento de los parmetros de configuracin: CONFIG.TXT
    TMP - Trayectoria para ficheros temporales
    LANGUAGE - Eleccin del idioma
    MYNAME - Identificador de usuario por omisin para firmar
    TEXTMODE - Asumir que el texto normal es un fichero de texto
    CHARSET - Indica el conjunto local de caracteres
    ARMOR - Activa la salida con armadura ASCII
    ARMORLINES - Tamao de ficheros por partes con armadura ASCII
    KEEPBINARY- Conservar ficheros cifrados binarios tras desencriptar
    COMPRESS - Activar compresin
    COMPLETES_NEEDED - Referencias completamente fiables necesarias
    MARGINALS_NEEDED - Referencias relativamente fiables necesarias
    CERT_DEPTH - Profundidad de anidamiento de referencias
    BAKRING - Nombre de la copia de seguridad del fichero secreto
    PAGER - Elegir la orden de coraza para mostrar texto normal
    SHOWPASS - Mostrar al usuario la frase de contrasea
    TZFIX - Ajuste de zona horaria
    CLEARSIG - Activar Mensajes firmados encapsulados como texto normal
    VERBOSE - Mensajes normales, verbosos o sin mensajes
    INTERACTIVE - Pedir confirmacin para aadir claves
  Proteccin contra falsos sellos de hora
  Una mirada en el interior
    Nmeros aleatorios
    Algoritmo de cifrado convencional de PGP
    Compresin de datos
    Resmenes de mensajes y firmas digitales
  Compatibilidad con las versiones anteriores de PGP
Puntos vulnerables
  Compromiso de la frase de contrasea y de la clave secreta
  Manipulacin de claves pblicas
  Ficheros "no borrados del todo"
  Virus y caballos de Troya
  Fallos en la seguridad fsica
  Ataques Tempest
  Exposicin en sistemas multiusuario
  Anlisis de trfico
  Criptoanlisis
Consideraciones legales
  Marcas registradas, copyrights y garantas.
  Derechos de patente sobre los algoritmos
  Licencias y distribucin
  Controles de exportacin
Grupos polticos relacionados con los ordenadores
Lecturas recomendadas
Cmo ponerse en contacto con el autor
Apndice A:  Dnde obtener PGP


Descripcin general
===================

Pretty Good(mr) Privacy (PGP), "intimidad bastante buena", de Phil's
Pretty Good Software, es una aplicacin informtica de criptografa de
alta seguridad en DOS, Unix, VAX/VMS y otros ordenadores. PGP combina la
comodidad del criptosistema de clave pblica de Rivest-Shamir-Adleman
(RSA) con la velocidad de la criptografa convencional, resmenes de
mensajes para firmas digitales, compresin de datos antes de encriptar,
un buen diseo ergonmico y con una completa gestin de claves.

El volumen II de la Gua del usuario trata aquellos temas avanzados que
no se incluan en el volumen I, "Temas esenciales". Debera leer antes
ese primer volumen, o este no le resultar muy comprensible. La lectura
de este volumen II es opcional.


Temas especiales
================

Eleccin de claves por su propio identificador
=---------------------------------------------

En todas las rdenes que permiten escribir un identificador de usuario o
un fragmento para elegir una clave, puede utilizarse su identificador
hexadecimal. Slo tiene que indicar ese identificador, con el prefijo
"0x", en lugar del identificador de usuario.
Por ejemplo:

     pgp -kv 0x67F7

Muestra todas las claves que tienen 67F7 como parte de su identificador.

Esta caracterstica resulta particularmente til si tiene dos claves
diferentes de la misma persona, con un mismo identificador de usuario.
Puede elegir la clave, sin ambigedad, especificando el identificador de
clave.


Separacin de las firmas de los mensajes
=---------------------------------------

Normalmente, los certificados de firma se aaden fsicamente al texto al
que se refieren. Resulta cmodo comprobarlas de esa manera en los casos
sencillos. Bajo ciertas circunstancias, resulta ms conveniente tener
los certificados aparte del mensaje que firman. Se pueden generar
certificados separados del texto. Para ello, combine la opcin 'b'
(break {romper}) con la opcin 's' (sign {firmar}). Por ejemplo:

     pgp -sb carta.txt

Se produce un certificado aislado, en un fichero llamado "carta.sig". El
contenido de carta.txt no se aade al certificado.

Despus de crear el fichero del certificado de firma (carta.sig en el
ejemplo anterior), enveselo al destinatario junto con el fichero de
texto. El destinatario debe tener los dos ficheros para poder comprobar
la integridad de la firma. Cuando intente procesar el fichero de firma,
PGP se dar cuenta de que no hay texto en el fichero, y pedir un
nombre. Slo as podr comprobar PGP la integridad de la firma. Si el
destinatario sabe con anterioridad que la firma est separada del texto,
puede indicar los dos nombres en la lnea de rdenes:

     pgp carta.sig carta.txt
o:   pgp carta carta.txt

En este caso, PGP no tiene que pedir el nombre del texto.

Los certificados separados sirven para mantenerlo en un registro aparte.
La firma separada de un programa ejecutable podra servir para detectar
una infeccin por virus. Tambin resulta conveniente si varias partes
deben firmar un documento, tal como un contrato legal, sin necesidad de
anidar las firmas. Todas ellas son independientes.

Si recibe un fichero de texto cifrado con certificado de firma, puede
separarlo durante la desencriptacin. Se hace con la opcin -b en el
descifrado, como en:

     pgp -b carta

Se desencripta el fichero carta.pgp, y, si hay alguna firma en l, PGP
la comprueba y la separa del resto del mensaje, almacenndola en el
fichero carta.sig.


Desencriptacin del mensaje dejando la firma
=-------------------------------------------

Normalmente, usted querr que PGP desenmarae completamente el texto
cifrado, desencriptndolo y comprobando la firma anidada si existe,
pelando las capas hasta que slo quede el fichero original en texto
normal.

Sin embargo, quiz quiera algunas veces desencriptar el fichero dejando
la firma dentro, de forma que quede el fichero descifrado y firmado.
Puede resultar conveniente para enviar la copia firmada de un documento
a una tercera persona, quiz volvindolo a cifrar. Por ejemplo, suponga
que recibe un mensaje firmado por Charlie, cifrado para usted. Querr
desencriptarlo, y, dejando en l la firma de Charlie, envirselo a
Alice, quiz volvindolo a cifrar con la clave pblica de Alice. No hay
problema. PGP puede hacerlo.

Para desencriptar solamente el mensaje, dejando la firma intacta,
escriba:

     pgp -d carta

As se desencripta carta.pgp, y, si hay una firma dentro, se deja
intacta en el fichero de salida junto al texto normal descifrado.

Entonces puede archivarla, o volverla a encriptar y envirsela a
alguien.


Envo de ficheros de texto ASCII entre distintos entornos
=--------------------------------------------------------

Puede utilizar PGP para encriptar cualquier tipo de fichero normal, ya
contenga datos de 8 bits o texto ASCII. Probablemente, el uso ms
habitual de PGP ser para correo-E, donde el texto normal es ASCII.

El texto ASCII se representa de forma diferente en distintos entornos.
Por ejemplo, en DOS todas las lneas acaban en un retorno de carro
seguido de un salto de lnea. En UNIX, todas las lneas terminan slo
con un salto de lnea. En Macintosh, las lneas terminan slo con un
retorno de carro. Es una triste realidad.

Los mensajes en texto ASCII se traducen muchas veces automticamente a
una forma "cannica" comn cuando se transmiten de una mquina a otra.
El texto cannico tiene un retorno de carro y un salto de lnea al final
de cada lnea de texto. Por ejemplo, el conocido protocolo de
comunicaciones KERMIT puede convertir el texto a forma cannica cuando
lo transmite a otro sistema. El KERMIT que recibe convierte las
terminaciones de lnea a la forma local. As resulta ms fcil compartir
ficheros de texto entre diferentes sistemas.

El protocolo de comunicaciones no puede convertir automticamente el
texto cifrado, ya que el original queda oculto durante el encriptado.
Para solucionar esta incomodidad, PGP le permite indicar que hay que
tratar el texto normal como ASCII (no como datos binarios), y que debe
convertirse en texto cannico antes de encriptar. En el lado receptor,
el texto normal descifrado vuelve a convertirse automticamente a la
forma apropiada para el entorno local.

Para hacer que PGP asuma que el texto normal debe convertirse a la forma
cannica antes de encriptar, slo hay que aadir la opcin "t" al
encriptar o firmar un mensaje, como en:

     pgp -et mensaje.txt identificador_des

Este modo se desconecta automticamente si PGP detecta algo que
considere un dato binario, no de texto, en el fichero normal.

Para aquellos usuarios de PGP con conjunto de caracteres de 8 bits, PGP,
al pasar el texto a la forma cannica, puede convertir los datos del
conjunto local de caracteres al conjunto LATIN1 (ISO 8859-1 Latin
Alphabet 1), dependiendo del parmetro CHARSET del fichero de
configuracin de PGP. LATIN1 es un superconjunto de ASCII, con
caracteres aadidos para muchos idiomas europeos.


Eliminacin de los restos del texto normal en el disco
=-----------------------------------------------------

Despus de cifrar un fichero, usted puede hacer que PGP sobrescriba
automticamente el texto normal y lo borre sin dejar rastro, para que
nadie pueda recuperarlo ms adelante con una utilidad de exploracin de
bloques de disco. Resulta til si el fichero de texto normal contiene
informacin confidencial que usted no quiere tener por ah.

Para eliminar el fichero normal despus de producir el texto cifrado,
aada la opcin "w" (wipe {limpiar}) cuando encripte o firme un mensaje,
como en:

     pgp -esw mensaje.txt identificador_des

Este ejemplo crea el fichero cifrado "mensaje.pgp", y el fichero normal
"mensaje.txt" se destruye sin posibilidad de recuperacin.

Naturalmente, debe tener cuidado con esta opcin. Tenga tambin en
cuenta que este proceso no elimina ningn fragmento de texto normal que
el procesador de texto haya creado en el disco mientras se editaba el
mensaje antes de ejecutar PGP. La mayora de los procesadores crean
copias de seguridad, ficheros provisionales, o ambas cosas. Por otra
parte, slo se sobrescribe el fichero una vez-- suficiente para frustrar
intentos convencionales de recuperacin del disco, pero no para soportar
un esfuerzo porfiado, con recursos, por recuperar los dbiles restos
magnticos de los datos, mediante maquinaria especial para recuperar
discos.


Visualizacin del texto descifrado en la pantalla
=------------------------------------------------

Para ver el texto descifrado en la pantalla (como al utilizar una orden
parecida al "more" {"ms"} de Unix), sin escribirlo en un fichero,
utilice la opcin -m (more):

     pgp -m fcifrado

As se muestra el texto normal descifrado, pantalla a pantalla.


Cmo hacer un mensaje "Slo para sus ojos"
=-----------------------------------------

Para hacer que el texto descifrado SOLO se muestre en la pantalla de la
destinataria, sin poder grabarse en el disco, aada la opcin -m:

     pgp -mes mensaje.txt identificador_des

Ms adelante, cuando la destinataria desencripte el texto cifrado con su
clave secreta y su contrasea, el texto normal se mostrar en la
pantalla, sin grabarse en el disco. El texto aparecer como si hubiese
utilizado la orden "more" de Unix, pantalla a pantalla. Si quiere leer
el mensaje otra vez, tendr que desencriptarlo de nuevo.

Esta caracterstica proporciona el medio ms seguro para evitar que un
mensaje confidencial quede accidentalmente en el disco de la
destinataria. Se aadi por peticin de una usuaria que quera enviar
mensajes ntimos a su amante, pero que tena miedo de dejar
inadvertidamente los mensajes descifrados en el ordenador de su marido.


Conservacin del nombre original del fichero de texto normal
=-----------------------------------------------------------

Normalmente, PGP da al fichero descifrado un nombre parecido al del
texto cifrado, simplemente eliminando la extensin. Puede anularse este
convenio, indicando en la lnea de rdenes un fichero de salida para el
texto normal, con la opcin -o. Para la mayor parte del correo-E es una
buena forma de nombrar el fichero normal, que permite decidirlo en el
momento de descifrar, ya que los mensajes vienen habitualmente de textos
con nombres sin utilidad como "to_phil.txt" {"a_phil.txt"}.

Sin embargo, cuando PGP encripta un fichero normal, siempre guarda el
nombre original y lo aade al texto normal antes de comprimirlo y
encriptarlo. Normalmente, PGP desecha este nombre al desencriptar, pero
puede indicarle que lo conserve y que lo utilice en el fichero de salida
descifrado. Resulta til cuando se aplica PGP a ficheros cuyos nombres
hay que conservar.

Para recuperar el nombre original del texto normal al desencriptar,
aada la opcin -p, como en:

     pgp -p fcifrado

Normalmente, nunca utilizo esta opcin, porque de otro modo la mitad del
correo-E que entra se desencriptara en ficheros con los mismos nombres
"to_phil.txt" o "prz.txt".


Modificacin del identificador de usuario o de la frase de contrasea
=--------------------------------------------------------------------

En ciertos casos, necesitar cambiar su frase de contrasea, quiz
porque hubiese alguien mirando por encima del hombro mientras usted la
estaba escribiendo.

Puede querer tambin cambiar su identificador de usuario, porque se haya
casado o cambiado de nombre, o porque haya cambiado su direccin de
correo-E. A lo mejor quiere aadir un segundo o tercer identificador de
usuario a la clave, por tener ms de un nombre o direccin de correo-E,
o por querer indicar ms de un cargo profesional. PGP permite incluir
ms de un identificador en la clave, y se puede utilizar cualquiera de
ellos para buscarla en un fichero.

Para modificar el identificador o la frase de contrasea de su clave
secreta:

     pgp -ke identificador [fdclaves]

PGP pedir un nuevo identificador o una nueva contrasea.

El parmetro opcional [fdclaves], si se indica, debe ser un fichero de
claves pblicas, no secretas. El campo identificador debe ser el suyo
propio, que PGP reconoce porque aparece tanto en el fichero de claves
pblicas como en el de claves secretas. Ambos ficheros de claves se
actualizan, aunque usted slo indique el fichero de claves pblicas.


Modificacin de los parmetros de confianza de una clave pblica
=---------------------------------------------------------------

En ciertas ocasiones har falta cambiar los parmetros de confianza de
una clave pblica del fichero. La explicacin del significado de estos
parmetros aparece en la seccin "Cmo controla PGP la validez de las
claves?" en el volumen sobre Temas esenciales de la Gua del usuario de
PGP.

Para modificar los parmetros de confianza de una clave pblica:

     pgp -ke identificador [fichero]


Comprobacin de que todo est bien en el fichero de claves pblicas
=------------------------------------------------------------------

Normalmente, PGP comprueba automticamente cualquier clave o firma nueva
en el fichero de claves pblicas, y actualiza los parmetros de
confianza y las puntuaciones de validez. En teora, mantiene actualizada
toda la informacin sobre la validez de las claves al aadir o suprimir
material del fichero. Sin embargo, puede hacer falta que PGP realice un
anlisis exhaustivo del fichero de claves pblicas, comprobando las
firmas de certificacin y los parmetros de confianza, poniendo al da
todas las puntuaciones de validez, y que compruebe su propia clave,
fundamentalmente fiable, comparndola con una copia de seguridad en un
disco protegido contra escritura. Es conveniente realizar peridicamente
este mantenimiento higinico, para comprobar que todo va bien en el
fichero de claves pblicas. Para indicar a PGP que realice un anlisis
completo del fichero, utilice la opcin -kc (keyring check)
{comprobacin del fichero}:

     pgp -kc

Tambin puede hacer que PGP compruebe las firmas de una sola clave
pblica, con:

     pgp -kc identificador [fichero]

Para obtener ms informacin sobre la comprobacin de la copia de
seguridad de su propia clave, consulte la descripcin del parmetro
BAKRING en la seccin sobre el fichero de configuracin, en este mismo
manual.


Verificacin de una clave pblica por telfono
=---------------------------------------------

Si obtiene una clave pblica que no ha sido certificada por nadie en
quien usted confe, cmo puede saber que es realmente su clave?  La
mejor forma de comprobar una clave sin certificar es verificarla por
algn canal independiente, distinto del que le sirvi para recibir la
clave. Una buena forma, si conoce a la persona y la podra reconocer por
telfono, sera llamarla y verificar la clave por telfono. En lugar de
leer toda la clave (en armadura ASCII) por telfono, una tarea pesada,
podra leerles slo su "huella dactilar". Para ver esa huella dactilar,
utilice la orden -kvc:

     pgp -kvc identificador [fichero]

De esta manera se mostrar la clave con un resumen de 16 bytes de los
componentes de la clave pblica. Lea por telfono esta huella dactilar
de 16 bytes a la duea de la clave, mientras ella la comprueba con la
suya propia, obtenida con la misma orden.

Pueden as verificarse las claves mutuamente, y firmarlas con confianza.
Es una forma segura y cmoda de iniciar la red de confianza de las
claves en su crculo de amigos.


Utilizacin de PGP como un filtro UNIX
=-------------------------------------

Los aficionados a Unix estn acostumbrados a los "conductos" (pipes)
para conseguir que dos aplicaciones trabajen conjuntamente. La salida de
una aplicacin se dirige como entrada de otra por medio de un conducto.
Para que funcione, las aplicaciones tienen que poder leer el material en
bruto por la "entrada estndar" (standard input), y escribir la salida
procesada en la "salida estndar" (standard output). PGP puede funcionar
de este modo. Si no entiende qu quiere decir todo esto, seguramente no
lo necesita.

Para utilizar un filtro tipo Unix, leyendo de la entrada estndar y
escribiendo en la salida estndar, elija la opcin -f, como en:

     pgp -festa identificador_des <fentrada >fsalida

Esta caracterstica hace ms sencillo adaptar PGP a las aplicaciones de
correo electrnico.

Cuando utilice PGP en modo filtro para desencriptar un fichero cifrado,
puede utilizar la variable de entorno PGPPASS para la frase de
contrasea, y que PGP no la pida. La caracterstica PGPPASS se explica
ms adelante.


Supresin de las preguntas innecesarias:  BATCHMODE
=--------------------------------------------------

Con la bandera BATCHMODE (modo por lotes) activada en la lnea de
rdenes, PGP no har ninguna pregunta innecesaria ni pedir ficheros
alternativos. He aqu un ejemplo de cmo establecer esta bandera:

     pgp +batchmode fcifrado

Resulta til para ejecutar PGP de forma no interactiva desde guiones de
Unix o ficheros por lotes DOS. Algunas rdenes de gestin de claves
necesitan intervencin del usuario incluso con BATCHMODE activada, por
lo que los guiones tendrn que evitarlas.

Tambin se puede activar BATCHMODE para comprobar la validez de la firma
de un fichero. Si no haba firma en el fichero, el cdigo de salida es
1. Si tena una firma correcta, el cdigo de salida es 0.


Respuesta "S" obligada a las preguntas de confirmacin:  FORCE
=--------------------------------------------------------------

Esta bandera de lnea de rdenes hace que PGP asuma "s" como respuesta
del usuario a las preguntas de confirmacin para sobreescribir un
fichero existente, o para eliminar una clave del fichero por medio de la
orden -kr. He aqu un ejemplo de cmo establecer esta bandera:

     pgp +force fcifrado
o:
     pgp -kr +force Smith

Esta caracterstica resulta til al ejecutar PGP de forma no interactiva
desde un guin Unix o fichero por lotes DOS.


PGP devuelve a la coraza ("shell") el estado de salida
=-----------------------------------------------------

Para facilitar la ejecucin de PGP en modo "por lotes", como desde
ficheros ".bat" de DOS o guiones de Unix, PGP devuelve el estado de
error de salida a la coraza ("shell"). Un cdigo igual a cero indica una
salida normal, y un cdigo distinto de cero indica que ha habido algn
error. Las diferentes condiciones de error devuelven a la coraza
distintos cdigos.


Variable de entorno para la frase de contrasea
=----------------------------------------------

Normalmente, PGP pide al usuario que escriba una frase de contrasea
cada vez que se necesita para abrir una clave secreta. Sin embargo,
puede almacenarse esa frase en una variable de entorno, desde la coraza
de rdenes del sistema operativo. La variable PGPPASS contiene la frase
de contrasea que PGP intentar utilizar primero. Si es incorrecta, PGP
resolver la situacin pidiendo la frase correcta.

Por ejemplo, en DOS, la orden de coraza:

     SET PGPPASS=zaphod beeblebrox for president

eliminar el indicador de la frase de contrasea si era "zaphod
beeblebrox for president".

Esta peligrosa caracterstica facilita las cosas si tiene que tratar
habitualmente con muchos mensajes dirigidos a su clave secreta,
eliminando la necesidad de repetir la contrasea cada vez que ejecuta
PGP.

He aadido esta caracterstica por peticin popular. No obstante, es
bastante peligrosa, ya que deja su valiosa contrasea almacenada en un
lugar distinto de su propio cerebro. An peor, si es usted
particularmente imprudente, podra estar incluso en el disco del mismo
ordenador que tiene la clave secreta. Sera especialmente absurdo y
peligroso instalar esta orden en un fichero por lotes o de guin, como
el AUTOEXEC.BAT de DOS. Cualquiera podra aparecer durante la hora de la
comida y robar tanto el fichero de claves secretas como el fichero con
la frase de contrasea.

No hay forma de insistir lo suficiente sobre la importancia de este
riesgo. Si va a utilizar esta caracterstica, asegrese de leer las
secciones "Exposicin en sistemas multiusuario" y "Cmo proteger las
claves secretas contra revelacin" en este volumen y en el volumen sobre
Temas esenciales de la Gua del Usuario de PGP.

Si tiene que utilizarla, el mtodo ms seguro sera escribir a mano la
orden, para establecer PGPPASS cada vez que arranque la mquina para
utilizar PGP, y borrar la variable o apagar el ordenador cuando haya
terminado. Nunca, definitivamente, debe hacerlo en un entorno donde
alguien ms pueda acceder a su mquina. Esa persona podra llegar y
simplemente pedir al ordenador que mostrase el contenido de PGPPASS.


Establecimiento de los parmetros de configuracin: CONFIG.TXT
==============================================================

PGP tiene diversos parmetros ajustables, que pueden definirse en un
fichero de texto especial, llamado "config.txt", en el directorio
sealado por la variable de entorno PGPPATH. El fichero de configuracin
permite al usuario definir diversas banderas y parmetros, sin tener que
hacerlo siempre en la lnea de rdenes.

Los parmetros de configuracin pueden contener valores enteros, cadenas
de caracteres, o valores "on/off" {encendido/apagado}, segn el tipo de
parmetro. Se proporciona un fichero de muestra con PGP, para que pueda
ver algunos ejemplos.

En el fichero de configuracin se ignoran las lneas en blanco, al igual
que cualquier cosa que vaya despus del carcter de comentario "#". Las
palabras clave no tienen en cuenta el tipo de letra (maysculas o
minsculas).

He aqu un fragmento de muestra de un fichero de configuracin tpico

# TMP es el directorio de los ficheros de borrador de PGP, p.ej.
# un disco en RAM
TMP = "e:\"  # La variable TMP del entorno puede imponerse.
Armor = on   # Se pone -a para armadura ASCII donde corresponda.
# CERT_DEPTH indica con qu profundidad las referencias pueden
# servir como referencias de otras.
cert_depth = 3

Si no se definen algunos parmetros en el fichero de configuracin, o no
hay tal fichero, o PGP no puede encontrarlo, se eligen por omisin
algunos valores razonables.

Tenga en cuenta que tambin se pueden establecer esos parmetros de
configuracin directamente desde la lnea de rdenes de PGP, precediendo
el valor con un carcter "+". Por ejemplo, estas dos rdenes PGP
producen el mismo efecto:

    pgp -e +armor=on mensaje.txt burua
o:  pgp -ea mensaje.txt burua


A continuacin, se indican los diversos parmetros que pueden definirse
en el fichero de configuracin.

TMP - Trayectoria para ficheros temporales
=-----------------------------------------

Valor por omisin:  TMP = ""

El parmetro TMP indica en qu directorio se sitan los ficheros
temporales que necesita PGP. El mejor sitio para ponerlos es un disco
RAM, si lo tiene. De esa manera se aceleran bastante las cosas, y
aumenta la seguridad. Si TMP no est definido, los ficheros temporales
se sitan en el directorio actual. Si se ha definido la variable de
entorno TMP, PGP la utiliza para poner los ficheros temporales.


LANGUAGE - Eleccin del idioma
=-----------------------------

Valor por omisin:  LANGUAGE = "en"

PGP muestra en la pantalla diversos indicadores, mensajes de advertencia
y consejos para el usuario. Por ejemplo, mensajes como "No se encuentra
el fichero" o "Introduzca su contrasea:". Estos mensajes estn
normalmente en ingls. Sin embargo, puede hacer que PGP muestre sus
mensajes en otros idiomas, sin tener que modificar el programa
ejecutable.

Personas de diversos pases han traducido todos los mensajes,
advertencias e indicadores de PGP a sus idiomas maternos. Estos cientos
de mensajes traducidos se encuentran en un fichero especial de texto,
llamado "language.txt", que se distribuye con PGP. Los mensajes de este
fichero se pueden encontrar en ingls, castellano, neerlands, alemn,
francs, italiano, ruso, letn y lituano. Podrn aadirse otros idiomas
ms adelante.

El parmetro LANGUAGE indica en qu idioma se muestran los mensajes.
LANGUAGE puede ser "en" para ingls, "es" para castellano, "de" para
alemn, "nl" para neerlands, "fr" para francs, "it" para italiano,
"ru" para ruso, "lt3" para lituano, "lv" para letn o "esp" para
esperanto. Por ejemplo, si aparece la siguiente lnea en el fichero de
configuracin:

LANGUAGE = "es"

PGP elegira el castellano para mostrar los mensajes. La eleccin por
omisin es ingls.

Cuando PGP tiene que mostrar un mensaje, busca en el fichero
"language.txt" el equivalente en el idioma elegido, y lo presenta. Si no
puede encontrar el fichero de idiomas, si el idioma elegido no se
encuentra en l o si alguna frase no se encuentra traducida o no est en
el fichero, PGP mostrar el mensaje en ingls.

Para ahorrar espacio en el disco, no se incluye la mayor parte de las
traducciones en el lanzamiento estndar de PGP, pero se pueden obtener
por separado.


MYNAME - identificador de usuario por omisin para firmar
=--------------------------------------------------------

Valor por omisin:  MYNAME = ""

El parmetro de configuracin MYNAME indica qu identificador de usuario
por omisin sirve para elegir la clave secreta que se utiliza para
firmar. Si MYNAME no est definido, se utiliza la clave secreta ms
reciente del fichero. Puede anularse este valor, indicando un
identificador de usuario en la lnea de rdenes de PGP con la opcin -u.


TEXTMODE - Asumir que el texto normal es un fichero de texto
=-----------------------------------------------------------

Valor por omisin:  TEXTMODE = off

El parmetro TEXTMODE es equivalente a la opcin -t de la lnea de
rdenes. Si est activado, hace que PGP asuma que el texto normal es un
fichero de texto, en lugar de un fichero binario, y lo convierta en
"texto cannico" antes de encriptarlo. El texto cannico tiene un
retorno de carro y un salto de lnea al final de cada lnea de texto.

Este modo se desactiva automticamente si PGP detecta en el fichero algo
que considera un dato binario.

En sistemas VAX/VMS, la versin actual de PGP tiene como eleccin por
omisin TEXTMODE=ON.

Para obtener ms informacin, consulte la seccin "Envo de ficheros de
texto ASCII entre distintos entornos".


CHARSET - Indica el conjunto local de caracteres
=-----------------------------------------------

Valor por omisin:  CHARSET = NOCONV

Dado que PGP tiene que procesar los mensajes en muchos idiomas
diferentes, con conjuntos de caracteres distintos de ASCII, puede hacer
falta indicar a PGP qu conjunto  de caracteres utiliza su mquina. As
se determina que conversin hay que realizar al convertir ficheros
normales de texto desde y hacia formato cannico. Slo tiene relevancia
si usted se encuentra en un entorno sin ingls ni ASCII.

El parmetro CHARSET elige el conjunto local de caracteres. Las
posibilidades son NOCONV (no convertir), LATIN1 (ISO 8859-1 Latn
Alphabet 1), KOI8 (utilizado en la mayora de los sistemas Unix en
Rusia), ALT-CODES (utilizado en sistemas rusos DOS) y CP850 (utilizado
en la mayora de los idiomas de Europa Occidental en PCs estndar DOS).

LATIN1 es la representacin interna que emplea PGP para texto cannico,
por lo que al elegir LATIN1 no se realiza ninguna conversin. Tenga
tambin en cuenta que PGP trata KOI8 como LATIN1 aunque sea un conjunto
de caracteres completamente diferente (ruso), ya que tratar de convertir
KOI8 a LATIN1 o CP850 sera intil. Esto quiere decir que hacer CHARSET
igual a NOCONV, LATIN1 o KOI8 resulta equivalente para PGP.

Si utiliza DOS y espera enviar y recibir informacin en idiomas de
Europa Occidental, establezca CHARSET = "CP850". As se har que PGP
convierta los mensajes cannicos entrantes de LATIN1 a CP850 despus de
desencriptar. Si utiliza la opcin -t (texto) para convertir a texto
cannico, PGP convierte el texto CP850 a LATIN1 antes de encriptarlo.

Para mayor informacin, vase la seccin "Envo de ficheros de texto
ASCII entre distintos entornos".


ARMOR - Activa la salida con armadura ASCII
=------------------------------------------

Valor por omisin:  ARMOR = off

El parmetro ARMOR es equivalente a la opcin -a en la lnea de rdenes.
Si est activado, hace que PGP produzca el texto cifrado y las claves en
formato ASCII Radix-64, apropiado para enviar por canales de correo-E.
Los ficheros de salida reciben la extensin ".asc".

Si utiliza PGP principalmente para correo-E, puede resultar conveniente
activar este parmetro.

Para obtener ms informacin, consulte la seccin "Envo de texto
cifrado por canales de correo-E: formato Radix-64" en el volumen sobre
Temas esenciales.


ARMORLINES - Tamao de ficheros por partes con armadura ASCII
=------------------------------------------------------------

Valor por omisin:  ARMORLINES = 720

Cuando PGP crea un fichero ".asc" muy grande en radix-64, para enviar el
texto cifrado o las claves por correo-E, lo divide en trozos separados
lo bastante pequeos como para poder enviarlos con las utilidades para
correo de Internet. Normalmente, los procesadores de correo en Internet
prohben ficheros de ms de unos 50.000 bytes, por lo que, restringiendo
el nmero de lneas a aproximadamente 720, nos mantendremos
tranquilamente dentro de los lmites. Las partes del fichero toman como
sufijos ".as1", ".as2", ".as3", ...

El parmetro de configuracin ARMORLINES indica el mximo nmero de
lneas para cada parte de la secuencia de ficheros ".asc". Si se hace
cero, PGP no divide el fichero.

Los ficheros de correo en Fidonet tienen un lmite superior de unos 32K
bytes, por lo que 450 lneas sera ms apropiado en esos entornos {de
todos modos, parece que hay una "policy" que prohbe el envo de
ficheros cifrados por "netmail").

Para obtener ms informacin, consulte la seccin "Envo de texto
cifrado por canales de correo-E: formato Radix-64" en el volumen sobre
Temas esenciales.


KEEPBINARY - Conservar ficheros cifrados binarios tras desencriptar
=------------------------------------------------------------------

Valor por omisin:  KEEPBINARY = off

Cuando PGP lee un fichero ".asc", reconoce que est en formato radix-64,
y lo convierte en binario antes de procesarlo normalmente, dejando como
producto secundario un texto cifrado ".pgp" en forma binaria. Despus de
seguir procesando el fichero ".pgp" para desencriptarlo, el fichero
final de salida se encontrar en texto normal.

Puede que quiera borrar el fichero intermedio ".pgp", o dejar que PGP lo
haga automticamente. Siempre puede volver a ejecutar PGP sobre el
fichero original ".asc".

El parmetro KEEPBINARY activa o desactiva la conservacin del fichero
intermedio ".pgp" durante la desencriptacin.

Para obtener ms informacin, consulte la seccin "Envo de texto
cifrado por canales de correo-E: formato Radix-64" en el volumen sobre
Temas esenciales.


COMPRESS - Activar compresin
=----------------------------

Valor por omisin:  COMPRESS = on

El parmetro COMPRESS activa o desactiva la compresin de datos para
antes de encriptar. Se utiliza sobre todo en la depuracin de PGP.
Normalmente, PGP intenta comprimir el texto normal antes de encriptarlo.
En general, debe dejarse esta opcin tal como est, y permitir a PGP que
intente comprimir el texto.


COMPLETES_NEEDED - Referencias completamente fiables necesarias
=--------------------------------------------------------------

Valor por omisin:  COMPLETES_NEEDED = 1

El parmetro COMPLETES_NEEDED indica el mnimo nmero de referencias
completamente fiables que se necesitan para certificar por completo una
clave pblica en el fichero. Se proporciona as una forma de ajustar el
escepticismo de PGP.

Para obtener ms informacin, consulte la seccin "Cmo controla PGP la
validez de las claves?" en el volumen sobre Temas esenciales de la Gua
del usuario.


MARGINALS_NEEDED - Referencias relativamente fiables necesarias
=--------------------------------------------------------------

Valor por omisin:  MARGINALS_NEEDED = 2

El parmetro MARGINALS_NEEDED indica el mnimo nmero de referencias
relativamente fiables que se requieren para certificar completamente una
clave pblica en el fichero. Se proporciona as una forma de ajustar el
escepticismo de PGP.

Para obtener ms informacin, consulte la seccin "Cmo controla PGP la
validez de las claves?" en el volumen sobre Temas esenciales de la Gua
del usuario.


CERT_DEPTH - Profundidad de anidamiento de referencias
=-----------------------------------------------------

Valor por omisin:  CERT_DEPTH = 4

El parmetro CERT_DEPTH indica a qu nivel de profundidad pueden
anidarse las referencias para certificar otras que certifiquen claves
pblicas en el fichero. Por ejemplo, si CERT_DEPTH es 1, slo puede
haber una capa de referencias debajo de la clave fundamentalmente
fiable. Si este fuese el caso, usted tendra que certificar directamente
las claves pblicas de todas las referencias fiables del fichero. Si
hace CERT_DEPTH igual a 0, no podr hacer uso de referencias, y tendr
que certificar directamente todas y cada una de las claves en el fichero
antes de poder utilizarlas. El mnimo valor para CERT_DEPTH es 0, y el
mximo 8.

Para obtener ms informacin, consulte la seccin "Cmo controla PGP la
validez de las claves?" en el volumen sobre Temas esenciales de la Gua
del Usuario.


BAKRING - Nombre de la copia de seguridad del fichero secreto
=------------------------------------------------------------

Valor por omisin:  BAKRING = ""

Todas las certificaciones que PGP hace en el fichero de claves pblicas
dependen en ltima instancia de su propia clave (o claves)
fundamentalmente fiable. Para detectar cualquier manipulacin del
fichero, PGP debe comprobar que su propia clave no ha sido manipulada.
Para hacerlo, PGP debe comparar la clave pblica con una copia de
seguridad en un medio resistente a manipulacin, tal como un disco
protegido contra escritura. La clave secreta contiene la informacin de
la clave pblica, ms algunos elementos secretos. Por tanto, PGP puede
comprobar la clave pblica con una copia de seguridad de la clave
secreta.

El parmetro BAKRING indica qu trayectoria se utiliza para encontrar la
copia fiable del fichero de claves secretas. En DOS, podra establecerse
como "a:\secring.pgp", para indicar una copia de seguridad protegida
contra escritura en la unidad de diskette. La operacin slo se realiza
con la opcin -kc de PGP para comprobar el fichero de claves pblicas.

Si no se define BAKRING, PGP no comprueba la clave con una copia de
seguridad.

Para obtener ms informacin, consulte las secciones "Cmo proteger las
claves pblicas contra manipulacin" y "Cmo controla PGP la validez de
las claves?" en el volumen de Temas esenciales.


PAGER - Elegir la orden de coraza para mostrar texto normal
=----------------------------------------------------------

Valor por omisin:  PAGER = ""

PGP le permite visualizar en la pantalla el texto normal descifrado
(como con la orden "more" al estilo Unix), sin escribirlo en un fichero,
indicando la opcin -m (more) {ms} al desencriptar. Se muestra el texto
normal pantalla por pantalla.

Si prefiere utilizar una utilidad de paginacin ms extica en lugar de
la integrada en PGP, puede indicar el nombre de una orden de coraza que
pueda invocarse para mostrar el fichero de texto normal. El parmetro
PAGER indica la orden para mostrar el fichero. Por ejemplo, en sistemas
DOS, puede que quiera utilizar el conocido programa compartido
"list.com" para mostrar el texto. Asumiendo que tenga una copia de
"list.com", puede establecer PAGER:

PAGER = "list"

No obstante, si el remitente hubiese indicado que el fichero es slo
para sus ojos, y que no puede escribirse en el disco, PGP utilizar su
propia funcin interna de visualizacin.

Para obtener ms informacin, consulte la seccin "Visualizacin del
texto descifrado en la pantalla".


SHOWPASS - Mostrar al usuario la frase de contrasea
=---------------------------------------------------

Valor por omisin:  SHOWPASS = off

En general, PGP no permite que se vea la frase de contrasea mientras se
escribe. As se dificulta que alguien pueda mirar por encima del hombro
mientras lo hace, consiguiendo la contrasea. Sin embargo, algunas
personas que no pueden o no saben escribir a mquina tienen problemas
para introducir la frase de contrasea sin mirar lo que estn
escribiendo, y despus de todo quiz lo estn haciendo en la intimidad
de sus propias casas. Ellos pidieron que PGP pudiese configurarse para
poder ver lo que estaban escribiendo al introducir la frase.

El parmetro SHOWPASS permite que PGP muestre lo que se escribe al
introducir la frase de contrasea.


TZFIX - Ajuste de zona horaria
=-----------------------------

Valor por omisin:  TZFIX = 0

PGP proporciona sellos de hora para las claves y los certificados de
firma en Greenwich Mean Time (GMT) {Hora media de Greenwich}, o
Coordinated Universal Time (UTC) {Hora coordinada universal}, que para
este caso son equivalentes. Cuando PGP pide al sistema la hora, se
supone que ste la da en GMT.

Sin embargo, algunas veces, debido a una configuracin incorrecta de los
sistemas MSDOS, la hora del sistema se devuelve en US Pacific Standard
Time {Hora estndar del Pacfico en US} ms 8 horas. Extrao, no?
Quiz debido a algn tipo de patriotera de la costa oeste de los EEUU,
MSDOS supone que la hora local es US Pacific time, y la corrige hacia
GMT. Este comportamiento afecta negativamente a la funcin interna GMT
de MSDOS a la que llama PGP. En cualquier caso, si la variable TZ de
entorno MSDOS est bien definida para su zona horaria, se corrige la
idea equivocada que tiene MSDOS de que todo el mundo vive en la costa
oeste de los EEUU.

El parmetro TZFIX indica el nmero de horas que hay que aadir a la
funcin de hora del sistema para obtener GMT y poner los sellos de hora
GMT en las claves y en las firmas. Si la variable TZ del entorno MSDOS
est definida adecuadamente, puede dejarse TZFIX=0. En general, los
sistemas Unix no tendrn que preocuparse de establecer TZFIX. Sin
embargo, si est utilizando algn oscuro sistema operativo que no sabe
nada de GMT, tendr que utilizar TZFIX para ajustar la hora.

En sistemas MSDOS sin TZ definida, puede hacerse TZFIX=0 para
California, -1 para Colorado, -2 para Chicago, -3 para Nueva York, -8
para Londres, -9 para Amsterdam {y Madrid}. En verano, habr que
disminuir esos valores a mano. Un engorro.

Es mucho ms claro establecer la variable TZ de entorno MSDOS dentro
del fichero AUTOEXEC.BAT, y no utilizar la correccin TZFIX. De esa
manera, MSDOS proporciona sellos apropiados de hora GMT, y corrige
automticamente los ajustes horarios para ahorro de energa (en EEUU)
{horario de invierno}. He aqu algunas lneas de ejemplo para
AUTOEXEC.BAT, dependiendo de la zona horaria:

Para Los Angeles: SET TZ=PST8PDT
Para Denver:      SET TZ=MST7MDT
Para Arizona:     SET TZ=MST7
     (Arizona nunca tiene horario de ahorro de energa)
Para Chicago:     SET TZ=CST6CDT
Para Nueva York:  SET TZ=EST5EDT
Para Londres:     SET TZ=GMT0BST
Para Amsterdam:   SET TZ=MET-1DST
     (y resto de la Comunidad Europea)
Para Mosc:       SET TZ=MSK-3MSD
Para Aukland:     SET TZ=NZT-13


CLEARSIG - Activar Mensajes firmados encapsulados como texto normal
=------------------------------------------------------------------

Valor por omisin:  CLEARSIG = off

En general, los mensajes de PGP firmados y sin encriptar tienen un
certificado de firma delante en forma binaria. Para enviarlo por medio
de un canal de correo-E de 7 bits, se aplica la armadura ASCII radix-64
(consulte el parmetro ARMOR), haciendo que el mensaje sea ilegible para
los ojos humanos, aunque el mensaje no est cifrado. El destinatario
debe utilizar PGP para eliminar la armadura antes de leer el mensaje.

Si el mensaje original es texto (no binario), hay una forma de enviarlo
por medio de un canal de correo-E de forma que se aplique la armadura
ASCII solamente al certificado binario de firma, pero no al texto
normal. De esta manera se puede leer el mensaje sin la ayuda de PGP. Por
supuesto, har falta PGP para comprobar la firma.

Para activar esta caracterstica, establezca CLEARSIG=ON y ARMOR=ON (o
utilice la opcin -a), y establezca TEXTMODE=ON (o utilice la opcin -
t). Por ejemplo, podra establecer CLEARSIG directamente desde la lnea
de rdenes:

pgp -sta +clearsig=on mensaje.txt

Esta representacin de los mensajes es anloga al tipo MIC-CLEAR de
mensaje del Internet Privacy Enhanced Mail (PEM). Tambin es importante
resaltar que, dado que este mtodo slo aplica la armadura ASCII al
certificado binario de firma, y no al texto mismo del mensaje, hay algn
riesgo de que el mensaje sin armadura pueda sufrir alguna interferencia
durante el camino. Puede ocurrir si pasa por alguna pasarela de correo-E
que realice alguna conversin del conjunto de caracteres, o, en ciertos
casos, pueden aadirse o eliminarse espacios del final de las lneas. Si
ocurre esto, la firma no se podr verificar, dando una indicacin
incorrecta de alteracin intencionada. Sin embargo, dado que PEM tiene
una debilidad similar, parece til tener esta caracterstica a pesar de
sus riesgos.

Desde la versin 2.2 de PGP, se ignoran los espacios al final de la
lnea para calcular la firma en modo CLEARSIG.


VERBOSE - Activar modo verboso
=-----------------------------

Valor por omisin :  VERBOSE = 1

VERBOSE puede establecerse como 0, 1 o 2, dependiendo de lo detallados
que quiera ver los mensajes diagnsticos de PGP. Los valores son:

0 - Slo mostrar mensajes si hay problemas. Los aficionados a Unix
queran este "modo silencioso".

1 - Normal. Muestra una cantidad razonable de informacin en los
mensajes de diagnstico y recomendacin.

2 - Muestra la mxima informacin, normalmente para ayudar a
diagnosticar problemas en PGP. No se recomienda para uso normal. Adems,
PGP no tiene problemas, eh?


INTERACTIVE - Pedir confirmacin para aadir claves
=--------------------------------------------------

Valor por omisin:  INTERACTIVE = off

La activacin de este modo hace que, al aadir un fichero de con varias
claves al fichero, PGP pida confirmacin para cada clave antes de
aadirla.


Proteccin contra falsos sellos de hora
=======================================

Un punto vulnerable poco evidente en PGP implica a aquellos usuarios
deshonestos que ponen falsos sellos de hora en sus certificados de clave
pblica y en sus firmas. Puede saltarse esta seccin si es usted un
usuario ocasional, sin inters especial en los oscuros protocolos de
clave pblica.

No hay nada que pueda evitar que un usuario deshonesto cambie la fecha y
la hora del reloj de su propio sistema, y genere certificados de clave
pblica y de firma para que parezcan haber sido elaboradas en otro
momento. Puede conseguir que parezca que ha firmado algo antes o despus
del momento real, o que su clave pblica o secreta ha sido creada antes
o despus. Este comportamiento puede producirle algn beneficio legal o
monetario, por ejemplo creando una va de escape que le permita negar
una firma.

Una solucin para este caso podra consistir en involucrar a una
autoridad de certificacin o notario, que creara firmas certificadas
con un sello de hora fiable. No tiene por qu ser una autoridad
centralizada. Cualquier referencia de confianza o tercera parte podra
realizar esta funcin, del mismo modo que lo hacen los verdaderos
notarios. Un certificado de clave pblica podra estar firmado por el
notario, y ese sello de hora fiable en su firma podra tener alguna
relevancia legal. El notario podra introducir el certificado firmado en
un registro especial controlado por l mismo. Cualquiera podra
consultar ese registro.

El notario tambin podra firmar otras firmas, creando un certificado de
firma de un certificado de firma. As servira como testigo de la firma,
del mismo modo que hacen los verdaderos notarios en papel. De nuevo, el
notario podra incluir el certificado de firma separado (sin todo el
documento) en un registro controlado por l mismo. La firma del notario
tendra un sello fiable de hora, que podra tener mayor credibilidad que
el de la firma original. Una firma se hara "legal" si ese notario la
firma y la registra.

El problema de la certificacin de firmas con notarios y sellos fiables
de hora merece un tratamiento ms detallado. No voy a intentar ahora
desenredar esta madeja. Se puede encontrar una buena exposicin del
tema en el artculo de Denning en IEEE Computer (1983, vanse las
referencias). Quedan muchos detalles por resolver en estos esquemas de
certificacin. Seguirn completndose al aumentar la utilizacin de PGP,
y cuando otros productos de clave pblica desarrollen sus propios
esquemas de certificacin.



Una mirada en el interior
=========================

Echemos un vistazo a unas cuantas caractersticas internas de PGP.


Nmeros aleatorios
=-----------------

PGP utiliza un generador criptogrficamente fuerte de nmeros
pseudoaleatorios, para generar las claves temporales de las sesiones
convencionales. El fichero de semilla que necesita se llama
"randseed.bin". Puede estar en cualquier directorio, indicado por la
variable PGPPATH. Si no existe ese fichero, se crea automticamente y se
rellena de nmeros verdaderamente aleatorios obtenidos midiendo tiempos
entre pulsaciones de tecla.

El generador vuelve a construir el fichero cada vez que lo utiliza,
mezclando nuevos datos de claves derivados parcialmente con la hora y
otras fuentes verdaderamente aleatorias. Se utiliza el algoritmo de
cifrado convencional como motor del generador de nmeros aleatorios. Ese
fichero contiene material aleatorio para semillas y datos aleatorios de
claves, para poner a punto el motor de cifrado convencional como
generador de nmeros aleatorios.

Este fichero de semillas debera estar al menos ligeramente protegido
contra exposicin, para reducir el riesgo de que un atacante pudiese
derivar las clave siguiente o anterior. El atacante no lo pasara muy
bien para sacar algo til de este fichero, ya que se lava
criptogrficamente antes y despus de cada utilizacin. Sin embargo,
parece prudente al menos intentar que no caiga en las manos equivocadas.

Si no se encuentra cmodo confiando en una fuente de nmeros aleatorios
derivada algortmicamente, por resistente que sea, tenga en cuenta que
ya se fa del mismo cifrado convencional para proteger los mensajes. Si
es lo suficientemente resistente para eso, debera bastar como fuente de
nmeros aleatorios para claves temporales. Tenga en cuenta que PGP sigue
utilizando nmeros verdaderamente aleatorios, obtenidos de fuentes
fsicas (sobre todo mediciones de tiempos en el teclado), para generar
los pares de claves pblica/secreta que se utilizan a largo plazo.


El algoritmo de cifrado convencional de PGP
=------------------------------------------

Como se ha descrito anteriormente, PGP "va a caballo" de un algoritmo
de cifrado convencional de clave nica, utilizando un algoritmo de clave
pblica para cifrar la clave de la sesin convencional y conmutando
entonces a ese tipo de criptografa convencional ms rpida. Hablemos
ahora de este algoritmo de cifrado convencional. No es DES.

El Federal Data Encryption Standard {Norma Federal de Cifrado de Datos}
(DES) resulta un buen algoritmo para la mayora de las aplicaciones
comerciales. Sin embargo, el Gobierno no confa en DES para proteger sus
propios datos clasificados. Quiz se deba a que la longitud de la clave
DES es 56 bits, lo bastante corta como para permitir un ataque por
fuerza bruta mediante una mquina especial, construida a base de grandes
cantidades de chips DES. Por otra parte, Biham y Shamir han tenido
recientemente un cierto xito atacando el DES completo de 16 rondas.

PGP no utiliza DES como algoritmo convencional para encriptar mensajes.
En su lugar, PGP emplea un algoritmo de cifrado convencional de clave
nica por bloques, llamado IDEA(mr). Una versin posterior de PGP podr
tambin admitir DES como opcin, siempre que lo solicite un nmero
suficiente de usuarios. Sin embargo, sospecho que IDEA es mejor que DES.

Para los que tengan inters en criptografa, el cifrado IDEA tiene un
tamao de bloque de 64 bits para el texto normal y el texto cifrado.
Tiene un tamao de clave de 128 bits. Su diseo se basa en el concepto
de "mezclar operaciones de distintos grupos algebraicos". En aplicacin
informtica, es mucho ms rpido que DES. Del mismo modo que este, puede
utilizarse en modo de retroalimentacin de cifrado (CFB) y
encadenamiento de bloques de cifrado (CBC). PGP utiliza el modo CFB de
64 bits.

El cifrado por bloques IPES/IDEA fue desarrollado en ETH, Zurich, por
James L. Massey y Xuejia Lay, y publicado en 1990. No es un algoritmo
"hecho en casa". Sus diseadores tienen una reputacin distinguida en la
comunidad criptolgica. Los primeros artculos sobre el algoritmo lo
llamaban IPES (Improved Proposed Encryption Standard) {Norma mejorada
propuesta para cifrado}, pero despus se cambi el nombre a IDEA
(International Data Encryption Algorithm) {Algoritmo Internacional de
Cifrado de Datos}. Hasta el momento, IDEA ha resistido los ataques mucho
mejor que otros cifrados como FEAL, REDOC-II, LOKI, Snefru y Khafre.
Adems, los primeros datos sugieren que IDEA es ms resistente que DES
al fructfero ataque criptoanaltico diferencial de Biham & Shamir.
Biham y Shamir han examinado el cifrado IDEA para encontrar sus
debilidades, sin xito. Varios grupos criptoanalticos acadmicos en
Blgica, Inglaterra y Alemania tambin estn intentando atacarlo, as
como grupos militares de diversos pases europeos. Segn este nuevo
cifrado sigue atrayendo esfuerzos de los centros ms formidables del
mundo criptoanaltico, la confianza en IDEA crece con el tiempo.

Un famoso jugador de hockey dijo una vez una frase que se traduce como
"Intento patinar hacia donde creo que va a estar la pastilla". Mucha
gente empieza a creer que los das de DES estn contados. Yo voy
patinando hacia IDEA.

No es prctico, ergonmicamente, utilizar RSA puro con grandes claves
para encriptar y desencriptar mensajes largos. Absolutamente nadie lo
hace as en el mundo real. Sin embargo, puede que a usted le preocupe
que el conjunto se vea debilitado por utilizar un esquema hbrido de
clave pblica y convencional, slo para acelerar las cosas. Despus de
todo, una cadena es tan fuerte como el ms dbil de sus eslabones.
Muchas personas, con menos experiencia en criptografa, creen
equivocadamente que RSA es intrnsecamente ms resistente que cualquier
cifrado convencional. No es as. RSA puede hacerse dbil si se utilizan
claves dbiles, y los cifrados convencionales pueden hacerse resistentes
eligiendo buenos algoritmos. Es difcil saber exactamente la resistencia
de un buen cifrado convencional sin llegar a romperlo. Un cifrado
convencional verdaderamente bueno puede ser incluso ms difcil de
romper que una clave RSA de "grado militar". El aliciente de la
criptografa de clave pblica no viene de ser intrnsecamente ms
resistente que el cifrado convencional-- su atractivo est en que hace
mucho ms cmoda la gestin de las claves.


Compresin de datos
=------------------

Normalmente, PGP comprime el texto normal antes de encriptarlo. Despus
es demasiado tarde para comprimir; los datos cifrados son
incomprimibles. La compresin ahorra tiempo de transmisin por modem y
espacio en el disco, y, lo que es ms importante, refuerza la seguridad
criptogrfica. La mayora de las tcnicas criptoanalticas explotan las
redundancias del texto normal para romper el cifrado. La compresin de
datos reduce la redundancia en el texto, mejorando la resistencia al
criptoanlisis. Lleva ms tiempo comprimir el texto normal, pero merece
la pena desde el punto de vista de la seguridad, al menos en mi cauta
opinin.

PGP no comprime los ficheros demasiado cortos, ni los que no se pueden
comprimir bien.

Si lo prefiere, puede utilizar PKZIP para comprimir el texto normal
antes de encriptarlo. PKZIP es una utilidad de compresin para DOS, en
programacin compartida, efectiva y fcil de encontrar, de PKWare Inc.
Tambin puede utilizar ZIP, un programa gratuito de compresin,
compatible con PKZIP, para Unix, DOS y otros sistemas, que puede pedir a
Jean-loup Gailly. En algunos casos, resulta una ventaja utilizar PKZIP o
ZIP, porque, al contrario que el algoritmo de compresin incorporado en
PGP, PKZIP y ZIP pueden comprimir mltiples ficheros en uno solo, que
vuelve a dividirse en varios al descomprimir. PGP no intenta volver a
comprimir un fichero que ya ha comprimido. Despus de desencriptar, el
destinatario puede descomprimir el texto normal con PKUNZIP. Si el texto
descifrado es un fichero comprimido PKZIP, PGP lo reconoce
automticamente y se lo indica al destinatario.

Para aquellos lectores con inters tcnico, la versin actual de PGP
utiliza las rutinas gratuitas de compresin ZIP escritas por Jean-loup
Gailly, Mark Adler y Richard B. Wales. Este programa ZIP utiliza
algoritmos de compresin funcionalmente equivalentes a los que utiliza
el nuevo PKZIP 2.0. Se eligi para PGP principalmente por la
disponibilidad del cdigo fuente en C, gratuito y transportable, porque
tiene una muy buena proporcin de compresin y porque es rpido.

Peter Gutmann ha escrito tambin una interesante utilidad de compresin
llamada HPACK, disponible gratuitamente en muchos establecimientos FTP
de Internet. Encripta los archivos comprimidos, utilizando formatos de
datos y ficheros de claves de PGP. El me pidi que lo mencionase aqu.


Resmenes de mensajes y firmas digitales
=---------------------------------------

Para elaborar una firma digital, PGP encripta con la clave secreta. Sin
embargo, PGP no encripta el mensaje completo con esa clave-- llevara
demasiado tiempo. En lugar de eso, PGP encripta un "resumen de mensaje".

El resumen de mensaje es una "destilacin" compacta (128 bits) del
mensaje, basada en la misma idea general de una suma de verificacin.
Puede tambin considerarse una "huella dactilar" del mensaje. El resumen
"representa" el mensaje, de forma que, si este se alterase de alguna
manera, se calculara un resumen distinto. As se hace posible detectar
cualquier cambio que haya podido introducir un falsificador. El resumen
se calcula mediante una funcin "distribucin" ("hash") unidireccional y
criptogrficamente resistente del mensaje. Resultara computacionalmente
imposible para un atacante idear un mensaje sustitutivo que produjese un
resumen idntico. En este aspecto, un resumen de mensaje es mucho mejor
que una suma de verificacin, porque sera fcil escribir un mensaje que
produjese la misma suma. Y, al igual que ocurre con la suma de
verificacin, no se puede derivar el mensaje original partiendo del
resumen.

El resumen del mensaje no basta por s mismo para autenticar un mensaje.
El algoritmo del resumen es pblico, y no se necesita saber ninguna
clave secreta para calcularlo. Si slo aadisemos el resumen al
mensaje, el falsificador podra alterarlo y simplemente aadir el nuevo
resumen, calculado a partir del mensaje cambiado. Para proporcionar
verdadera autenticacin, el remitente tiene que encriptar (firmar) el
resumen del mensaje con su propia clave secreta.

El remitente calcula el resumen del mensaje. Su clave secreta se utiliza
para encriptar ese resumen junto a un sello electrnico de hora,
formando as una firma digital o certificado de firma. El remitente
enva la firma digital junto con el mensaje. El destinatario recibe el
mensaje y la firma digital, y obtiene el resumen original desde la
firma, comprobndola con la clave pblica del remitente. Calcula
entonces un nuevo resumen del mensaje, y comprueba que coincide con el
que se ha obtenido de la firma digital. Si es as, se prueba que el
mensaje no ha sido alterado, y que realmente proviene del destinatario
al que pertenece la clave pblica con la que se ha comprobado la firma.

Un posible falsificador tendra que producir un mensaje modificado que
produjese un resumen idntico (lo que resulta imposible), o tendra que
crear una nueva firma digital de otro resumen (tambin imposible sin la
clave secreta del remitente).

Las firmas digitales prueban quin envi el mensaje, y que ste no ha
sido alterado, bien por error o intencionadamente. Tambin proporciona
no-desentendimiento, que significa que el remitente no puede
desautorizar fcilmente su firma.

La utilizacin de resmenes de mensaje en las firmas digitales tiene
otras ventajas, aparte de ser ms rpida que firmar el mensaje completo
con la clave secreta. Los resmenes permiten que las firmas sean de un
tamao pequeo, fijo y normalizado, sin importar el tamao del mensaje
real. Tambin permite que el programa compruebe la integridad del
mensaje automticamente, de forma parecida a como se realiza una suma de
verificacin. Adems, permite que las firmas se almacenen separadas de
los mensajes, quiz incluso en un archivo pblico, sin revelar
informacin confidencial sobre ellos, ya que nadie puede derivar el
contenido de un mensaje partiendo de su resumen.

El algoritmo que se utiliza es el Algoritmo de Resumen de Mensaje MD5,
donado al dominio pblico por RSA Data Security, Inc. El diseador de
MD5, Ronald Rivest, escribe sobre MD5:

[traduccin]
"Se conjetura que la dificultad de obtener dos mensajes con el mismo
resumen es del orden de 2^64 operaciones, y que la dificultad de obtener
un mensaje que tenga un resumen determinado es del orden de 2^128
operaciones. El algoritmo MD5 ha sido comprobado cuidadosamente para
encontrar debilidades. En cualquier caso, es relativamente nuevo, y un
mayor anlisis de su seguridad est justificado, naturalmente, como
ocurre con cualquier propuesta de este tipo. El nivel de seguridad que
proporciona MD5 debera bastar para implementar esquemas hbridos de
alta seguridad en firma digital, basados en MD5 y el criptosistema RSA
de clave pblica."


Compatibilidad con las versiones anteriores de PGP
==================================================

Esta versin de PGP no es compatible con la versin 1.0. Si tiene claves
para PGP 1.0, tendr que generar unas nuevas. Esta versin utiliza
nuevos algoritmos de criptografa convencional, compresin y resmenes
de mensaje, adems de aplicar un enfoque mucho mejor a la gestin de
claves. Eran demasiados cambios para hacerla compatible con los antiguos
mensajes, firmas y claves. Podramos haber ofrecido una utilidad de
conversin para transformar las claves antiguas en claves nuevas, pero
estbamos todos cansados y queramos sacar la nueva versin. Por otra
parte, la conversin de antiguas claves en nuevas podra haber creado
ms problemas de los que hubiese solucionado, ya que hemos cambiado a un
nuevo estilo recomendado, ms uniforme, para el identificador de
usuario, que incluye el nombre completo y la direccin de correo-E con
una sintaxis determinada.

Hay compatibilidad desde la versin 2.0 a las superiores. Dado que se
aaden nuevas caractersticas, las versiones antiguas no siempre sern
capaces de tratar algunos ficheros creados con las nuevas.

Hemos hecho un esfuerzo para disear las estructuras internas de datos
de esta versin de PGP para que puedan adaptarse a futuros cambios, por
lo que esperamos que no haga falta desechar y regenerar las claves en
las prximas versiones.



Puntos vulnerables
==================

Ningn sistema de seguridad de datos es impenetrable. PGP puede burlarse
de diversas maneras. En cualquier sistema de seguridad, debe preguntarse
usted mismo si la informacin que intenta proteger es ms valiosa para
el atacante que el coste del ataque. As, usted puede protegerse de los
ataques ms baratos, sin preocuparse de los ms caros.

Parte de la exposicin que sigue puede parecer demasiado paranoica, pero
es la actitud apropiada para debatir razonablemente sobre
vulnerabilidad.


Compromiso de la frase de contrasea y de la clave secreta
=---------------------------------------------------------

Seguramente, el ataque ms simple est relacionado con dejarse escrita
en algn sitio la frase de contrasea. Si alguien la consiguiese, junto
al fichero de la clave secreta, podra leer los mensajes dirigidos a
usted y hacer firmas en su nombre.

No elija contraseas obvias, que resulten fciles de adivinar, tales
como el nombre de sus hijos o cnyuge. Si eligiese como contrasea una
sola palabra, podra adivinarse fcilmente haciendo que un ordenador
probase todas las palabras en el diccionario hasta encontrarla. Esa es
la razn por la que una frase es mejor que una simple contrasea. Un
atacante ms completo podra hacer que su ordenador explorase un libro
de citas famosas para encontrarla. No es difcil encontrar una frase de
contrasea que sea fcil de recordar pero difcil de adivinar, eligiendo
expresiones creativamente absurdas u oscuras citas literarias.

Para obtener ms informacin, consulte la seccin "Cmo proteger las
claves secretas contra exposicin", en el volumen sobre Temas especiales
de la Gua del usuario de PGP.


Manipulacin de claves pblicas
=------------------------------

Un punto muy vulnerable es la manipulacin de las claves pblicas. Quiz
sea el punto dbil de ms crucial importancia en un criptosistema de
clave pblica, en parte porque los principiantes no lo reconocen
inmediatamente. La importancia de esta debilidad, y las contramedidas
higinicas adecuadas, se explican con detalle en la seccin "Cmo
proteger las claves pblicas contra manipulacin", en el volumen sobre
Temas esenciales.

En resumen:  Cuando utilice alguna clave pblica, asegrese de que no ha
sido manipulada. Slo debe confiar en una nueva clave pblica si la ha
obtenido directamente del dueo, o si la ha firmado alguien en quien
usted confa. Asegrese de que nadie pueda manipular su anillo de claves
pblicas. Mantenga control fsico tanto sobre su anillo de claves
pblicas como el de claves secretas, preferiblemente en su propio
ordenador personal, en lugar de hacerlo en un sistema remoto
multiusuario. Haga una copia de seguridad de los dos anillos.


Ficheros "no borrados del todo"
=------------------------------

Otro posible problema de seguridad tiene como origen la forma de borrar
ficheros de la mayor parte de los sistemas operativos. Cuando se
encripta un fichero y despus se suprime el original, el sistema
operativo no borra fsicamente los datos. Simplemente marca los bloques
del disco como borrados, permitiendo as que se utilicen ms adelante.
Es algo parecido a tirar documentos confidenciales en papel al
contenedor de reciclado, en lugar de pasarlos por la destructora de
documentos. Los bloques del disco todava tienen los datos
confidenciales que se queran borrar, y con el tiempo otros datos se
sobrescribiran encima de ellos. Si un atacante leyese esos bloques poco
despus de haber sido marcados, podra recuperar el texto normal.

De hecho, podra incluso hacerlo accidentalmente, si por algn motivo
algo va mal con el disco y algunos ficheros se borran o estropean. Se
puede ejecutar un programa de recuperacin de discos para reponer los
ficheros daados, pero esto implica a menudo recuperar tambin otros
ficheros antiguos. Los ficheros confidenciales, que se crean eliminados
para siempre, podran reaparecer y ser inspeccionados por quien est
recuperando el disco daado. Incluso al crear el mensaje original con un
procesador o editor de textos, esos programas podran estar creando
mltiples copias temporales del fichero en el disco, para uso interno.
El procesador de textos borra estas copias temporales cuando ha acabado,
pero los fragmentos confidenciales todava estn en alguna parte del
disco.

Permtame que le cuente una autntica historia de terror. Tena una
amiga, casada y con hijos pequeos, que tuvo una vez una corta y no muy
seria relacin ilcita. Escribi una carta a su amante con el procesador
de textos, y borr la carta despus de enviarla. Ms adelante, cuando la
relacin ya haba terminado, el disco se estrope y tuvo que recuperar
la informacin porque contena otros documentos importantes. Le pidi a
su marido que salvase el disco, lo que pareca perfectamente seguro, ya
que ella saba que haba borrado la carta inculpatoria. Su marido
ejecut un programa comercial de recuperacin de discos. Recuper bien
los ficheros, incluyendo la carta borrada. La ley, y esto inici una
trgica cadena de acontecimientos.

La nica forma de evitar que el texto normal vuelva a aparecer es hacer
que se sobrescriban de alguna manera los ficheros borrados. A menos que
est seguro de que los bloques se volvern a utilizar pronto, debe tomar
medidas activas para sobrescribir el fichero de texto normal, y todos
los fragmentos que haya dejado el procesador de textos. El texto
original puede sobrescribirse despus de encriptar, con la opcin -w
(wipe {limpiar}) de PGP. Puede encargarse de los fragmentos de texto
normal que quedan en el disco por medio de alguna utilidad que
sobrescriba todos los bloques libres. Por ejemplo, las Utilidades Norton
lo hacen en MSDOS.

Incluso si sobrescribe el texto normal del disco, un atacante resuelto y
con recursos podra recuperar los datos. Quedan leves restos magnticos
de los datos originales despus de sobrescribir. A veces puede
utilizarse maquinaria especial de recuperacin de discos para obtener
los datos.


Virus y caballos de Troya
=------------------------

Otro tipo de ataque puede involucrar virus o gusanos informticos
hostiles, diseados especialmente, que infecten PGP o el sistema
operativo. Este hipottico virus podra disearse para capturar la frase
de contrasea, la clave secreta o los mensajes descifrados, y despus
escribirlos secretamente en un fichero o enviarlos al dueo del virus
por una red. Tambin podra alterar el comportamiento de PGP para que
las firmas no se comprobasen adecuadamente. Este tipo de ataque es ms
barato que el ataque criptoanaltico.

La defensa contra este problema se incluye dentro de la defensa contra
virus en general. Hay diversos programas comerciales anti-virus,
relativamente tiles, y tambin procedimientos higinicos que pueden
reducir en gran manera la posibilidad de una infeccin. Una descripcin
detallada de las medidas contra virus y gusanos queda fuera del alcance
de este documento. PGP no tiene ninguna defensa contra virus, y asume
que su ordenador personal es un entorno de ejecucin seguro. Si aparece
un virus o gusano con esas caractersticas, esperemos que corra
rpidamente la voz para advertir a todo el mundo.

Otro ataque parecido podra darse si alguien hiciese una ingeniosa
imitacin de PGP, que se comportarse como PGP en la mayora de los
aspectos, pero que no funcionase adecuadamente. Por ejemplo, podra
haber sido mutilado para que no comprobase las firmas adecuadamente,
haciendo que se aceptasen certificados falsos. Esta versin "caballo de
Troya" de PGP no sera difcil de crear, ya que el cdigo fuente de PGP
es fcil de encontrar, por lo que cualquiera podra modificarlo y
producir una imitacin de PGP con forma de zombie lobotomizado, que
parecera autntico pero que seguira las rdenes de su diablico amo.
Esta versin caballo de Troya de PGP podra circular ampliamente,
alegando ser ma. Bastante molesto.

Debera tomarse la molestia de obtener su copia de PGP de una fuente
fiable, si esa expresin puede aplicarse realmente. Podra tambin
conseguirlo de varias fuentes independientes, y verificar las copias con
una utilidad de comparacin de ficheros.

Hay otras formas de comprobar si PGP ha sido manipulado, mediante firmas
digitales. Si alguien en quien usted confa firma la versin ejecutable
de PGP, respondiendo del hecho de que no ha sido infectada o manipulada,
puede estar razonablemente seguro de tener una copia buena. Podra
utilizar una versin anterior, de confianza, para comprobar la firma de
la versin sospechosa de PGP. En cualquier caso, esto no ayudara si el
sistema operativo estuviese infectado, ni detectara si la copia
original de PGP.EXE haba sido alterada maliciosamente para comprometer
su capacidad de comprobar firmas. Esta comprobacin tambin asume que
usted tiene una copia buena y de confianza de la clave pblica para
verificar la firma del ejecutable PGP.


Fallos en la seguridad fsica
=----------------------------

Un fallo en la seguridad fsica podra hacer que alguien consiguiese
fsicamente los ficheros de texto normal o los mensajes impresos. Un
oponente resuelto podra conseguirlo por robo, bsqueda en la basura,
bsqueda y captura irrazonable, o soborno, chantaje o infiltracin en el
personal. Algunos de estos ataques son especialmente factibles contra
organizaciones polticas de base, que dependen en gran parte de personal
voluntario. Se ha comentado ampliamente en la prensa que el COINTELPRO
del FBI ha recurrido al robo, la infiltracin y las escuchas ilegales
contra grupos anti-guerra y otros grupos a favor de los derechos
civiles. Mire lo que ocurri en el Hotel Watergate.

No se duerma en un falso sentimiento de seguridad slo por tener una
herramienta criptogrfica. Las tcnicas criptogrficas protegen los
datos solamente mientras estn cifrados-- las violaciones directas de la
seguridad fsica pueden comprometer datos normales o informacin escrita
o hablada.

Este tipo de ataque es ms barato que el criptoanlisis de PGP.


Ataques Tempest {tempestad}
=--------------

Otro tipo de ataque, empleado por oponentes con buen equipamiento,
recurre a la deteccin remota de las seales electromagnticas del
ordenador. Este ataque, caro y bastante laborioso, probablemente sigue
siendo ms barato que el ataque criptoanaltico directo. Una furgoneta
con los instrumentos apropiados puede aparcar cerca de la oficina, y
recoger a distancia todas las pulsaciones de teclas y los mensajes de la
pantalla. As se veran comprometidas todas las contraseas, todos los
mensajes, etc. Este ataque puede frustrarse protegiendo adecuadamente
todo el equipo informtico y los cables de la red, de manera que no
emitan estas seales. Esta tecnologa de proteccin se llama "Tempest",
y la utilizan diversas agencias del Gobierno y contratistas del
ejrcito. Hay proveedores de maquinaria que suministran proteccin
Tempest comercial, aunque puede estar sujeta a algn tipo de licencia
del Gobierno. Por qu cree que el Gobierno querra restringir la
disponibilidad de la proteccin Tempest?


Exposicin en sistemas multiusuario
=----------------------------------

PGP fue diseado originalmente para ordenadores DOS de un solo usuario,
bajo su control fsico directo. Yo utilizo PGP en casa, en mi propio PC,
y, a menos que alguien entre en mi casa o controle mis emisiones
electromagnticas, es probable que no vean mis ficheros de texto normal
ni mis claves secretas.

Pero ahora PGP tambin funciona en sistemas multiusuario como Unix y
VAX/VMS. En sistemas como estos, hay un riesgo mucho mayor de exposicin
para el texto normal o las contraseas. El administrador del sistema en
Unix, o un intruso ingenioso podra leer los ficheros normales, o
utilizar un programa especial para ver las pulsaciones de tecla o leer
qu hay en la pantalla. En un sistema Unix, cualquier usuario puede leer
a distancia la informacin sobre el entorno, simplemente con la orden
"ps". Hay problemas parecidos en mquinas DOS conectadas en red local.
El riesgo que sufre la seguridad depende de cada situacin particular.
Algunos sistemas multiusuario pueden resultar seguros por ser de
confianza todos los usuarios, por tener medidas de seguridad que
protegen de los ataques de intrusos, o slo porque no haya un nmero
suficiente de intrusos interesados. Algunos sistemas Unix son seguros
porque slo tienen un usuario-- hay hasta ordenadores porttiles
utilizando Unix. No sera razonable simplemente excluir PGP de todos los
sistemas Unix.

PGP no se ha diseado para proteger los datos mientras estn en texto
normal, o si se encuentran en un sistema comprometido. Tampoco puede
evitar que un intruso tome complejas medidas para leer la clave secreta
mientras se utiliza. Tendr que detectar estos riesgos en los sistemas
multiusuario, y ajustar sus expectativas y su comportamiento de acuerdo
con ellos. Puede que su situacin sea tal que debera considerar
ejecutar PGP solamente en un sistema aislado, de un solo usuario, bajo
su directo control fsico. Eso es lo que hago yo, y es lo que
recomiendo.


Anlisis de trfico
=------------------

Incluso aunque el atacante no pueda leer el contenido de los mensajes
cifrados, puede inferir alguna informacin til observando de dnde
vienen los mensajes y adnde van, su tamao y la hora del da a la que
se envan. Es parecido a lo que hace un atacante cuando mira la cuenta
de llamadas de larga distancia para ver a quin se ha llamado y durante
cunto tiempo, aunque desconozca el contenido. Esto se llama anlisis de
trfico. PGP por s mismo no protege contra ello. La solucin de este
problema requerira protocolos especializados de comunicacin, diseados
para reducir la exposicin al anlisis en su entorno de comunicacin,
quiz con asesoramiento criptogrfico.


Criptoanlisis
=-------------

Un ataque criptoanaltico caro y formidable podra organizarlo alguien
con vastos recursos informticos, tal como una agencia de informacin
del Gobierno. Podran romper la clave RSA con un nuevo hallazgo secreto
sobre factorizacin. Quiz sea as, pero hay que destacar que en ciertos
casos el Gobierno de los EEUU confa lo bastante en el algoritmo RSA
como para proteger sus propias armas nucleares, segn Ron Rivest. Los
acadmicos civiles han estado atacndolo continuamente y sin xito desde
1978.

Quiz el Gobierno tenga algn mtodo clasificado para romper el
algoritmo de encriptacin convencional IDEA(mr) que utiliza PGP. Eso es
la peor pesadilla de cualquier criptgrafo. No puede existir ninguna
garanta absoluta de seguridad para las implementaciones criptogrficas
prcticas.

An as, parece justificado un cierto optimismo. Los diseadores del
algoritmo IDEA estn entre los mejores criptgrafos de Europa. Ha
aguantado un profundo anlisis de seguridad, as como revisin de otros
colegas entre los mejores criptoanalistas del mundo no clasificado.
Parece tener ciertas ventajas de diseo respecto a DES en cuanto a
resistencia al criptoanlisis diferencial que se ha empleado para romper
DES.

Por otra parte, hasta si este algoritmo tiene algunas debilidades
sutiles an no descubiertas, PGP comprime el texto normal antes de
encriptar, lo que debera reducirlas bastante. El trabajo computacional
que hace falta para romperlo es seguramente mucho ms caro que el valor
del mensaje.

Si su situacin justifica una preocupacin sobre ataques de este
calibre, quiz debiera ponerse en contacto con un asesor en seguridad de
datos para realizar un enfoque personal, hecho a la medida de sus
necesidades. Boulder Software Engineering, cuya direccin y telfono
aparecen al final de este documento, puede proporcionar ese tipo de
servicio.


En resumen, sin una buena proteccin criptogrfica de las comunicaciones
de datos podra haber resultado prcticamente trivial y quiz rutinario
para un oponente interceptar los mensajes, especialmente aquellos
enviados por modem o por un sistema de correo-E. Si utiliza PGP y toma
precauciones razonables, el atacante tendr que emplear mucho ms
esfuerzo y dinero para invadir su intimidad.

Si se protege contra los ataques ms simples, y confa en que su
intimidad no va a ser invadida por un atacante resuelto y con grandes
recursos, probablemente est seguro con PGP. PGP le da una "intimidad
bastante buena".


Consideraciones legales
=======================


Marcas registradas, copyright y garantas
=----------------------------------------

"Pretty Good Privacy", "Phil's Pretty Good Software", y la etiqueta
"Pretty Good" para programas y maquinaria informtica son marcas
registradas de Philip Zimmermann y Phil's Pretty Good Software. PGP es
(c) Copyright Philip R. Zimmermann, 1990-1993. Philip Zimmermann tambin
tiene el copyright del Manual del usuario de PGP, adems del de
cualquier traduccin del manual o del programa.

El autor no asume responsabilidad por los daos que resulten del uso de
este programa, aunque hayan sido causados por defectos en l, y no hace
ninguna declaracin sobre su comerciabilidad o su adaptacin a algn
propsito especfico. Se suministra "tal como es", sin garanta alguna,
explcita o implcita.


Derechos de patente sobre los algoritmos
=---------------------------------------

El sistema RSA de clave pblica fue desarrollado en el MIT, que tiene
una patente sobre l (patente U.S: #4,405,829, emitida el 20 de
Septiembre de 1983). Una compaa de California llamada Public Key
Partners (PKP) tiene la licencia comercial exclusiva para vender y dar
licencias del sistema RSA de clave pblica.

PKP no ha dado ninguna licencia para utilizar su algoritmo RSA en PGP.
El autor de esta implementacin del algoritmo RSA la suministra slo
para uso educativo. La obtencin de la licencia para este algoritmo es
responsabilidad de usted, el usuario, no del autor de la implementacin
informtica. El autor no asume responsabilidad alguna por aquellas
transgresiones de la patente que puedan ocurrir por la utilizacin sin
licencia del algoritmo RSA en el ordenador del usuario sin licencia del
propietario de la patente RSA.

Los usuarios de otros pases deben tener en cuenta que la patente RSA no
tiene efecto fuera de los EEUU, y que no hay patente de RSA en ningn
otro pas. Las agencias federales pueden utilizarlo porque el Gobierno
ya pag el desarrollo de RSA con ayudas de la National Science
Foundation y la Armada estadounidense. Las empresas que ya tienen
licencia de PKP quiz puedan utilizar PGP, dependiendo de sus trminos.

Escrib PGP desde cero, con mi propia implementacin del algoritmo RSA.
Antes de publicar PGP, obtuve una opinin legal formal y por escrito de
un abogado de patentes, con gran experiencia en programas. Estoy
convencido de que publicar PGP como yo lo hice no infringe ninguna ley
de patentes.

No slo adquiri PKP los derechos exclusivos de patente del
criptosistema RSA, sino tambin los de otras tres patentes sobre
esquemas rivales de clave pblica inventados por otros en la Universidad
de Stanford. De esta manera, se ha dado a una compaa la cerradura
legal para casi todos los criptosistemas prcticos de clave pblica.
Incluso parecen estar reclamando derechos de patente sobre el mismo
concepto de criptografa de clave pblica, sin importar qu ingeniosos
nuevos algoritmos originales inventen otros. Encuentro preocupante ese
tipo de monopolio exhaustivo, porque creo que la criptografa de clave
pblica est destinada a convertirse en una tecnologa crucial para la
proteccin de nuestras libertades civiles y de nuestra intimidad dentro
una sociedad cada vez ms conectada. Como poco, pone en riesgo esas
herramientas vitales proporcionando al Gobierno un nico punto de
presin e influencia.

Hay negociaciones en curso con RSA DAta Security Inc (RSADSI), una
empresa hermana de PKP, para legalizar PGP en los EEUU. Se conseguira
integrando RSAREF en PGP. RSAREF es un conjunto de subrutinas de RSADSI
que implementan el algoritmo RSA. Las subrutinas RSAREF tendran que
utilizarse en lugar de las originales de PGP. Hay algunos obstculos
tcnicos para lograrlo, pero puede encontrarse una solucin si las
negociaciones con RSADSI continan favorablemente. Si RSAREF se integra
en PGP, RSADSI dar una licencia para su uso no comercial en los EEUU.
Las versiones PGP de fuera de los EEUU no utilizarn RSAREF, sino la
biblioteca original de PGP, ms rpida, para efectuar los clculos RSA.
RSADSI puede requerir que se cambie el nombre PGP para que todo esto sea
posible. Sigan conectados.

Parece seguro que habr nuevos lanzamientos de PGP, sin importar el
resultado de los problemas de licencia con Public Key Partners. Si PKP
no da licencia para PGP, los futuros lanzamientos de PGP pueden no venir
de m. Hay innumerables aficionados a PGP fuera de los EEUU, y muchos de
ellos son ingenieros de programacin que quieren mejorar PGP y
promocionarlo, aparte de lo que yo pueda hacer. El segundo lanzamiento
de PGP fue el esfuerzo conjunto de un equipo internacional de ingenieros
de programacin, que ha implementado mejoras en PGP con consejos mos
sobre el diseo. El lanzamiento lo hacieron Brako Lankester en los
Pases Bajos y Peter Gutmann en Nueva Zelanda, fuera del alcance de la
ley de patentes de los EEUU. Slo sale en Europa y Nueva Zelanda, pero
puede llegar espontneamente a los EEUU sin mi ayuda ni la de nadie del
equipo de desarrollo de PGP.

El cifrado convencional por bloques IDEA(mr) que utiliza PGP tiene una
patente en Europa, en poder de ETH y una compaa suiza llamada Ascom-
Tech AG. El nmero de patente es PCT/CH91/00117. Las patentes
internacionales estn pendientes. IDEA(mr) es una marca registrada de
Ascom-Tech AG. No se necesita ningn pago de licencia para el uso no
comercial de IDEA. Ascom Tech AG ha dado permiso a PGP para utilizar el
cifrado IDEA, y no pone ninguna restriccin sobre el uso de PGP para
cualquier propsito, incluyendo el comercial. No puede extraerse el
cifrado IDEA de PGP y ponerlo en otro producto comercial sin una
licencia. Los usuarios comerciales de IDEA pueden pedir informacin
sobre licencias a Dieter Profos, Ascom Tech AG, Solothurn Lab, Postfach
151, 4502 Solothurn, Suiza, Tel +41 65 242885, Fax +41 65 235761.

Las rutinas de compresin ZIP en PGP vienen de cdigo fuente libre y
gratuito ("freeware"), con permiso del autor. No conozco ninguna patente
sobre el algoritmo ZIP, pero puede comprobarlo usted mismo.


Licencias y distribucin
=-----------------------

En los EEUU, PKP controla, por medio de la ley de patentes, las
licencias del algoritmo RSA. Sin embargo, yo no pongo ninguna objecin a
que se utilice o distribuya libremente mi programa PGP, sin pagarme
ningn tipo de licencia. Debe mantener los datos de copyright en PGP,
junto con esta documentacin. Sin embargo, si vive usted en los EEUU,
esto puede no satisfacer las obligaciones legales que tiene hacia PKP
por utilizar el algoritmo RSA, tal como se ha mencionado anteriormente.

PGP no es un programa compartido ("shareware"), es un programa libre y
gratuito ("freeware"). Un programa libre prohibido. Publicado como un
servicio a la comunidad. Distribuir PGP gratis animar a mucha ms gente
a utilizarlo, algo que tendr, esperemos, un mayor impacto social. Esto
podra llevar a un conocimiento y utilizacin ms amplios del
criptosistema RSA de clave pblica.

El cdigo fuente de PGP est disponible gratuitamente bajo la "Copyleft"
General Public License {Licencia pblica general "Copyleft"} de la Free
Software Foundation (FSF). Se incluye una copia de esa licencia con el
cdigo fuente de PGP.

Aparte, y quiz en contra de alguna de las estipulaciones de la General
Public License de FSF, son aplicables los siguientes trminos:

1)  Los tratamientos de PGP en revistas o libros pueden incluir
    fragmentos del cdigo fuente de PGP y su documentacin, sin
    restricciones.

2)  Aunque la licencia de FSF permite productos derivados para uso
    general, prohbe productos derivados para uso comercial. A pesar de
    esto, puedo ofrecerle una licencia especial si quiere derivar un
    producto comercial de algunas partes de PGP. Puede haber o no una
    tasa, segn el tipo de acuerdo al que quiera llegar con PKP. La
    conservacin de mi nota de copyright y mi atribucin bastar en
    algunos casos. Llmeme y lo trataremos. Soy muy fcil de contentar.
    Esas licencias no le liberan de los requisitos de la patente.

Distribuya PGP tan ampliamente como le sea posible. Dselo a todos sus
amigos. Si tiene acceso a algunas BBS, enve el lote completo ejecutable
de PGP a tantas como le sea posible. Puede tambin distribuir el cdigo
fuente de PGP, si lo tiene. El lote ejecutable de PGP versin 2.3a para
MSDOS contiene el programa ejecutable, la documentacin, anillos de
claves de ejemplo, incluyendo mi propia clave pblica, y firmas para el
programa y el manual, todo en un fichero comprimido por PKZIP llamado
PGP23A.ZIP. El lote del cdigo fuente de PGP para MSDOS contiene todos
los ficheros del cdigo fuente en C dentro de un fichero comprimido por
PKZIP llamado PGP23SRC.ZIP.

Puede obtener copias y actualizaciones gratuitas de PGP en miles de BBSs
en todo el mundo, o en otras fuentes pblicas, como establecimientos FTP
de Internet. No me pida una copia a m directamente, porque preferira
evitar problemas legales con PKP por el momento. No obstante, puedo
indicarle dnde puede obtenerlo.

Despus de todo este trabajo, debo admitir que no me importara recibir
correo de admiradores de PGP, para calibrar su popularidad. Dgame qu
piensa de l, y cuntos amigos suyos lo utilizan. Tambin son bien
recibidos informes sobre errores, y sugerencias para mejorar PGP. Quiz
un prximo lanzamiento de PGP refleje esas sugerencias.

Este proyecto no ha sido subvencionado, y casi me ha devorado vivo. Esto
quiere decir que no puede contar con que conteste al correo, a menos que
slo necesite una respuesta corta por escrito, e incluya un sobre
franqueado con su direccin. Sin embargo, s contesto el correo-E. Por
favor, escriba en ingls, porque no estoy muy fuerte en otros idiomas.
Si llama y no estoy, es mejor volver a probar despus. No devuelvo
normalmente llamadas a larga distancia, a menos que diga en el mensaje
que puedo llamar a cobro revertido. Si necesita una cantidad
considerable de mi tiempo, estoy disponible como asesor contratado, y
naturalmente devuelvo esas llamadas.

El correo ms incmodo que recibo es de alguna persona bienintencionada
que me enva unos dlares y me pide una copia de PGP. No puedo
envirsela por las amenazas legales de PKP (o an peor-- algunas veces
las peticiones vienen de otros pases, y estara arriesgndome a
quebrantar las leyes de control de exportacin de material
criptogrfico). Hasta en el caso de que no hubiese problemas legales al
enviarles una copia de PGP, normalmente no mandan suficiente dinero para
compensar el tiempo (quiz $50 {unas 7.000 Ptas.} lo sera, si lo
estuviese vendiendo). No tengo la organizacin necesaria para un negocio
de venta por correo de bajo coste y bajo volumen. No puedo simplemente
ignorar la peticin y quedarme con el dinero, porque seguramente lo
consideran el pago por cumplir su encargo. Para devolver el dinero,
tengo que coger el coche y llegar a la oficina de correos para comprar
sellos, porque estas peticiones no suelen incluir un sobre franqueado
con direccin. Tengo adems que escribir una contestacin amable
diciendo que no puedo enviar el programa. Si pospongo la respuesta y
dejo la carta en la mesa, puede quedar enterrada en cuestin de minutos,
y sin volver a ver la luz del da durante meses. Multiplique estas
pequeas molestias por el nmero de peticiones que tengo, y ver el
problema. No basta que el programa sea gratuito?  Sera mucho mejor que
la gente intentase obtener PGP de alguna otra fuente de las muchas que
hay. Si no tiene modem, pida a un amigo que lo consiga para usted. Si no
puede encontrarlo, no me importa responder una rpida llamada de
telfono.

Si alguien quiere prestarse como voluntario para mejorar PGP, hgamelo
saber. Seguro que podra utilizar algo ms de trabajo. Algunas
caractersticas tuvieron que posponerse para poder sacarlo. Desde
entonces, algunos usuarios de PGP han donado su tiempo para transportar
PGP a Unix para estaciones SPARC de Sun, a Ultrix. a VAX/VMS, a OS/2, al
Amiga y al Atari ST. Quiz usted podra ayudar a transportarlo a algn
nuevo entorno. Por favor, dgame si tiene intencin de transportar PGP,
para evitar la duplicacin de esfuerzo, y para evitar que empiece con
una versin obsoleta del cdigo fuente.

Hay tantas traducciones de PGP que la mayora no se distribuye con la
versin normal de PGP, porque necesitara demasiado espacio. Hay "lotes"
de traduccin disponibles en unas cuantas fuentes independientes, y a
veces de forma separada en los mismos centros de distribucin que llevan
el programa PGP. Estos lotes incluyen las versiones traducidas de
LANGUAGE.TXT, PGP.HLP y la Gua de Usuario de PGP. Si quiere hacer la
traduccin a su idioma materno, pngase primero en contacto conmigo para
obtener la informacin ms reciente y las guas generales, y para ver si
ya se ha traducido a ese idioma. Colin Plumb (colin@nyx.cs.du.edu)
mantiene la coleccin completa de los lotes de idiomas.

Las prximas versiones de PGP pueden tener que cambiar el formato de
datos para mensajes, firmas, claves y anillos, para proporcionar nuevas
caractersticas importantes. Esto podra ocasionar problemas de
compatibilidad con esta versin de PGP. Los prximos lanzamientos quiz
vayan con utilidades de conversin para las viejas claves, pero puede
que tenga que deshacerse de los mensajes creados con el antiguo PGP.

Si tiene acceso a Internet (sic), busque anuncios sobre los nuevos
lanzamientos de PGP en los grupos de noticias "sci.crypt" y el propio
grupo de PGP, "alt.security.pgp". Hay tambin una lista de correo
llamada info-pgp, para usuarios que no tienen acceso al grupo de
noticias "alt.security.pgp". Info-pgp tiene como moderador a Hugh
Miller, y puede suscribirse escribindole una carta a info-pgp-
request@lucpul.it.luc.edu. Incluya su nombre y direccin Internet. Si
quiere saber cmo obtener PGP, Hugh puede enviarle una lista de
establecimientos FTP y telfonos de BBSs. Puede encontrarle tambin en
hmiller@lucpul.it.luc.edu


Controles de exportacin
=-----------------------

El Gobierno ha declarado ilegal en muchos casos la exportacin de buena
tecnologa criptogrfica, y esto podra incluir a PGP. Consideran este
tipo de programa como municiones. Viene determinado por voltiles
directivas del Departamento de Estado, no por leyes fijas. No voy a
exportar este programa desde los EEUU ni Canad, en los casos en que sea
ilegal segn las directivas del Departamento de Estado de los EEUU, y no
asumo responsabilidad alguna si otras personas lo exportan por su
cuenta.

Si usted vive fuera de los EEUU o Canad, le aconsejo que no quebrante
las directivas del Departamento de Estado obteniendo PGP de una fuente
en los EEUU. Dado que miles de usuarios locales lo obtuvieron despus de
su publicacin inicial, de alguna manera sali de los EEUU y se extendi
ampliamente por el extranjero, como semillas de diente de len flotando
en el viento. Si PGP ha conseguido llegar a su pas, no creo que
infrinja la ley norteamericana de exportacin si lo obtiene de una
fuente fuera de los EEUU.

A algunos observadores legales con los que he hablado les parece que los
creadores de los controles de exportacin de los EEUU nunca previeron
que se fuesen a aplicar alguna vez a un programa criptogrfico libre y
gratuito que se ha publicado y distribuido a los cuatro vientos. Es
difcil imaginar a un abogado estadounidense intentar iniciar un
procedimiento judicial contra alguien por la "exportacin" de un
programa publicado libremente en los EEUU. Hasta donde saben las
personas con las que he hablado, nunca se ha hecho, a pesar de haber
numerosos ejemplos de transgresiones de las normas de exportacin. No
soy un abogado ni estoy dando consejo legal-- slo intento indicar lo
que parece sentido comn.

Desde la versin 2.0 de PGP, el punto de lanzamiento del programa ha
estado fuera de los EEUU, en ordenadores accesibles pblicamente en
Europa. En cada lanzamiento, lo vuelven a enviar a los EEUU y lo ponen
en ordenadores de acceso pblico en los EEUU activistas de la intimidad
PGP de otros pases. Hay algunas restricciones en los EEUU respecto a la
importacin de municiones, pero no tengo conocimiento de ningn caso en
el que esto se haya aplicado por importar programas criptogrficos a los
EEUU. Imagino que una accin legal de ese tipo sera un buen
espectculo.

Algunos gobiernos imponen castigos severos a cualquier persona dentro
del pas que simplemente utilice comunicaciones encriptadas. En algunos
pases podran incluso fusilarle por ello. Pero si vive en un pas as,
quiz necesite PGP todava ms.


Grupos polticos relacionados con la informtica
================================================

PGP es un programa poltico. Parece apropiado mencionar aqu algunos
grupos activistas relacionados con ordenadores. Se proporcionan detalles
completos sobre estos grupos, y cmo unirse a ellos, en un documento
aparte en el lote de lanzamiento de PGP.

La Electronic Frontier Foundation (EFF) se fund en julio de 1990 para
asegurar la libertad de expresin por medios digitales, con nfasis
particular en la aplicacin de los principios encarnados en la
Constitucin norteamericana y el Acta de Derechos a la comunicacin
basada en ordenadores. Puede encontrarlos en: Electronic Frontier
Foundation, 238 Main Street, Cambridge, MA 02142, EEUU.

La League for Programming Freedom (LPF) es una organizacin de base
formada por catedrticos, estudiantes, hombres de negocios,
programadores y usuarios, dedicada a devolver la libertad de escribir
programas. Consideran las patentes sobre algoritmos de ordenador
perjudiciales para la industria de programacin de los EEUU. Puede
encontrarlos en el nmero 1617-433-7071 o enviando correo Internet a
lpf@uunet.uu.net

Computer Professionals For Social Responsibility (CPSR) da la capacidad
a los profesionales y usuarios de ordenadores para abogar por el uso
responsable de la tecnologa de la informacin, y permite a todos
aquellos que utilizan tecnologa de ordenadores participar en debates
pblicos sobre el impacto de los ordenadores en la sociedad. Puede
encontrarlos en:  1-415-322-3778 en Palo Alto, direccin de correo-E
cpsr@csli.stanford.edu.

Para obtener ms informacin sobre estos grupos, consulte el documento
que va en el lote de lanzamiento de PGP.


Lecturas recomendadas
=====================

1)  Dorothy Denning, "Cryptography and Data Security", Addison-Wesley,
    Reading, MA 1982
2)  Dorothy Denning, "Protecting Public Keys and Signature Keys",
    IEEE Computer, Feb 1983
3)  Martin E. Hellman, "The Mathematics of Public-Key Cryptography,"
    Scientific American, Agosto 1979
4)  Steven Levy, "Crypto Rebels", WIRED, May/June 1993, page 54.
    (Es un artculo "obligatorio" sobre PGP y otros temas relacionados)

Otras lecturas
==============

5)  Ronald Rivest, "The MD5 Message Digest Algorithm",
    MIT Laboratory for Computer Science, 1991
6)  Xuejia Lai, "On the Design and Security of Block Ciphers",
    Institute for Signal and Information Processing, ETH-Zentrum,
    Zurich, Switzerland, 1992
7)  Xuejia Lai, James L. Massey, Sean Murphy, "Markov Ciphers and
    Differential Cryptanalysis", Advances in Cryptology- EUROCRYPT'91
8)  Philip Zimmermann, "A Proposed Standard Format for RSA
    Cryptosystems", Advances in Computer Security, Vol III, editado por
    Rein Turn, Artech House, 1988
9)  Bruce Schneier, "Applied Cryptography: Protocols, Algorithms, and
    Source Code in C", John Wiley & Sons, 1993 (sale en Noviembre)
10) Paul Wallich, "Electronic Envelopes", Scientific American, Feb
    1993, pages 30-32. (Un artculo sobre PGP)


Para ponerse en contacto con el autor
=====================================

Philip Zimmermann se encuentra en:

Boulder Software Engineering
3021 Eleventh Street
Boulder, Colorado 80304  EEUU
Tel +1-303-541-0140 (voz o FAX)  (10:00am - 7:00pm Mountain Time)
Internet:  prz@acm.org



Apndice A: Dnde obtener PGP
=============================

Esta seccin describe cmo obtener el programa libre y gratuito PGP de
criptografa de clave pblica (Pretty Good Privacy) desde un
establecimiento de FTP annima en Internet, o por otras fuentes.

PGP tiene una completa gestin de claves, un esquema de encriptacin
hbrido RSA/convencional, resmenes de mensajes para firmas digitales,
compresin de datos antes de encriptar y un buen diseo ergonmico. PGP
es rpido y tiene muchas prestaciones, con una excelente documentacin.
El cdigo fuente es gratuito.

PGP utiliza el criptosistema RSA, reclamado por una patente de los EEUU
en poder de una empresa llamada Public Key Partners. Los usuarios de PGP
fuera de los EEUU deben tomar nota de que no hay patente de RSA fuera de
los EEUU. Tambin deben tener en cuenta que hay leyes de exportacin en
EEUU y Canad que prohben a sus habitantes exportar programas
criptogrficos como este. Si usted vive fuera de los EEUU, probablemente
no est transgrediendo las leyes de exportacin de los EEUU si lo
obtiene fuera de ese pas.

A continuacin se muestra una pequea muestra de los sitios en los que
se supone que tienen PGP, en junio de 1993. No se garantiza que la
informacin sea correcta. Algunos establecimientos en los EEUU han
retirado PGP alguna vez por temor a la intimidacin legal de los dueos
de la patente de RSA.

Hay dos ficheros de archivo comprimidos en el lanzamiento estndar, con
el nombre del fichero derivado del nmero de versin. Para la versin
2.3a de PGP, debe obtener pgp23A.zip, que contiene el ejecutable binario
DOS y la Gua de Usuario de PGP, y puede obtener opcionalmente
pgp23src.zip, que contiene el cdigo fuente. Estos ficheros pueden
descomprimirse con la utilidad compartida PKUNZIP.EXE de descompresin
de archivos, en sus versin 1.10 o posterior. Los usuarios Unix que no
tengan implementacin de UNZIP pueden encontrar el cdigo fuente en el
fichero comprimido pgp21.src.tar.Z.

Un recordatorio:  Establezca el modo como binary o image para hacer la
transferencia FTP. Cuando reciba con kermit en el PC, indique modo
binario de 8 bits en ambos lados. He aqu unos cuantos establecimientos
Internet que tienen PGP va FTP annimo:

Finlandia:  nic.funet.fi  (128.214.6.100)
            Directorio: /pub/unix/security/crypt/

Italia:     ghost.dsi.unimi.it  (149.132.2.1)
            Directorio: /pub/security/

UK:         src.doc.ic.ac.uk
            Directorio: /computing/security/software/

Para aquellos que no tienen conexin FTP con la red, nic.funet.fi
tambin ofrece los ficheros por correo-E. Para obtener la versin 2.3,
enve el siguiente mensaje a mailserv@nic.funet.fi:

ENCODER uuencode
SEND pub/unix/security/crypt/pgp23src.zip
SEND pub/unix/security/crypt/pgp23.zip

Se depositarn dos ficheros zip en su buzn, como (unos) 15 mensajes
agrupados, en unas 24 horas. Grabe y uudescodifique.

En los EEUU, PGP puede encontrarse en Dios sabe cuntas BBSs, demasiadas
para indicar aqu. En cualquier caso, si no tiene ningn nmero a mano,
aqu tiene algunos para probar.

La BBS GRAPEVINE en Little Rock, Arkansas, ha configurado una cuenta
especial para quien quiera recibir PGP gratis. El SYSOP es Jim Wenzel,
jim.wenzel@grapevine.lrk.ar.us. Estos son los nmeros de telfono, que
deben marcarse en este orden (esto es, el primero corresponde a la lnea
de mayor velocidad):(1-501) 753-6859, (1-501) 753-8121, (1-501) 791-
0124. En la entrada, indique la siguiente informacin:

name: PGP USER        ('PGP' es el nombre, 'USER' el apellido)
password: PGP

PGP tambin est disponible en Fidonet, una gran red informal de BBSs
basadas en PCs y conectadas por modems. Mire en las BBS de su rea. Est
en muchos BBS estadounidenses y del resto del mundo.

En Nueva Zelanda, intente esta BBS (supuestamente gratuita):
    Kappa Crucis:  +64 9 817-3714, -3725, -3324, -8424, -3094, -3393

Las distribuciones binaria y fuente de PGP estn disponibles en la
biblioteca Canadian Broadcasting Corporation, abierta al pblico. Tiene
sucursales en Toronto, Montreal y Vancouver. Pngase en contacto con Max
Allen, +1 416 205-6017 si tiene alguna pregunta.

Para obtener ms informacin sobre la implementacin de PGP para Apple
Macintosh, Commodore Amiga o Atari ST, o para hacer cualquier otra
pregunta sobre cmo obtener PGP para otras plataformas, pngase en
contacto con Hugh Miller en hmiller@lucpul.it.luc.edu.

He aqu unas cuantas personas y sus direcciones electrnicas o nmeros
de telfono para obtener informacin sobre la disponibilidad local de
PGP en algunos pases:

Peter Gutmann                 Hugh Kennedy
pgut1@cs.aukuni.ac.nz         70042.710@compuserve.com
Nueva Zelanda                 Alemania, EC

Branko Lankester              Armando Ramos
lankeste@fwi.uva.nl           armando@clerval.org
+31 2159 42242                +34 48 50 30 98
Pases Bajos                  Navarra, EC

Hugh Miller                   Colin Plumb
hmiller@lucpul.it.luc.edu     colin@nyx.cs.du.edu
(312) 508-2727                Toronto, Ontario, Canada
EEUU

Jean-loup Gailly
jloup@chorus.fr
Francia, EC



-----BEGIN PGP SIGNATURE-----
Version: 2.3a

iQCVAgUBLRYI0nAkxuOrd59xAQFjWgP/U8F1s88ySqehzZONQG+1XA4SWZoMQltR
x66+voNTjD/cgZTF58yw+QJ3E1DJ8QkktLvRC/QBImhUHkG84PWovln3DcZ88uSJ
4BuKyckvu+fxY4IpnFm3TkC8cgZhotFiCygZtYDee/BPCpJzyAvLGehVrUEwyTSB
/UQMqNaKl9A=
=JyNI
-----END PGP SIGNATURE-----
